/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.sql.definition.postgresql;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sklsft.generator.bc.file.command.impl.sql.SqlFileWriteCommand;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;

public class PostgresqlTableFkDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Table table;
    private Map<String, String> fieldMap;

    public PostgresqlTableFkDefinitionFileWriteCommand(Table table) {
        super(table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + "2" + File.separator + table.myPackage.name.toUpperCase(), table.originalName);
        int i;
        this.table = table;
        this.fieldMap = new HashMap<String, String>();
        for (i = 0; i < table.getInsertColumnList().size(); ++i) {
            this.fieldMap.put(((Column)table.getInsertColumnList().get((int)i)).name, "ARG" + i);
        }
        for (i = 0; i < table.columns.size(); ++i) {
            if (((Column)table.columns.get((int)i)).referenceTable == null) continue;
            this.fieldMap.put(((Column)table.columns.get((int)i)).name, "ID_ARG" + i);
        }
    }

    @Override
    public void writeContent() throws IOException {
        this.createTableFks();
        this.writeNotOverridableContent();
    }

    private void createTableFks() {
        int i;
        this.writeLine("-- table foreign keys and indexes --");
        for (i = 1; i < this.table.columns.size(); ++i) {
            if (((Column)this.table.columns.get((int)i)).referenceTable == null) continue;
            this.write("ALTER TABLE " + this.table.name + " ADD CONSTRAINT FK_" + this.table.name + "_" + i + " FOREIGN KEY (" + ((Column)this.table.columns.get((int)i)).name + ") REFERENCES " + ((Column)this.table.columns.get((int)i)).referenceTable.name);
            if (((Column)this.table.columns.get((int)i)).deleteCascade) {
                this.write(" ON DELETE CASCADE");
            }
            this.writeLine(";");
            this.writeLine("/");
            this.skipLine();
        }
        for (i = 1; i < this.table.columns.size(); ++i) {
            if (((Column)this.table.columns.get((int)i)).referenceTable == null) continue;
            this.writeLine("CREATE INDEX FK_" + this.table.name + "_" + i + " ON " + this.table.name + "(" + ((Column)this.table.columns.get((int)i)).name + ");");
            this.writeLine("/");
            this.skipLine();
        }
    }
}

