/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.sql.definition.postgresql;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.sql.SqlFileWriteCommand;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.metadata.DataType;

public class PostgresqlTableDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Table table;
    private String sequenceName;

    public PostgresqlTableDefinitionFileWriteCommand(Table table) {
        super(table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + "1" + File.separator + table.myPackage.name.toUpperCase(), table.originalName);
        this.table = table;
        this.sequenceName = table.name + "_id_seq";
    }

    @Override
    public void writeContent() throws IOException {
        this.createTable();
        if (this.table.myPackage.model.project.audited) {
            this.createAuditTable();
        }
        this.writeNotOverridableContent();
    }

    private void createTable() {
        int i;
        this.writeLine("-- create table --");
        this.writeLine("CREATE TABLE " + this.table.name);
        this.writeLine("(");
        this.write(((Column)this.table.columns.get((int)0)).name + " " + DataType.getPostgresqlType((DataType)((Column)this.table.columns.get((int)0)).dataType));
        for (i = 1; i < this.table.columns.size(); ++i) {
            this.writeLine(",");
            this.write(((Column)this.table.columns.get((int)i)).name + " " + DataType.getPostgresqlType((DataType)((Column)this.table.columns.get((int)i)).dataType));
            if (((Column)this.table.columns.get((int)i)).nullable) {
                this.write(" NULL");
            } else {
                this.write(" NOT NULL");
            }
            if (!((Column)this.table.columns.get((int)i)).unique || i == 1 && this.table.cardinality == 1) continue;
            this.write(" UNIQUE");
        }
        this.skipLine();
        this.writeLine(");");
        this.writeLine("/");
        this.skipLine();
        if (this.table.cardinality > 0) {
            this.write("ALTER TABLE " + this.table.name + " ADD CONSTRAINT UC_" + this.table.name + " UNIQUE (" + ((Column)this.table.columns.get((int)1)).name);
            for (i = 2; i <= this.table.cardinality; ++i) {
                this.write("," + ((Column)this.table.columns.get((int)i)).name);
            }
            this.writeLine(");");
            this.writeLine("/");
            this.skipLine();
        }
        this.writeLine("ALTER TABLE " + this.table.name + " ADD CONSTRAINT PK_" + this.table.name + " PRIMARY KEY (" + ((Column)this.table.columns.get((int)0)).name + ");");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create sequence --");
        this.writeLine("CREATE SEQUENCE " + this.sequenceName);
        this.writeLine("INCREMENT 1");
        this.writeLine("MINVALUE 0");
        this.writeLine("MAXVALUE 9223372036854775807");
        this.writeLine("START 0");
        this.writeLine("CACHE 1;");
        this.writeLine("/");
        this.skipLine();
    }

    private void createAuditTable() {
        this.writeLine("-- table d'audit des elements --");
        this.writeLine("CREATE TABLE " + this.table.name + "_aud");
        this.writeLine("(");
        this.writeLine(((Column)this.table.columns.get((int)0)).name + " integer NOT NULL,");
        this.writeLine("rev integer NOT NULL,");
        this.writeLine("revtype smallint NOT NULL,");
        for (int i = 1; i < this.table.columns.size(); ++i) {
            this.writeLine(((Column)this.table.columns.get((int)i)).name + " " + DataType.getPostgresqlType((DataType)((Column)this.table.columns.get((int)i)).dataType) + " NULL,");
        }
        this.writeLine("CONSTRAINT " + this.table.name + "_aud_pkey PRIMARY KEY (id, rev),");
        this.writeLine("CONSTRAINT " + this.table.name + "_aud_rev FOREIGN KEY (rev)");
        this.writeLine("REFERENCES auditentity (id) MATCH SIMPLE");
        this.writeLine("ON UPDATE NO ACTION ON DELETE NO ACTION");
        this.writeLine(")");
        this.writeLine(";");
        this.skipLine();
    }
}

