/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.sql.definition.oracle;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sklsft.generator.bc.file.command.impl.sql.SqlFileWriteCommand;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;
import org.sklsft.generator.model.metadata.DataType;

public class OracleTableDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Table table;
    private String sequenceName;
    private Map<String, String> fieldMap;

    public OracleTableDefinitionFileWriteCommand(Table table) {
        super(table.myPackage.model.project.sourceFolder + File.separator + Project.BUILD_SCRIPT_FOLDER + File.separator + "1" + File.separator + table.myPackage.name.toUpperCase(), table.originalName);
        int i;
        this.table = table;
        this.sequenceName = table.name + "_id_seq";
        this.fieldMap = new HashMap<String, String>();
        for (i = 0; i < table.getInsertColumnList().size(); ++i) {
            this.fieldMap.put(((Column)table.getInsertColumnList().get((int)i)).name, "ARG" + i);
        }
        for (i = 0; i < table.columns.size(); ++i) {
            if (((Column)table.columns.get((int)i)).referenceTable == null) continue;
            this.fieldMap.put(((Column)table.columns.get((int)i)).name, "ID_ARG" + i);
        }
    }

    @Override
    public void writeContent() throws IOException {
        this.createTable();
        if (this.table.myPackage.model.project.audited) {
            this.createAuditTable();
        }
        this.writeNotOverridableContent();
        this.skipLine();
    }

    private void createTable() {
        int i;
        this.writeLine("-- drop table --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE " + this.table.name + "';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create table --");
        this.writeLine("CREATE TABLE " + this.table.name);
        this.writeLine("(");
        this.write(((Column)this.table.columns.get((int)0)).name + " " + DataType.getOracleType((DataType)((Column)this.table.columns.get((int)0)).dataType));
        for (i = 1; i < this.table.columns.size(); ++i) {
            this.writeLine(",");
            this.write(((Column)this.table.columns.get((int)i)).name + " " + DataType.getOracleType((DataType)((Column)this.table.columns.get((int)i)).dataType));
            if (((Column)this.table.columns.get((int)i)).nullable) {
                this.write(" NULL");
            } else {
                this.write(" NOT NULL");
            }
            if (!((Column)this.table.columns.get((int)i)).unique || i == 1 && this.table.cardinality == 1) continue;
            this.write(" UNIQUE");
        }
        this.writeLine(",");
        this.write("CONSTRAINT UC_" + this.table.name + " UNIQUE (" + ((Column)this.table.columns.get((int)1)).name);
        for (i = 2; i <= this.table.cardinality; ++i) {
            this.write("," + ((Column)this.table.columns.get((int)i)).name);
        }
        this.writeLine(")");
        this.write("USING INDEX (CREATE INDEX UC_" + this.table.name + " ON " + this.table.name + "(" + ((Column)this.table.columns.get((int)1)).name);
        for (i = 2; i <= this.table.cardinality; ++i) {
            this.write("," + ((Column)this.table.columns.get((int)i)).name);
        }
        this.writeLine(") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_IND)");
        this.writeLine(", CONSTRAINT PK_" + this.table.name + " PRIMARY KEY (" + ((Column)this.table.columns.get((int)0)).name + ")");
        this.writeLine("USING INDEX (CREATE INDEX PK_" + this.table.name + " ON " + this.table.name + "(" + ((Column)this.table.columns.get((int)0)).name + ") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_IND)");
        this.writeLine(") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_TBL");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- drop sequence --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP SEQUENCE " + this.sequenceName + "';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create sequence --");
        this.writeLine("CREATE SEQUENCE " + this.sequenceName + " MINVALUE 0 NOMAXVALUE START WITH 0 INCREMENT BY 1 NOCYCLE");
        this.writeLine("/");
        this.skipLine();
    }

    private void createAuditTable() {
        this.writeLine("-- drop audit table --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE " + this.table.name + "_AUD';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create audit table --");
        this.writeLine("CREATE TABLE " + this.table.name + "_AUD");
        this.writeLine("(");
        this.writeLine(((Column)this.table.columns.get((int)0)).name + " int NOT NULL,");
        this.writeLine("REV int NOT NULL,");
        this.writeLine("REVTYPE smallint NOT NULL,");
        for (int i = 1; i < this.table.columns.size(); ++i) {
            this.writeLine(((Column)this.table.columns.get((int)i)).name + " " + DataType.getOracleType((DataType)((Column)this.table.columns.get((int)i)).dataType) + " NULL,");
        }
        this.writeLine("CONSTRAINT PK_" + this.table.name + "_AUD PRIMARY KEY (ID, REV),");
        this.writeLine("CONSTRAINT FK_" + this.table.name + "_AUD FOREIGN KEY (REV)");
        this.writeLine("REFERENCES AUDITENTITY (ID)");
        this.writeLine(") TABLESPACE " + this.table.myPackage.model.project.databaseName + "_AUD");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("CREATE INDEX FK_" + this.table.name + "_AUD ON " + this.table.name + "_AUD(REV)");
        this.writeLine("/");
        this.skipLine();
    }
}

