/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.sql.definition.oracle;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.sql.SqlFileWriteCommand;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.domain.database.Table;

public class OracleMainDefinitionFileWriteCommand
extends SqlFileWriteCommand {
    private Project project;

    public OracleMainDefinitionFileWriteCommand(Project project) {
        super(project.sourceFolder + File.separator + "SQL" + File.separator + "BUILD", "MAIN");
        this.project = project;
    }

    @Override
    public void writeContent() throws IOException {
        this.writeLine("-- drop foreign keys --");
        for (Package myPackage : this.project.model.packages) {
            for (Table table : myPackage.tables) {
                for (int i = 1; i < table.columns.size(); ++i) {
                    if (((Column)table.columns.get((int)i)).referenceTable == null) continue;
                    this.writeLine("BEGIN");
                    this.writeLine("EXECUTE IMMEDIATE 'ALTER TABLE " + table.name + " DROP CONSTRAINT FK_" + table.name + "_" + i + "';");
                    this.writeLine("EXCEPTION");
                    this.writeLine("WHEN OTHERS THEN NULL;");
                    this.writeLine("END;");
                    this.writeLine("/");
                    this.skipLine();
                }
            }
        }
        for (Package myPackage : this.project.model.packages) {
            for (Table table : myPackage.tables) {
                this.writeLine("-- drop definitions for " + table.name + " --");
                String sequenceName = table.name + "_ID_SEQ";
                this.writeLine("-- drop table --");
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE " + table.name + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                if (this.project.audited) {
                    this.writeLine("-- drop audit table --");
                    this.writeLine("BEGIN");
                    this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE " + table.name + "_AUD';");
                    this.writeLine("EXCEPTION");
                    this.writeLine("WHEN OTHERS THEN NULL;");
                    this.writeLine("END;");
                    this.writeLine("/");
                    this.skipLine();
                }
                this.writeLine("-- drop stored procedures --");
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE get_" + table.name.toLowerCase() + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE find_" + table.name.toLowerCase() + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE ins_" + table.name.toLowerCase() + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE ins_" + table.name.toLowerCase() + "_bc';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE upd_" + table.name.toLowerCase() + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE upd_" + table.name.toLowerCase() + "_bc';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE del_" + table.name.toLowerCase() + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP PROCEDURE del_" + table.name.toLowerCase() + "_bc';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
                this.writeLine("-- drop sequence --");
                this.writeLine("BEGIN");
                this.writeLine("EXECUTE IMMEDIATE 'DROP SEQUENCE " + sequenceName + "';");
                this.writeLine("EXCEPTION");
                this.writeLine("WHEN OTHERS THEN NULL;");
                this.writeLine("END;");
                this.writeLine("/");
                this.skipLine();
            }
        }
        if (this.project.audited) {
            this.skipLine();
            this.createAuditTable();
            this.skipLine();
        }
        this.writeNotOverridableContent();
    }

    private void createAuditTable() {
        this.writeLine("-- drop global audit table --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP TABLE AUDITENTITY';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create global audit table --");
        this.writeLine("CREATE TABLE AUDITENTITY");
        this.writeLine("(");
        this.writeLine("ID int NOT NULL,");
        this.writeLine("\"TIMESTAMP\" int NOT NULL,");
        this.writeLine("LOGIN VARCHAR2(255),");
        this.writeLine("CONSTRAINT PK_AUDITENTITY PRIMARY KEY (ID)");
        this.writeLine(") TABLESPACE " + this.project.databaseName + "_AUD");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- drop hibernate sequence --");
        this.writeLine("BEGIN");
        this.writeLine("EXECUTE IMMEDIATE 'DROP SEQUENCE hibernate_sequence';");
        this.writeLine("EXCEPTION");
        this.writeLine("WHEN OTHERS THEN NULL;");
        this.writeLine("END;");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- create hibernate sequence --");
        this.writeLine("CREATE SEQUENCE hibernate_sequence MINVALUE 1 NOMAXVALUE START WITH 1 INCREMENT BY 1 NOCYCLE");
        this.writeLine("/");
        this.skipLine();
        this.writeLine("-- epoch in millis --");
        this.writeLine("CREATE OR REPLACE FUNCTION current_millis RETURN integer");
        this.writeLine("IS");
        this.writeLine("BEGIN");
        this.writeLine("return extract(day    from (systimestamp - timestamp '1970-01-01 00:00:00')) * 86400000");
        this.writeLine("+ (extract(hour   from (systimestamp - timestamp '1970-01-01 00:00:00'))-1) * 3600000");
        this.writeLine("+ extract(minute from (systimestamp - timestamp '1970-01-01 00:00:00')) * 60000");
        this.writeLine("+ extract(second from (systimestamp - timestamp '1970-01-01 00:00:00')) * 1000;");
        this.writeLine("END;");
    }
}

