/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.presentation.jsf.richfaces4;

import org.sklsft.generator.bc.file.command.impl.presentation.XhtmlFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.DataType;

public abstract class JsfXhtmlFileWriteCommand
extends XhtmlFileWriteCommand {
    public JsfXhtmlFileWriteCommand(String folderName, String fileName) {
        super(folderName, fileName);
    }

    protected void writeListComponent(Property property, Bean bean) {
        switch (property.dataType) {
            case BOOLEAN: {
                if (property.nullable) {
                    this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + "/>");
                    break;
                }
                this.writeLine("<h:selectBooleanCheckbox value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + " disabled=" + '\"' + "true" + '\"' + "/>");
                break;
            }
            case DATETIME: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + ">");
                switch (property.format) {
                    case DATE: {
                        this.writeLine("<f:convertDateTime type=\"date\" dateStyle=\"medium\"/>");
                        break;
                    }
                    default: {
                        this.writeLine("<f:convertDateTime type=\"both\" dateStyle=\"medium\"/>");
                    }
                }
                this.writeLine("</h:outputText>");
                break;
            }
            case DOUBLE: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + ">");
                switch (property.format) {
                    case TWO_DECIMALS: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                        break;
                    }
                    case FOUR_DECIMALS: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                        break;
                    }
                    default: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                    }
                }
                this.writeLine("</h:outputText>");
                break;
            }
            case LONG: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + ">");
                this.writeLine("<f:convertNumber pattern=\"#,##0\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case STRING: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + "/>");
                break;
            }
            case TEXT: {
                this.writeLine("<pre class=\"truncated-text\">");
                this.writeLine("#{" + bean.objectName + "." + property.name + "}");
                this.writeLine("</pre>");
                this.writeLine("<rich:tooltip>");
                this.writeLine("<pre>");
                this.writeLine("#{" + bean.objectName + "." + property.name + "}");
                this.writeLine("</pre>");
                this.writeLine("</rich:tooltip>");
            }
        }
    }

    protected void writeInput(Property property, Bean bean) {
        this.writeInput("", property, bean);
    }

    protected void writeInput(String prefix, Property property, Bean bean) {
        this.writeLine("<div class=\"col-xs-12\">");
        if (!property.dataType.equals((Object)DataType.BOOLEAN)) {
            this.writeLine("<label>#{i18n." + bean.objectName + property.capName + "}</label>");
        }
        if (property.comboBoxBean != null) {
            this.writeCombobox(prefix, property, bean);
        } else {
            switch (property.dataType) {
                case BOOLEAN: {
                    this.writeBooleanInput(prefix, property, bean);
                    break;
                }
                case DATETIME: {
                    this.writeDateInput(prefix, property, bean);
                    break;
                }
                case DOUBLE: {
                    this.writeDoubleInput(prefix, property, bean);
                    break;
                }
                case LONG: {
                    this.writeLongInput(prefix, property, bean);
                    break;
                }
                case STRING: {
                    this.writeStringInput(prefix, property, bean);
                    break;
                }
                case TEXT: {
                    this.writeTextInput(prefix, property, bean);
                }
            }
        }
        if (!property.dataType.equals((Object)DataType.BOOLEAN)) {
            this.writeLine("<h:message for=\"" + prefix + bean.objectName + property.capName + '\"' + " styleClass=" + '\"' + "detailErrorMessage" + '\"' + "/>");
        }
        this.writeLine("</div>");
        this.skipLine();
    }

    private void writeCombobox(String prefix, Property property, Bean bean) {
        this.write("<h:selectOneMenu id=\"" + prefix + bean.objectName + property.capName + '\"' + " styleClass=" + '\"' + "form-control" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        if (!property.nullable) {
            this.skipLine();
            this.write(" required=\"true\"");
        }
        if (!property.editable) {
            this.skipLine();
            this.write(" disabled=\"true\"");
        }
        this.writeLine(">");
        block0 : switch (property.dataType) {
            case DATETIME: {
                switch (property.format) {
                    case DATE: {
                        this.writeLine("<f:convertDateTime type=\"date\" dateStyle=\"long\"/>");
                        break block0;
                    }
                }
                this.writeLine("<f:convertDateTime type=\"both\" dateStyle=\"long\"/>");
                break;
            }
            case DOUBLE: {
                switch (property.format) {
                    case TWO_DECIMALS: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                        break block0;
                    }
                    case FOUR_DECIMALS: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                        break block0;
                    }
                }
                this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                break;
            }
            case LONG: {
                this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
                break;
            }
        }
        this.writeLine("<f:selectItems value=\"#{commonView." + property.comboBoxBean.objectName + "Options}" + '\"' + "/>");
        this.writeLine("</h:selectOneMenu>");
    }

    private void writeStringInput(String prefix, Property property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + '\"' + " styleClass=" + '\"' + "form-control" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        if (!property.nullable) {
            this.skipLine();
            this.write("required=\"true\"");
        }
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    private void writeTextInput(String prefix, Property property, Bean bean) {
        this.write("<h:inputTextarea id=\"" + prefix + bean.objectName + property.capName + '\"' + " styleClass=" + '\"' + "form-control" + '\"' + " rows=" + '\"' + "10" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        if (!property.nullable) {
            this.skipLine();
            this.write("required=\"true\"");
        }
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    private void writeBooleanInput(String prefix, Property property, Bean bean) {
        this.writeLine("<div class=\"checkbox\">");
        this.writeLine("<label>");
        this.writeLine("<h:selectBooleanCheckbox id=\"" + prefix + bean.objectName + property.capName + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        if (property.editable) {
            this.writeLine("readonly=\"false\" disabled=\"false\"/>");
        } else {
            this.writeLine("readonly=\"true\" disabled=\"true\"/>");
        }
        this.writeLine("#{i18n." + bean.objectName + property.capName + "}");
        this.writeLine("</label>");
        this.writeLine("</div>");
    }

    private void writeDoubleInput(String prefix, Property property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + '\"' + " styleClass=" + '\"' + "form-control" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        if (!property.nullable) {
            this.skipLine();
            this.write("required=\"true\"");
        }
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine(">");
        switch (property.format) {
            case TWO_DECIMALS: {
                this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                break;
            }
            case FOUR_DECIMALS: {
                this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                break;
            }
            default: {
                this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
            }
        }
        this.writeLine("</h:inputText>");
    }

    private void writeLongInput(String prefix, Property property, Bean bean) {
        this.write("<h:inputText id=\"" + prefix + bean.objectName + property.capName + '\"' + " styleClass=" + '\"' + "form-control" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        if (!property.nullable) {
            this.skipLine();
            this.write("required=\"true\"");
        }
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine(">");
        this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
        this.writeLine("</h:inputText>");
    }

    private void writeDateInput(String prefix, Property property, Bean bean) {
        this.writeLine("<rich:calendar id=\"" + prefix + bean.objectName + property.capName + '\"' + " inputClass=" + '\"' + "form-control" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
        switch (property.format) {
            case DATE: {
                this.write(" datePattern=\"dd MMMM yyyy\"");
                break;
            }
            default: {
                this.write(" datePattern=\"dd MMMM yyyy HH:mm\"");
            }
        }
        if (!property.nullable) {
            this.skipLine();
            this.write("required=\"true\"");
        }
        if (!property.editable) {
            this.skipLine();
            this.write("disabled=\"true\"");
        }
        this.writeLine("/>");
    }

    protected void writeFilter(Property property, Bean bean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"" + bean.objectName + "List, " + bean.objectName + "Scroller" + '\"');
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" >");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\" />");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                break;
            }
            default: {
                this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"" + bean.objectName + "List, " + bean.objectName + "Scroller" + '\"');
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" >");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\" />");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
            }
        }
    }

    protected void writeFilter(Property property, Bean currentBean, Bean parentBean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("<h:inputText id=\"" + currentBean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"" + currentBean.objectName + "List, " + currentBean.objectName + "Scroller" + '\"');
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" >");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\" />");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
                break;
            }
            default: {
                this.writeLine("<h:inputText id=\"" + currentBean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:ajax event=\"keyup\" render=\"" + currentBean.objectName + "List, " + currentBean.objectName + "Scroller" + '\"');
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" >");
                this.writeLine("<a4j:attachQueue requestDelay=\"500\" />");
                this.writeLine("</a4j:ajax>");
                this.writeLine("</h:inputText>");
            }
        }
    }

    public void writeFilterExpression(Property property, Bean bean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{fn:containsIgnoreCase(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case TEXT: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{fn:containsIgnoreCase(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case DATETIME: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{customFilter.filterDate(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case BOOLEAN: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{customFilter.filterBoolean(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            default: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{fn:containsIgnoreCase(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
            }
        }
    }

    public void writeFilterExpression(Property property, Bean currentBean, Bean parentBean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{fn:containsIgnoreCase(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case TEXT: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{fn:containsIgnoreCase(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case DATETIME: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{customFilter.filterDate(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case BOOLEAN: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{customFilter.filterBoolean(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            default: {
                this.writeLine("filterType=\"custom\" filterExpression=\"#{fn:containsIgnoreCase(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
            }
        }
    }
}

