/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.presentation.jsf.richfaces3;

import org.sklsft.generator.bc.file.command.impl.presentation.XhtmlFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;

public abstract class JsfXhtmlFileWriteCommand
extends XhtmlFileWriteCommand {
    public JsfXhtmlFileWriteCommand(String folderName, String fileName) {
        super(folderName, fileName);
    }

    protected void writeListComponent(Property property, Bean bean) {
        switch (property.dataType) {
            case BOOLEAN: {
                if (property.nullable) {
                    this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + "/>");
                    break;
                }
                this.writeLine("<h:selectBooleanCheckbox value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + " disabled=" + '\"' + "true" + '\"' + "/>");
                break;
            }
            case DATETIME: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + ">");
                switch (property.format) {
                    case DATE: {
                        this.writeLine("<f:convertDateTime type=\"date\" dateStyle=\"medium\"/>");
                        break;
                    }
                    default: {
                        this.writeLine("<f:convertDateTime type=\"both\" dateStyle=\"medium\"/>");
                    }
                }
                this.writeLine("</h:outputText>");
                break;
            }
            case DOUBLE: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + ">");
                switch (property.format) {
                    case TWO_DECIMALS: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                        break;
                    }
                    case FOUR_DECIMALS: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                        break;
                    }
                    default: {
                        this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                    }
                }
                this.writeLine("</h:outputText>");
                break;
            }
            case LONG: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + ">");
                this.writeLine("<f:convertNumber pattern=\"#,##0\"/>");
                this.writeLine("</h:outputText>");
                break;
            }
            case STRING: {
                this.writeLine("<h:outputText value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + "/>");
                break;
            }
            case TEXT: {
                this.writeLine("<h:outputText value=\">\"/>");
                this.writeLine("<rich:toolTip style=\"background:white;border:white\">");
                this.writeLine("<h:inputTextarea value=\"#{" + bean.objectName + "." + property.name + "}" + '\"' + " rows=" + '\"' + "10" + '\"' + " readonly=" + '\"' + "true" + '\"' + "/>");
                this.writeLine("</rich:toolTip>");
            }
        }
    }

    protected void writeDetailComponent(Property property, Bean bean) {
        if (!property.editable) {
            switch (property.dataType) {
                case BOOLEAN: {
                    if (property.nullable) {
                        this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                        this.writeLine("readonly=\"true\"/>");
                        break;
                    }
                    this.writeLine("<h:selectBooleanCheckbox id=\"" + bean.objectName + property.capName + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"true\" disabled=\"true\"/>");
                    break;
                }
                case DATETIME: {
                    this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px;background:lightgrey" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"true\">");
                    switch (property.format) {
                        case DATE: {
                            this.writeLine("<f:convertDateTime type=\"date\" dateStyle=\"medium\"/>");
                            break;
                        }
                        default: {
                            this.writeLine("<f:convertDateTime type=\"both\" dateStyle=\"medium\"/>");
                        }
                    }
                    this.writeLine("</h:inputText>");
                    break;
                }
                case DOUBLE: {
                    this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px;background:lightgrey" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"true\">");
                    switch (property.format) {
                        case TWO_DECIMALS: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                            break;
                        }
                        case FOUR_DECIMALS: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                            break;
                        }
                        default: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                        }
                    }
                    this.writeLine("</h:inputText>");
                    break;
                }
                case LONG: {
                    this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px;background:lightgrey" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"true\">");
                    this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
                    this.writeLine("</h:inputText>");
                    break;
                }
                case STRING: {
                    this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px;background:lightgrey" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"true\">");
                    this.writeLine("</h:inputText>");
                    break;
                }
                case TEXT: {
                    this.writeLine("<h:inputTextarea id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:600px;background:lightgrey" + '\"' + " rows=" + '\"' + "10" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"true\">");
                    this.writeLine("</h:inputTextarea>");
                }
            }
        } else if (property.comboBoxBean != null) {
            this.write("<h:selectOneMenu id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
            if (!property.nullable) {
                this.skipLine();
                this.write(" required=\"true\"");
            }
            this.writeLine(">");
            block15 : switch (property.dataType) {
                case DATETIME: {
                    switch (property.format) {
                        case DATE: {
                            this.writeLine("<f:convertDateTime type=\"date\" dateStyle=\"long\"/>");
                            break block15;
                        }
                    }
                    this.writeLine("<f:convertDateTime type=\"both\" dateStyle=\"long\"/>");
                    break;
                }
                case DOUBLE: {
                    switch (property.format) {
                        case TWO_DECIMALS: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                            break block15;
                        }
                        case FOUR_DECIMALS: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                            break block15;
                        }
                    }
                    this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                    break;
                }
                case LONG: {
                    this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
                    break;
                }
            }
            this.writeLine("<f:selectItems value=\"#{commonView." + property.comboBoxBean.objectName + "Options}" + '\"' + "/>");
            this.writeLine("</h:selectOneMenu>");
        } else {
            switch (property.dataType) {
                case BOOLEAN: {
                    if (property.nullable) {
                        this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"' + "/>");
                        break;
                    }
                    this.writeLine("<h:selectBooleanCheckbox id=\"" + bean.objectName + property.capName + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    this.writeLine("readonly=\"false\" disabled=\"false\"/>");
                    break;
                }
                case DATETIME: {
                    this.writeLine("<rich:calendar id=\"" + bean.objectName + property.capName + '\"' + " inputStyle=" + '\"' + "width:280px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    switch (property.format) {
                        case DATE: {
                            this.write(" datePattern=\"dd MMMM yyyy\"");
                            break;
                        }
                        default: {
                            this.write(" datePattern=\"dd MMMM yyyy HH:mm\"");
                        }
                    }
                    if (!property.nullable) {
                        this.skipLine();
                        this.write("required=\"true\"");
                    }
                    this.writeLine("/>");
                    break;
                }
                case DOUBLE: {
                    this.write("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    if (!property.nullable) {
                        this.skipLine();
                        this.write("required=\"true\"");
                    }
                    this.writeLine(">");
                    switch (property.format) {
                        case TWO_DECIMALS: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.00\"/>");
                            break;
                        }
                        case FOUR_DECIMALS: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.0000\"/>");
                            break;
                        }
                        default: {
                            this.writeLine("<f:convertNumber pattern=\"#,##0.########\"/>");
                        }
                    }
                    this.writeLine("</h:inputText>");
                    break;
                }
                case LONG: {
                    this.write("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    if (!property.nullable) {
                        this.skipLine();
                        this.write("required=\"true\"");
                    }
                    this.writeLine(">");
                    this.writeLine("<f:convertNumber integerOnly=\"true\" pattern=\"#,##0\"/>");
                    this.writeLine("</h:inputText>");
                    break;
                }
                case STRING: {
                    this.write("<h:inputText id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:300px" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    if (!property.nullable) {
                        this.skipLine();
                        this.write("required=\"true\"");
                    }
                    this.writeLine("/>");
                    break;
                }
                case TEXT: {
                    this.write("<h:inputTextarea id=\"" + bean.objectName + property.capName + '\"' + " style=" + '\"' + "width:600px" + '\"' + " rows=" + '\"' + "10" + '\"' + " value=" + '\"' + "#{" + bean.objectName + "." + property.name + "}" + '\"');
                    if (!property.nullable) {
                        this.skipLine();
                        this.write("required=\"true\"");
                    }
                    this.writeLine("/>");
                }
            }
        }
    }

    protected void writeFilter(Property property, Bean bean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:support event=\"onkeyup\" reRender=\"" + bean.objectName + "List, " + bean.objectName + "Scroller" + '\"');
                this.writeLine("ignoreDupResponses=\"true\" requestDelay=\"500\"");
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" />");
                this.writeLine("</h:inputText>");
                break;
            }
            default: {
                this.writeLine("<h:inputText id=\"" + bean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:support event=\"onkeyup\" reRender=\"" + bean.objectName + "List, " + bean.objectName + "Scroller" + '\"');
                this.writeLine("ignoreDupResponses=\"true\" requestDelay=\"500\"");
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" />");
                this.writeLine("</h:inputText>");
            }
        }
    }

    protected void writeFilter(Property property, Bean currentBean, Bean parentBean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("<h:inputText id=\"" + currentBean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:support event=\"onkeyup\" reRender=\"" + currentBean.objectName + "List, " + currentBean.objectName + "Scroller" + '\"');
                this.writeLine("ignoreDupResponses=\"true\" requestDelay=\"500\"");
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" />");
                this.writeLine("</h:inputText>");
                break;
            }
            default: {
                this.writeLine("<h:inputText id=\"" + currentBean.objectName + property.capName + "DataTableFilter" + '\"');
                this.writeLine("value=\"#{" + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + "}" + '\"');
                this.writeLine("styleClass=\"dataTableFilter\">");
                this.writeLine("<a4j:support event=\"onkeyup\" reRender=\"" + currentBean.objectName + "List, " + currentBean.objectName + "Scroller" + '\"');
                this.writeLine("ignoreDupResponses=\"true\" requestDelay=\"500\"");
                this.writeLine("oncomplete=\"setCaretToEnd(event);\" />");
                this.writeLine("</h:inputText>");
            }
        }
    }

    public void writeFilterExpression(Property property, Bean bean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("filterExpression=\"#{fn:containsIgnoreCase(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case TEXT: {
                this.writeLine("filterExpression=\"#{fn:containsIgnoreCase(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case DATETIME: {
                this.writeLine("filterExpression=\"#{customFilter.filterDate(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case BOOLEAN: {
                this.writeLine("filterExpression=\"#{customFilter.filterBoolean(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            default: {
                this.writeLine("filterExpression=\"#{fn:containsIgnoreCase(" + bean.objectName + "." + property.name + ", " + bean.listViewObjectName + "." + bean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
            }
        }
    }

    public void writeFilterExpression(Property property, Bean currentBean, Bean parentBean) {
        switch (property.dataType) {
            case STRING: {
                this.writeLine("filterExpression=\"#{fn:containsIgnoreCase(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case TEXT: {
                this.writeLine("filterExpression=\"#{fn:containsIgnoreCase(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case DATETIME: {
                this.writeLine("filterExpression=\"#{customFilter.filterDate(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            case BOOLEAN: {
                this.writeLine("filterExpression=\"#{customFilter.filterBoolean(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
                break;
            }
            default: {
                this.writeLine("filterExpression=\"#{fn:containsIgnoreCase(" + currentBean.objectName + "." + property.name + ", " + parentBean.detailViewObjectName + "." + currentBean.basicViewBean.filterObjectName + "." + property.name + ")}" + '\"' + ">");
            }
        }
    }
}

