/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.presentation.jsf;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sklsft.generator.bc.file.command.impl.conf.PropertiesFileWriteCommand;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;

public class I18nFileWriteCommand
extends PropertiesFileWriteCommand {
    private Project project;

    public I18nFileWriteCommand(Project project) {
        super(project.workspaceFolder + File.separator + project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "resources", "i18n");
        this.project = project;
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("#");
        this.writeLine("# auto generated i18n file");
        this.writeLine("# write modifications between specific code marks");
        this.writeLine("# processed by skeleton-generator");
        this.writeLine("#");
        this.skipLine();
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                this.writeLine("#" + bean.className);
                this.writeLine(bean.objectName + "List=" + bean.listRendering);
                this.writeLine(bean.objectName + "Detail=" + bean.detailRendering);
                for (int i = 1; i < bean.properties.size(); ++i) {
                    Property property = (Property)bean.properties.get(i);
                    if (property.referenceBean != null) {
                        List referencePropertyList = property.getReferencePropertyList();
                        for (Property findProperty : referencePropertyList) {
                            if (property.referenceBean.isEmbedded) {
                                this.writeLine(bean.objectName + findProperty.capName + "=" + findProperty.rendering);
                                continue;
                            }
                            this.writeLine(bean.objectName + property.capName + findProperty.capName + "=" + findProperty.rendering);
                        }
                        continue;
                    }
                    this.writeLine(bean.objectName + property.capName + "=" + property.rendering);
                }
                this.skipLine();
            }
        }
        this.writeNotOverridableContent();
    }
}

