/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.services;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.RelationType;

public class BaseServiceInterfaceFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseServiceInterfaceFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-api" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseServiceInterfacePackageName.replace(".", File.separator), bean.baseServiceInterfaceName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.fullViewBean.className + ";");
        for (OneToOneComponent OneToOneComponent2 : this.bean.oneToOneComponentList) {
            currentBean = OneToOneComponent2.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.ovPackageName + "." + currentBean.fullViewBean.className + ";");
        }
        for (OneToManyComponent uniqueComponent : this.bean.oneToManyComponentList) {
            currentBean = uniqueComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.ovPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.ovPackageName + "." + currentBean.fullViewBean.className + ";");
        }
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseServiceInterfacePackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base service interface file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public interface " + this.bean.baseServiceInterfaceName + " {");
        this.skipLine();
        if (this.bean.hasComboBox) {
            this.writeLine("/**");
            this.writeLine(" * get key list");
            this.writeLine(" */");
            this.writeLine("List<" + ((Property)this.bean.properties.get((int)1)).beanDataType + "> get" + this.bean.className + ((Property)this.bean.properties.get((int)1)).capName + "List();");
            this.skipLine();
        }
        this.createLoadObjectList();
        this.createLoadObject();
        this.createFindObject();
        this.createLoadOneToOneComponent();
        this.createLoadOneToManyComponentList();
        this.createLoadOneToManyComponent();
        this.createCreateObject();
        this.createCreateOneToManyComponent();
        this.createSaveObject();
        this.createSaveOneToOneComponent();
        this.createSaveOneToManyComponent();
        this.createUpdateObject();
        this.createUpdateUniqueComponent();
        this.createUpdateOneToManyComponent();
        this.createDeleteObject();
        this.createDeleteOneToOneComponent();
        this.createDeleteOneToManyComponent();
        this.createDeleteObjectList();
        this.createDeleteOneToManyComponentList();
        this.writeLine("}");
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("List<" + this.bean.basicViewBean.className + "> load" + this.bean.className + "List();");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.basicViewBean.className + "> load" + this.bean.className + "ListFrom" + property.capName + " (Long " + property.name + "Id);");
            this.skipLine();
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine(this.bean.fullViewBean.className + " load" + this.bean.className + "(Long id);");
        this.skipLine();
    }

    private void createFindObject() {
        List findPropertyList = this.bean.getReferenceProperties();
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.write(this.bean.fullViewBean.className + " find" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).beanDataType + " " + ((Property)findPropertyList.get((int)0)).name);
        for (int i = 1; i < findPropertyList.size(); ++i) {
            this.write("," + ((Property)findPropertyList.get((int)i)).beanDataType + " " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(");");
        this.skipLine();
    }

    private void createLoadOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine(currentBean.fullViewBean.className + " load" + currentBean.className + "(Long id);");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("List<" + currentBean.basicViewBean.className + "> load" + currentBean.className + "List(Long id);");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine(currentBean.fullViewBean.className + " load" + currentBean.className + "(Long " + currentBean.objectName + "Id,Long id);");
            this.skipLine();
        }
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine(this.bean.fullViewBean.className + " create" + this.bean.className + "();");
        this.skipLine();
    }

    private void createCreateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine(currentBean.fullViewBean.className + " create" + currentBean.className + "();");
            this.skipLine();
        }
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        this.writeLine("Long save" + this.bean.className + "(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ");");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save object from parent " + parentBean.className);
            this.writeLine(" */");
            this.writeLine("Long save" + this.bean.className + "From" + parentBean.className + "(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ", Long " + parentBean.objectName + "Id);");
            this.skipLine();
        }
    }

    private void createSaveOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ", Long id);");
            this.skipLine();
        }
    }

    private void createSaveOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void save" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ", Long id);");
            this.skipLine();
        }
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("void update" + this.bean.className + "(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ");");
        this.skipLine();
    }

    private void createUpdateUniqueComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void update" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ", Long id);");
            this.skipLine();
        }
    }

    private void createUpdateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void update" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ");");
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("void delete" + this.bean.className + "(Long id);");
        this.skipLine();
    }

    private void createDeleteOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(Long id);");
            this.skipLine();
        }
    }

    private void createDeleteOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("void delete" + currentBean.className + "(Long id);");
            this.skipLine();
        }
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("void delete" + this.bean.className + "List(List<Long> idList);");
        this.skipLine();
    }

    private void createDeleteOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("void delete" + currentBean.className + "List(List<Long> idList);");
            this.skipLine();
        }
    }
}

