/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.services;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.RelationType;

public class BaseServiceImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseServiceImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-services" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseServiceImplPackageName.replace(".", File.separator), bean.baseServiceClassName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.util.Collection;");
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.javaImports.add("import org.springframework.transaction.annotation.Transactional;");
        this.javaImports.add("import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.DAOInterfacePackageName + "." + this.bean.daoInterfaceName + ";");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.javaImports.add("import " + parentBean.myPackage.omPackageName + "." + parentBean.className + ";");
            this.javaImports.add("import " + parentBean.myPackage.DAOInterfacePackageName + "." + parentBean.daoInterfaceName + ";");
        }
        this.javaImports.add("import " + this.bean.myPackage.mapperImplPackageName + "." + this.bean.basicViewBean.mapperClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.mapperImplPackageName + "." + this.bean.fullViewBean.mapperClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.processorImplPackageName + "." + this.bean.processorClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.stateManagerImplPackageName + "." + this.bean.stateManagerClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.baseServiceInterfacePackageName + "." + this.bean.baseServiceInterfaceName + ";");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.ovPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.mapperImplPackageName + "." + currentBean.fullViewBean.mapperClassName + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.ovPackageName + "." + currentBean.basicViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.mapperImplPackageName + "." + currentBean.basicViewBean.mapperClassName + ";");
            this.javaImports.add("import " + currentBean.myPackage.ovPackageName + "." + currentBean.fullViewBean.className + ";");
            this.javaImports.add("import " + currentBean.myPackage.mapperImplPackageName + "." + currentBean.fullViewBean.mapperClassName + ";");
        }
    }

    @Override
    protected void writeContent() throws IOException {
        Bean currentBean;
        this.writeLine("package " + this.bean.myPackage.baseServiceImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base service class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseServiceClassName + " implements " + this.bean.baseServiceInterfaceName + " {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties injected by spring");
        this.writeLine(" */");
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.daoInterfaceName + " " + this.bean.daoObjectName + ";");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("@Autowired");
            this.writeLine("protected " + parentBean.daoInterfaceName + " " + parentBean.daoObjectName + ";");
        }
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.fullViewBean.mapperClassName + " " + this.bean.fullViewBean.mapperObjectName + ";");
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.basicViewBean.mapperClassName + " " + this.bean.basicViewBean.mapperObjectName + ";");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("@Autowired");
            this.writeLine("protected " + currentBean.fullViewBean.mapperClassName + " " + currentBean.fullViewBean.mapperObjectName + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("@Autowired");
            this.writeLine("protected " + currentBean.fullViewBean.mapperClassName + " " + currentBean.fullViewBean.mapperObjectName + ";");
            this.writeLine("@Autowired");
            this.writeLine("protected " + currentBean.basicViewBean.mapperClassName + " " + currentBean.basicViewBean.mapperObjectName + ";");
        }
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.stateManagerClassName + " " + this.bean.stateManagerObjectName + ";");
        this.skipLine();
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.processorClassName + " " + this.bean.processorObjectName + ";");
        this.skipLine();
        if (this.bean.hasComboBox) {
            this.writeLine("/**");
            this.writeLine(" * get key list");
            this.writeLine(" */");
            this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
            this.writeLine("public List<" + ((Property)this.bean.properties.get((int)1)).beanDataType + "> get" + this.bean.className + ((Property)this.bean.properties.get((int)1)).capName + "List() {");
            this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".load" + this.bean.className + "List();");
            this.writeLine("List<" + ((Property)this.bean.properties.get((int)1)).beanDataType + "> " + this.bean.objectName + ((Property)this.bean.properties.get((int)1)).capName + "List = new ArrayList<>(" + this.bean.objectName + "List.size());");
            this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
            this.writeLine(this.bean.objectName + ((Property)this.bean.properties.get((int)1)).capName + "List.add(" + this.bean.objectName + ".get" + ((Property)this.bean.properties.get((int)1)).capName + "());");
            this.writeLine("}");
            this.writeLine("return " + this.bean.objectName + ((Property)this.bean.properties.get((int)1)).capName + "List;");
            this.writeLine("}");
            this.skipLine();
        }
        this.createLoadObjectList();
        this.createLoadObject();
        this.createFindObject();
        this.createLoadOneToOneComponent();
        this.createLoadOneToManyComponentList();
        this.createLoadOneToManyComponent();
        this.createCreateObject();
        this.createCreateOneToManyComponent();
        this.createSaveObject();
        this.createSaveOneToOneComponent();
        this.createSaveOneToManyComponent();
        this.createUpdateObject();
        this.createUpdateOneTOneComponent();
        this.createUpdateOneToManyComponent();
        this.createDeleteObject();
        this.createDeleteOneToOneComponent();
        this.createDeleteOneToManyComponent();
        this.createDeleteObjectList();
        this.createDeleteOneToManyComponentList();
        this.writeLine("}");
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
        this.writeLine("public List<" + this.bean.basicViewBean.className + "> load" + this.bean.className + "List() {");
        this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".load" + this.bean.className + "ListEagerly();");
        this.writeLine("List<" + this.bean.basicViewBean.className + "> result = new ArrayList<>(" + this.bean.objectName + "List.size());");
        this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
        this.writeLine("result.add(this." + this.bean.basicViewBean.mapperObjectName + ".mapFrom(new " + this.bean.basicViewBean.className + "()," + this.bean.objectName + "));");
        this.writeLine("}");
        this.writeLine("return result;");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
            this.writeLine("public List<" + this.bean.basicViewBean.className + "> load" + this.bean.className + "ListFrom" + property.capName + " (Long " + property.name + "Id) {");
            this.writeLine("List<" + this.bean.className + "> " + this.bean.objectName + "List = " + this.bean.daoObjectName + ".load" + this.bean.className + "ListEagerlyFrom" + property.capName + " (" + property.name + "Id);");
            this.writeLine("List<" + this.bean.basicViewBean.className + "> result = new ArrayList<>(" + this.bean.objectName + "List.size());");
            this.writeLine("for (" + this.bean.className + " " + this.bean.objectName + " : " + this.bean.objectName + "List) {");
            this.writeLine("result.add(this." + this.bean.basicViewBean.mapperObjectName + ".mapFrom(new " + this.bean.basicViewBean.className + "()," + this.bean.objectName + "));");
            this.writeLine("}");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
        this.writeLine("public " + this.bean.fullViewBean.className + " load" + this.bean.className + "(Long id) {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
        this.writeLine("return this." + this.bean.fullViewBean.mapperObjectName + ".mapFrom(new " + this.bean.fullViewBean.className + "()," + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createFindObject() {
        int i;
        List findPropertyList = this.bean.getReferenceProperties();
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
        this.write("public " + this.bean.fullViewBean.className + " find" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).beanDataType + " " + ((Property)findPropertyList.get((int)0)).name);
        for (i = 1; i < findPropertyList.size(); ++i) {
            this.write("," + ((Property)findPropertyList.get((int)i)).beanDataType + " " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(") {");
        this.write(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".find" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).name);
        for (i = 1; i < findPropertyList.size(); ++i) {
            this.write(", " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(");");
        this.writeLine("return this." + this.bean.fullViewBean.mapperObjectName + ".mapFrom(new " + this.bean.fullViewBean.className + "()," + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createLoadOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
            this.writeLine("public " + currentBean.fullViewBean.className + " load" + currentBean.className + "(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.objectName + ".get" + currentBean.className + "();");
            this.writeLine("if (" + currentBean.objectName + "==null) {");
            this.writeLine("return new " + currentBean.fullViewBean.className + "();");
            this.writeLine("} else {");
            this.writeLine("return this." + currentBean.fullViewBean.mapperObjectName + ".mapFrom(new " + currentBean.fullViewBean.className + "()," + currentBean.objectName + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
            this.writeLine("public List<" + currentBean.basicViewBean.className + "> load" + currentBean.className + "List(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine("List<" + currentBean.basicViewBean.className + "> result = new ArrayList<>(" + this.bean.objectName + ".get" + currentBean.className + "Collection().size());");
            this.writeLine("for (" + currentBean.className + " " + currentBean.objectName + ":" + this.bean.objectName + ".get" + currentBean.className + "Collection()){");
            this.writeLine("result.add(this." + currentBean.basicViewBean.mapperObjectName + ".mapFrom(new " + currentBean.basicViewBean.className + "()," + currentBean.objectName + "));");
            this.writeLine("}");
            this.writeLine("return result;");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(readOnly=true, value=\"transactionManager\")");
            this.writeLine("public " + currentBean.fullViewBean.className + " load" + currentBean.className + "(Long " + currentBean.objectName + "Id,Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine("for (" + currentBean.className + " collection" + currentBean.className + " : " + this.bean.objectName + ".get" + currentBean.className + "Collection()){");
            this.writeLine("if (collection" + currentBean.className + ".getId().equals(" + currentBean.objectName + "Id)){");
            this.writeLine("return this." + currentBean.fullViewBean.mapperObjectName + ".mapFrom(new " + currentBean.fullViewBean.className + "(),collection" + currentBean.className + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.writeLine("throw new ObjectNotFoundException(\"Invalid one to many component id\");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.fullViewBean.className + " create" + this.bean.className + "() {");
        this.writeLine("return new " + this.bean.fullViewBean.className + "();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createCreateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * create one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("public " + currentBean.fullViewBean.className + " create" + currentBean.className + "() {");
            this.writeLine("return new " + currentBean.fullViewBean.className + "();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
        this.writeLine("public Long save" + this.bean.className + "(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ") {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.fullViewBean.mapperObjectName + ".mapTo(" + this.bean.fullViewBean.objectName + ", new " + this.bean.className + "());");
        this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeSave(" + this.bean.objectName + ");");
        this.writeLine("return " + this.bean.processorObjectName + ".save(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            Bean parentBean = property.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save object from parent " + parentBean.className);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public Long save" + this.bean.className + "From" + parentBean.className + "(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ", Long " + parentBean.objectName + "Id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.fullViewBean.mapperObjectName + ".mapTo(" + this.bean.fullViewBean.objectName + ", new " + this.bean.className + "());");
            this.writeLine(parentBean.className + " " + parentBean.objectName + " = this." + parentBean.daoObjectName + ".load" + parentBean.className + "(" + parentBean.objectName + "Id);");
            this.writeLine(this.bean.objectName + "." + property.setterName + "(" + parentBean.objectName + ");");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeSave(" + this.bean.objectName + ");");
            this.writeLine("return " + this.bean.processorObjectName + ".save(" + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void save" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ", Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = this." + currentBean.fullViewBean.mapperObjectName + ".mapTo(" + currentBean.fullViewBean.objectName + ", new " + currentBean.className + "());");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeSave" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine(this.bean.processorObjectName + ".save" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createSaveOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void save" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ", Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = this." + currentBean.fullViewBean.mapperObjectName + ".mapTo(" + currentBean.fullViewBean.objectName + ", new " + currentBean.className + "());");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeSave" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine(this.bean.processorObjectName + ".save" + currentBean.className + "(" + currentBean.objectName + "," + this.bean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
        this.writeLine("public void update" + this.bean.className + "(" + this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + ") {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load" + this.bean.className + "(" + this.bean.fullViewBean.objectName + ".getId());");
        this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeUpdate(" + this.bean.objectName + ");");
        this.writeLine(this.bean.objectName + " = this." + this.bean.fullViewBean.mapperObjectName + ".mapTo(" + this.bean.fullViewBean.objectName + ", " + this.bean.objectName + ");");
        this.writeLine(this.bean.processorObjectName + ".update" + "(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createUpdateOneTOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void update" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ", Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.objectName + ".get" + currentBean.className + "();");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeUpdate" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(this.bean.objectName + ".set" + currentBean.className + "(this." + currentBean.fullViewBean.mapperObjectName + ".mapTo(" + currentBean.fullViewBean.objectName + ", " + currentBean.objectName + "));");
            this.writeLine(this.bean.processorObjectName + ".update" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createUpdateOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * update one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void update" + currentBean.className + "(" + currentBean.fullViewBean.className + " " + currentBean.fullViewBean.objectName + ") {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = this." + this.bean.daoObjectName + ".load" + currentBean.className + "(" + currentBean.fullViewBean.objectName + ".getId());");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeUpdate" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine(currentBean.objectName + " = this." + currentBean.fullViewBean.mapperObjectName + ".mapTo(" + currentBean.fullViewBean.objectName + ", " + currentBean.objectName + ");");
            this.writeLine(this.bean.processorObjectName + ".update" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
        this.writeLine("public void delete" + this.bean.className + "(Long id) {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + " = " + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
        this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeDelete(" + this.bean.objectName + ");");
        this.writeLine(this.bean.processorObjectName + ".delete" + "(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void delete" + currentBean.className + "(Long id) {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.daoObjectName + ".load" + currentBean.className + "(id);");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("this." + this.bean.processorObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteOneToOneComponent() {
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            Bean currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.objectName);
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void delete" + currentBean.className + "(Long id) {");
            this.writeLine(this.bean.className + " " + this.bean.objectName + " = this." + this.bean.daoObjectName + ".load" + this.bean.className + "(id);");
            this.writeLine(currentBean.className + " " + currentBean.objectName + " = " + this.bean.objectName + ".get" + currentBean.className + "();");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("this." + this.bean.processorObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
        this.writeLine("public void delete" + this.bean.className + "List(List<Long> idList) {");
        this.writeLine(this.bean.className + " " + this.bean.objectName + ";");
        this.writeLine("if (idList != null){");
        this.writeLine("for (Long i:idList){");
        this.writeLine(this.bean.objectName + " = " + this.bean.daoObjectName + ".load" + this.bean.className + "(i);");
        this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeDelete(" + this.bean.objectName + ");");
        this.writeLine(this.bean.processorObjectName + ".delete" + "(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteOneToManyComponentList() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.objectName + " list");
            this.writeLine(" */");
            this.writeLine("@Transactional(rollbackFor=Exception.class, value=\"transactionManager\")");
            this.writeLine("public void delete" + currentBean.className + "List(List<Long> idList) {");
            this.writeLine(currentBean.className + " " + currentBean.objectName + ";");
            this.writeLine("if (idList != null){");
            this.writeLine("for (Long i:idList){");
            this.writeLine(currentBean.objectName + " = " + this.bean.daoObjectName + ".load" + currentBean.className + "(i);");
            this.writeLine(this.bean.stateManagerObjectName + ".checkBeforeDelete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("this." + this.bean.processorObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.writeLine("}");
            this.writeLine("}");
            this.skipLine();
        }
    }
}

