/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.population;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;

public class BeanPopulatorCommandFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BeanPopulatorCommandFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-populator" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.commandPackageName.replace(".", File.separator), bean.className + "Command");
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import org.sklsft.generator.repository.backup.command.Command;");
        this.javaImports.add("import org.sklsft.generator.repository.backup.datasource.impl.BackupCommandArguments;");
        this.javaImports.add("import org.slf4j.Logger;");
        this.javaImports.add("import org.slf4j.LoggerFactory;");
        this.javaImports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.fullViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.ObjectArrayToBeanMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.mapper.impl.StringArrayToBeanMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.mapper.interfaces.ObjectArrayToBeanMapper;");
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.commandPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated bean populator command class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("public class " + this.bean.className + "Command implements Command {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * logger");
        this.writeLine(" */");
        this.writeLine("private static final Logger logger = LoggerFactory.getLogger(" + this.bean.serviceInterfaceName + ".class);");
        this.skipLine();
        this.writeLine("@Autowired");
        this.writeLine("private " + this.bean.serviceInterfaceName + " " + this.bean.serviceObjectName + ";");
        this.skipLine();
        this.writeLine("@Override");
        this.writeLine("public void execute(BackupCommandArguments arguments) {");
        this.writeLine("ObjectArrayToBeanMapper<" + this.bean.fullViewBean.className + "> mapper;");
        this.writeLine("if (arguments.isArgumentsTyped()) {");
        this.writeLine("mapper = new ObjectArrayToBeanMapperImpl<" + this.bean.fullViewBean.className + ">(" + this.bean.fullViewBean.className + ".class);");
        this.writeLine("} else {");
        this.writeLine("mapper = new StringArrayToBeanMapperImpl<" + this.bean.fullViewBean.className + ">(" + this.bean.fullViewBean.className + ".class);");
        this.writeLine("}");
        this.writeLine("for (Object[] args : arguments.getArguments()) {");
        this.writeLine("String message = \"execute " + this.bean.serviceObjectName + ".save" + this.bean.className + " - args : " + '\"' + ";");
        this.writeLine("for (Object arg:args) {");
        this.writeLine("message += \"[\" + arg + \"]\";");
        this.writeLine("}");
        this.writeLine("logger.info(message);");
        this.skipLine();
        this.writeLine("try {");
        this.writeLine(this.bean.fullViewBean.className + " " + this.bean.fullViewBean.objectName + " = mapper.mapFrom(new " + this.bean.fullViewBean.className + "(), args, 1);");
        this.skipLine();
        this.writeLine("this." + this.bean.serviceObjectName + ".save" + this.bean.className + "(" + this.bean.fullViewBean.objectName + ");");
        this.writeLine("} catch (Exception e) {");
        this.writeLine("logger.error(message + \"failed : \" + e.getClass().getSimpleName() + \" - \" + e.getMessage());");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine("}");
    }
}

