/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.mvc.controller.richfaces;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.Package;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;

public class JsfCommonControllerFileWriteCommand
extends JavaFileWriteCommand {
    private Project project;

    public JsfCommonControllerFileWriteCommand(Project project) {
        super(project.workspaceFolder + File.separator + project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + project.model.controllerPackageName.replace(".", File.separator), "CommonController");
        this.project = project;
    }

    @Override
    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import javax.faces.model.SelectItem;");
        this.javaImports.add("import org.springframework.stereotype.Component;");
        this.javaImports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.javaImports.add("import org.springframework.context.annotation.Scope;");
        this.javaImports.add("import org.springframework.web.context.WebApplicationContext;");
        this.javaImports.add("import " + this.project.model.mvcModelPackageName + ".CommonView;");
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent || !bean.hasComboBox) continue;
                this.javaImports.add("import " + bean.myPackage.serviceInterfacePackageName + "." + bean.serviceInterfaceName + ";");
            }
        }
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.project.model.controllerPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated common controller class file");
        this.writeLine(" * <br/>used for loading select items");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Component");
        this.writeLine("@Scope(value=WebApplicationContext.SCOPE_REQUEST)");
        this.writeLine("public class CommonController {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * the view handled by the controller");
        this.writeLine(" */");
        this.writeLine("@Autowired");
        this.writeLine("private CommonView commonView;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * the services used by the controller");
        this.writeLine(" */");
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent || !bean.hasComboBox) continue;
                this.writeLine("@Autowired");
                this.writeLine("private " + bean.serviceInterfaceName + " " + bean.serviceObjectName + ";");
            }
        }
        this.skipLine();
        for (Package myPackage : this.project.model.packages) {
            for (Bean bean : myPackage.beans) {
                if (bean.isComponent || !bean.hasComboBox) continue;
                this.writeLine("/**");
                this.writeLine(" * load combobox items for " + bean.className);
                this.writeLine(" */");
                this.writeLine("public void load" + bean.className + "Options() {");
                this.writeLine("List<SelectItem> options = new ArrayList<SelectItem>();");
                this.writeLine("options.add(new SelectItem(null,\"\"));");
                this.writeLine("List<" + ((Property)bean.properties.get((int)1)).beanDataType + "> " + bean.objectName + ((Property)bean.properties.get((int)1)).capName + "List = this." + bean.serviceObjectName + ".get" + bean.className + ((Property)bean.properties.get((int)1)).capName + "List ();");
                this.writeLine("if (" + bean.objectName + ((Property)bean.properties.get((int)1)).capName + "List != null){");
                this.writeLine("for (" + ((Property)bean.properties.get((int)1)).beanDataType + " " + bean.objectName + ((Property)bean.properties.get((int)1)).capName + ":" + bean.objectName + ((Property)bean.properties.get((int)1)).capName + "List){");
                this.writeLine("options.add(new SelectItem(" + bean.objectName + ((Property)bean.properties.get((int)1)).capName + "));");
                this.writeLine("}");
                this.writeLine("}");
                this.writeLine("this.commonView.set" + bean.className + "Options(options);");
                this.writeLine("}");
                this.skipLine();
            }
        }
        this.writeNotOverridableContent();
        this.writeLine("}");
    }
}

