/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.mvc.controller.richfaces;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;

public class DataTableFilterFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public DataTableFilterFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.filterPackageName.replace(".", File.separator), bean.basicViewBean.filterClassName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.io.Serializable;");
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.filterPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated filter class file");
        this.writeLine(" * <br/>basic representation of filter used along with jsf datatable");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.basicViewBean.filterClassName + " implements Serializable {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.createProperties();
        this.createGettersAndSetters();
        this.writeNotOverridableContent();
        this.writeLine("}");
    }

    private void createProperties() {
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        for (Property property : this.bean.basicViewBean.properties) {
            this.writeLine("private String " + property.name + ";");
        }
        this.skipLine();
    }

    private void createGettersAndSetters() {
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        for (Property property : this.bean.basicViewBean.properties) {
            this.writeLine("public String get" + property.capName + "() {");
            this.writeLine("return this." + property.name + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void set" + property.capName + "(String " + property.name + ") {");
            this.writeLine("this." + property.name + " = " + property.name + ";");
            this.writeLine("}");
            this.skipLine();
        }
        this.skipLine();
    }
}

