/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.mvc.controller.richfaces;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.DetailMode;
import org.sklsft.generator.model.metadata.Visibility;

public abstract class AbstractBaseJsfListControllerFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public AbstractBaseJsfListControllerFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-webapp" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseControllerPackageName.replace(".", File.separator), bean.baseListControllerClassName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.ArrayList;");
        this.javaImports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.javaImports.add("import org.sklsft.commons.mvc.ajax.AjaxMethodTemplate;");
        this.javaImports.add("import org.sklsft.commons.mvc.annotations.AjaxMethod;");
        this.javaImports.add("import " + this.bean.myPackage.model.controllerPackageName + ".CommonController;");
        this.javaImports.add("import " + this.bean.myPackage.model.controllerPackageName + ".BaseController;");
        this.javaImports.add("import " + this.bean.myPackage.serviceInterfacePackageName + "." + this.bean.serviceInterfaceName + ";");
        this.javaImports.add("import " + this.bean.myPackage.listViewPackageName + "." + this.bean.listViewClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.filterPackageName + "." + this.bean.basicViewBean.filterClassName + ";");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.basicViewBean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.fullViewBean.className + ";");
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseControllerPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base list controller class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseListControllerClassName + " extends BaseController {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * services injected by spring");
        this.writeLine(" */");
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.serviceInterfaceName + " " + this.bean.serviceObjectName + ";");
        this.writeLine("@Autowired");
        this.writeLine("protected CommonController commonController;");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * view");
        this.writeLine(" */");
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.listViewClassName + " " + this.bean.listViewObjectName + ";");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.listViewClassName + " get" + this.bean.listViewClassName + "() {");
        this.writeLine("return " + this.bean.listViewObjectName + ";");
        this.writeLine("}");
        this.writeLine("public void set" + this.bean.listViewClassName + "(" + this.bean.listViewClassName + " " + this.bean.listViewObjectName + ") {");
        this.writeLine("this." + this.bean.listViewObjectName + " = " + this.bean.listViewObjectName + ";");
        this.writeLine("}");
        this.skipLine();
        this.createLoad();
        this.createCreateObject();
        this.createSaveObject();
        this.createEditObject();
        this.createUpdateObject();
        this.createDeleteObject();
        this.createDeleteObjectList();
        this.createResetFlters();
        this.writeLine("}");
    }

    private void createLoad() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("public void load() {");
        this.writeLine("this.reset" + this.bean.basicViewBean.filterClassName + "();");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * refresh object list");
        this.writeLine(" */");
        this.writeLine("public void refresh() {");
        this.writeLine("this." + this.bean.listViewObjectName + ".set" + this.bean.className + "List(this." + this.bean.serviceObjectName + ".load" + this.bean.className + "List());");
        this.writeLine("}");
        this.skipLine();
    }

    private void createCreateObject() {
        this.writeLine("/**");
        this.writeLine(" * create object");
        this.writeLine(" */");
        this.writeLine("public void create" + this.bean.className + "() {");
        for (Property property : this.bean.fullViewBean.properties) {
            if (property.comboBoxBean == null || !property.editable) continue;
            this.writeLine("this.commonController.load" + property.comboBoxBean.className + "Options();");
        }
        this.writeLine("this." + this.bean.listViewObjectName + ".setSelected" + this.bean.className + "(this." + this.bean.serviceObjectName + ".create" + this.bean.className + "());");
        this.writeLine("}");
        this.skipLine();
    }

    private void createSaveObject() {
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        if (this.bean.detailMode.equals((Object)DetailMode.MODAL)) {
            this.writeLine("@AjaxMethod(\"" + this.bean.className + ".save" + '\"' + ")");
            this.writeLine("public void save" + this.bean.className + "() {");
            this.writeLine(this.bean.serviceObjectName + ".save" + this.bean.className + "(this." + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "());");
            this.writeLine("this.refresh();");
            this.writeLine("}");
            this.skipLine();
        } else {
            this.writeLine("public void save" + this.bean.className + "() {");
            this.writeLine("executeAjaxMethod(\"" + this.bean.className + ".save" + '\"' + ", new AjaxMethodTemplate() {");
            this.writeLine("@Override");
            this.writeLine("public Object execute() {");
            this.writeLine("return " + this.bean.serviceObjectName + ".save" + this.bean.className + "(" + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "());");
            this.writeLine("}");
            this.writeLine("@Override");
            this.writeLine("public void redirectOnComplete(Object result) {");
            this.writeLine("redirect(\"/sections/" + this.bean.myPackage.name + "/" + this.bean.className.toLowerCase() + "/" + this.bean.className + "Details.jsf?id=" + '\"' + " + result);");
            this.writeLine("}");
            this.writeLine("});");
            this.writeLine("}");
        }
    }

    private void createEditObject() {
        this.writeLine("/**");
        this.writeLine(" * edit object");
        this.writeLine(" */");
        this.writeLine("public void edit" + this.bean.className + "(Long id) {");
        for (Property property : this.bean.fullViewBean.properties) {
            if (property.comboBoxBean == null || property.visibility.equals((Object)Visibility.NOT_VISIBLE) || !property.editable) continue;
            this.writeLine("this.commonController.load" + property.comboBoxBean.className + "Options();");
        }
        this.writeLine(this.bean.listViewObjectName + ".setSelected" + this.bean.className + "(" + this.bean.serviceObjectName + ".load" + this.bean.className + "(id));");
        this.writeLine("}");
        this.skipLine();
    }

    private void createUpdateObject() {
        this.writeLine("/**");
        this.writeLine(" * update object");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".update" + '\"' + ")");
        this.writeLine("public void update" + this.bean.className + "() {");
        this.writeLine(this.bean.serviceObjectName + ".update" + this.bean.className + "(this." + this.bean.listViewObjectName + ".getSelected" + this.bean.className + "());");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteObject() {
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".delete" + '\"' + ")");
        this.writeLine("public void delete" + this.bean.className + "(Long id) {");
        this.writeLine(this.bean.serviceObjectName + ".delete" + this.bean.className + "(id);");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createDeleteObjectList() {
        this.writeLine("/**");
        this.writeLine(" * delete object list");
        this.writeLine(" */");
        this.writeLine("@AjaxMethod(\"" + this.bean.className + ".deleteList" + '\"' + ")");
        this.writeLine("public void delete" + this.bean.className + "List() {");
        this.writeLine("List<Long> ids = new ArrayList<>();");
        this.writeLine("for (" + this.bean.basicViewBean.className + " " + this.bean.objectName + ":" + this.bean.objectName + "ListView.get" + this.bean.className + "List()) {");
        this.writeLine("if (" + this.bean.objectName + ".getSelected()) {");
        this.writeLine("ids.add(" + this.bean.objectName + ".getId());");
        this.writeLine("}");
        this.writeLine("}");
        this.writeLine(this.bean.serviceObjectName + ".delete" + this.bean.className + "List(ids);");
        this.writeLine("this.refresh();");
        this.writeLine("}");
        this.skipLine();
    }

    private void createResetFlters() {
        this.writeLine("/**");
        this.writeLine(" * reset object datatable filter");
        this.writeLine(" */");
        this.writeLine("public void reset" + this.bean.basicViewBean.filterClassName + "() {");
        this.writeLine("this." + this.bean.listViewObjectName + ".set" + this.bean.basicViewBean.filterClassName + "(new " + this.bean.basicViewBean.filterClassName + "());");
        this.writeLine("}");
        this.skipLine();
    }
}

