/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.model;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToMany;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOne;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.domain.database.Column;
import org.sklsft.generator.model.metadata.DataType;
import org.sklsft.generator.model.metadata.DatabaseEngine;

public class EntityBeanFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public EntityBeanFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-model" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.omPackageName.replace(".", File.separator), bean.className);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        Bean currentBean;
        if (this.bean.myPackage.model.project.audited) {
            this.javaImports.add("import org.hibernate.envers.Audited;");
        }
        this.javaImports.add("import java.util.Set;");
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import java.io.Serializable;");
        this.javaImports.add("import javax.persistence.CascadeType;");
        this.javaImports.add("import javax.persistence.Column;");
        this.javaImports.add("import javax.persistence.Entity;");
        this.javaImports.add("import javax.persistence.FetchType;");
        this.javaImports.add("import javax.persistence.GeneratedValue;");
        this.javaImports.add("import javax.persistence.GenerationType;");
        this.javaImports.add("import javax.persistence.Id;");
        this.javaImports.add("import javax.persistence.JoinColumn;");
        this.javaImports.add("import javax.persistence.ManyToOne;");
        this.javaImports.add("import javax.persistence.OneToMany;");
        this.javaImports.add("import javax.persistence.OneToOne;");
        this.javaImports.add("import javax.persistence.SequenceGenerator;");
        this.javaImports.add("import javax.persistence.Table;");
        this.javaImports.add("import javax.persistence.Temporal;");
        this.javaImports.add("import javax.persistence.TemporalType;");
        this.javaImports.add("import javax.persistence.Lob;");
        this.javaImports.add("import org.hibernate.annotations.Fetch;");
        this.javaImports.add("import org.hibernate.annotations.FetchMode;");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null) continue;
            this.javaImports.add("import " + property.referenceBean.myPackage.omPackageName + "." + property.referenceBean.className + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            currentBean = oneToMany.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToOne oneToOne : this.bean.oneToOneList) {
            currentBean = oneToOne.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.omPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated entity class file");
        this.writeLine(" * <br/>write modifications between specific code marks");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.skipLine();
        this.writeLine("@Entity");
        if (this.bean.myPackage.model.project.audited) {
            this.writeLine("@Audited");
        }
        this.writeLine("@Table(name=\"" + this.bean.table.name + '\"' + ")");
        if (this.bean.annotations != null) {
            for (String annotation : this.bean.annotations) {
                this.writeLine(annotation);
            }
        }
        this.write("public class " + this.bean.className + " implements Serializable");
        if (this.bean.interfaces != null) {
            for (String interfaceElem : this.bean.interfaces) {
                this.write(", " + interfaceElem);
            }
        }
        this.writeLine(" {");
        this.skipLine();
        this.writeLine("private static final long serialVersionUID = 1L;");
        this.skipLine();
        this.createNoArgConstructor();
        this.createProperties();
        this.createGettersAndSetters();
        this.writeNotOverridableContent();
        this.write("}");
    }

    private void createNoArgConstructor() {
        this.writeLine("/*");
        this.writeLine(" * no argument constructor");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.className + "(){");
        this.writeLine("}");
        this.skipLine();
    }

    private void createProperties() {
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.writeLine("@Id");
        this.writeLine("@Column(name = \"id\", nullable = false)");
        this.writeLine("@SequenceGenerator(name = \"generator\", sequenceName = \"" + this.bean.table.name + "_id_seq" + '\"' + ", allocationSize=1)");
        this.writeLine("@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = \"generator\")");
        this.writeLine("private Long id;");
        this.skipLine();
        if (this.bean.isComponent && !this.bean.isEmbedded) {
            Bean parentBean = this.bean.myPackage.model.findBean(((Column)this.bean.table.columns.get((int)1)).referenceTable.originalName);
            if (((Column)this.bean.table.columns.get((int)1)).annotations != null) {
                for (String annotation : ((Column)this.bean.table.columns.get((int)1)).annotations) {
                    this.writeLine(annotation);
                }
            }
            this.writeLine("@ManyToOne(fetch = FetchType.LAZY)");
            this.writeLine("@JoinColumn(name = \"" + ((Column)this.bean.table.columns.get((int)1)).name + '\"' + ", nullable = false)");
            this.writeLine("private " + parentBean.className + " " + parentBean.objectName + ";");
            this.skipLine();
        }
        for (int i = 1; i < this.bean.properties.size(); ++i) {
            Property property = (Property)this.bean.properties.get(i);
            if (property.annotations != null) {
                for (String annotation : property.annotations) {
                    this.writeLine(annotation);
                }
            }
            if (property.referenceBean != null) {
                if (!property.embedded) {
                    this.writeLine("@ManyToOne(fetch = FetchType.LAZY)");
                    if (this.bean.isComponent) {
                        this.writeLine("@Fetch(FetchMode.JOIN)");
                    }
                    this.write("@JoinColumn(name = \"" + property.column.name + '\"');
                    if (!property.nullable) {
                        this.write(", nullable = false");
                    }
                    if (property.unique) {
                        this.write(", unique = true");
                    }
                    this.writeLine(")");
                    this.writeLine("private " + property.beanDataType + " " + property.name + ";");
                    this.skipLine();
                    continue;
                }
                this.writeLine("@ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)");
                this.write("@JoinColumn(name = \"" + property.column.name + '\"' + ", unique = true");
                this.write(", nullable = false");
                this.writeLine(")");
                this.writeLine("private " + property.referenceBean.className + " " + property.name + ";");
                this.skipLine();
                continue;
            }
            if (property.dataType.equals((Object)DataType.DATETIME)) {
                this.writeLine("@Temporal(TemporalType.TIMESTAMP)");
            }
            if (property.dataType.equals((Object)DataType.TEXT) && this.bean.myPackage.model.project.databaseEngine.equals((Object)DatabaseEngine.ORACLE)) {
                this.writeLine("@Lob");
            }
            this.write("@Column(name = \"" + property.column.name + '\"');
            if (!property.nullable) {
                this.write(", nullable = false");
            }
            if (property.unique) {
                this.write(", unique = true");
            }
            this.writeLine(")");
            this.writeLine("private " + property.beanDataType + " " + property.name + ";");
            this.skipLine();
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            this.writeLine("@OneToMany(fetch = FetchType.LAZY, mappedBy = \"" + oneToMany.referenceProperty.name + '\"' + ")");
            this.writeLine("private Set <" + oneToMany.referenceBean.className + "> " + oneToMany.collectionName + ";");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            this.write("@OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, orphanRemoval=true");
            this.writeLine(", mappedBy = \"" + oneToManyComponent.parentBean.objectName + '\"' + ")");
            this.writeLine("private Set <" + oneToManyComponent.referenceBean.className + "> " + oneToManyComponent.collectionName + ";");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            this.writeLine("@OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = \"" + oneToOneComponent.parentBean.objectName + '\"' + ")");
            this.writeLine("@Fetch(FetchMode.JOIN)");
            this.writeLine("private " + oneToOneComponent.referenceBean.className + " " + oneToOneComponent.referenceBean.objectName + ";");
            this.skipLine();
        }
        for (OneToOne oneToOne : this.bean.oneToOneList) {
            this.writeLine("@OneToOne(fetch = FetchType.LAZY, mappedBy = \"" + this.bean.objectName + '\"' + ")");
            this.writeLine("@Fetch(FetchMode.JOIN)");
            this.writeLine("private " + oneToOne.referenceBean.className + " " + oneToOne.referenceBean.objectName + ";");
            this.skipLine();
        }
        this.skipLine();
    }

    private void createGettersAndSetters() {
        this.writeLine("/*");
        this.writeLine(" * getters and setters");
        this.writeLine(" */");
        if (this.bean.isComponent && !this.bean.isEmbedded) {
            Bean parentBean = this.bean.myPackage.model.findBean(((Column)this.bean.table.columns.get((int)1)).referenceTable.originalName);
            this.writeLine("public " + parentBean.className + " get" + parentBean.className + "() {");
            this.writeLine("return this." + parentBean.objectName + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void set" + parentBean.className + "(" + parentBean.className + " " + parentBean.objectName + ") {");
            this.writeLine("this." + parentBean.objectName + " = " + parentBean.objectName + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (Property property : this.bean.properties) {
            this.writeLine("public " + property.beanDataType + " " + property.getterName + "() {");
            this.writeLine("return this." + property.name + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void " + property.setterName + "(" + property.beanDataType + " " + property.name + ") {");
            this.writeLine("this." + property.name + " = " + property.name + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToMany oneToMany : this.bean.oneToManyList) {
            this.writeLine("public Set <" + oneToMany.referenceBean.className + "> " + oneToMany.collectionGetterName + " () {");
            this.writeLine("return this." + oneToMany.collectionName + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void " + oneToMany.collectionSetterName + "(Set <" + oneToMany.referenceBean.className + "> " + oneToMany.collectionName + ") {");
            this.writeLine("this." + oneToMany.collectionName + " = " + oneToMany.collectionName + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            this.writeLine("public Set <" + oneToManyComponent.referenceBean.className + "> " + oneToManyComponent.collectionGetterName + " () {");
            this.writeLine("return this." + oneToManyComponent.collectionName + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void " + oneToManyComponent.collectionSetterName + "(Set <" + oneToManyComponent.referenceBean.className + "> " + oneToManyComponent.collectionName + ") {");
            this.writeLine("this." + oneToManyComponent.collectionName + " = " + oneToManyComponent.collectionName + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            this.writeLine("public " + oneToOneComponent.referenceBean.className + " " + oneToOneComponent.getterName + " () {");
            this.writeLine("return this." + oneToOneComponent.referenceBean.objectName + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void " + oneToOneComponent.setterName + " (" + oneToOneComponent.referenceBean.className + " " + oneToOneComponent.referenceBean.objectName + ") {");
            this.writeLine("this." + oneToOneComponent.referenceBean.objectName + " = " + oneToOneComponent.referenceBean.objectName + ";");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToOne oneToOne : this.bean.oneToOneList) {
            this.writeLine("public " + oneToOne.referenceBean.className + " " + oneToOne.getterName + " () {");
            this.writeLine("return this." + oneToOne.referenceBean.objectName + ";");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("public void " + oneToOne.setterName + " (" + oneToOne.referenceBean.className + " " + oneToOne.referenceBean.objectName + ") {");
            this.writeLine("this." + oneToOne.referenceBean.objectName + " = " + oneToOne.referenceBean.objectName + ";");
            this.writeLine("}");
            this.skipLine();
        }
        this.skipLine();
    }
}

