/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.dao;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.RelationType;

public class BaseDaoInterfaceFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseDaoInterfaceFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-repository" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseDAOInterfacePackageName.replace(".", File.separator), bean.baseDaoInterfaceName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseDAOInterfacePackageName + ";");
        this.writeImports();
        this.writeLine("/**");
        this.writeLine(" * auto generated base dao interface file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public interface " + this.bean.baseDaoInterfaceName + " {");
        this.skipLine();
        this.createLoadObjectList();
        this.createLoadObject();
        this.createLoadOneToManyComponent();
        this.createExistsObject();
        this.createFindObject();
        this.createSaveObject();
        this.createDeleteObject();
        this.writeLine("}");
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("List<" + this.bean.className + "> load" + this.bean.className + "List();");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * load object list eagerly");
        this.writeLine(" */");
        this.writeLine("List<" + this.bean.className + "> load" + this.bean.className + "ListEagerly();");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.className + "> load" + this.bean.className + "ListFrom" + property.capName + " (Long " + property.name + "Id);");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * load object list eagerly from list of " + property.referenceBean.objectName);
            this.writeLine(" */");
            this.writeLine("List<" + this.bean.className + "> load" + this.bean.className + "ListEagerlyFrom" + property.capName + " (Long " + property.name + "Id);");
            this.skipLine();
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine(this.bean.className + " load" + this.bean.className + "(Long id);");
        this.skipLine();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * get object");
        this.writeLine(" */");
        this.writeLine(this.bean.className + " get" + this.bean.className + "(Long id);");
        this.skipLine();
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public " + currentBean.className + " load" + currentBean.className + "(Long id);");
            this.skipLine();
        }
    }

    private void createExistsObject() {
        List findPropertyList = this.bean.getReferenceProperties();
        this.writeLine("/**");
        this.writeLine(" * exists object");
        this.writeLine(" */");
        this.write("boolean exists" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).beanDataType + " " + ((Property)findPropertyList.get((int)0)).name);
        for (int i = 1; i < findPropertyList.size(); ++i) {
            this.write("," + ((Property)findPropertyList.get((int)i)).beanDataType + " " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(");");
        this.skipLine();
    }

    private void createFindObject() {
        List findPropertyList = this.bean.getReferenceProperties();
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.write(this.bean.className + " find" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).beanDataType + " " + ((Property)findPropertyList.get((int)0)).name);
        for (int i = 1; i < findPropertyList.size(); ++i) {
            this.write("," + ((Property)findPropertyList.get((int)i)).beanDataType + " " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(");");
        this.skipLine();
    }

    private void createSaveObject() {
        Bean currentBean;
        this.writeLine("/**");
        this.writeLine("* save object");
        this.writeLine("*/");
        this.writeLine("Long save" + this.bean.className + "(" + this.bean.className + " " + this.bean.objectName + ");");
        this.skipLine();
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        Bean currentBean;
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("void delete" + this.bean.className + "(" + this.bean.className + " " + this.bean.objectName + ");");
        this.skipLine();
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ");");
            this.skipLine();
        }
    }
}

