/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.dao;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Alias;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;
import org.sklsft.generator.model.domain.business.Property;
import org.sklsft.generator.model.metadata.RelationType;
import org.springframework.util.StringUtils;

public class BaseDaoHibernateImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseDaoHibernateImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-repository" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseDAOImplPackageName.replace(".", File.separator), bean.baseDaoClassName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import java.util.List;");
        this.javaImports.add("import java.util.Date;");
        this.javaImports.add("import javax.annotation.Resource;");
        this.javaImports.add("import org.hibernate.SessionFactory;");
        this.javaImports.add("import org.hibernate.criterion.Restrictions;");
        this.javaImports.add("import org.hibernate.Criteria;");
        this.javaImports.add("import org.hibernate.FetchMode;");
        this.javaImports.add("import org.springframework.stereotype.Repository;");
        this.javaImports.add("import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;");
        this.javaImports.add("import org.springframework.stereotype.Repository;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.baseDAOInterfacePackageName + "." + this.bean.baseDaoInterfaceName + ";");
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseDAOImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base dao class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("@Repository");
        this.writeLine("public class " + this.bean.baseDaoClassName + " implements " + this.bean.baseDaoInterfaceName + " {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * resources injected with spring");
        this.writeLine(" */");
        this.writeLine("@Resource(name=\"sessionFactory\")");
        this.writeLine("protected SessionFactory sessionFactory;");
        this.skipLine();
        this.createLoadObjectList();
        this.createLoadObject();
        this.createLoadOneToManyComponent();
        this.createExistsObject();
        this.createFindObject();
        this.createSaveObject();
        this.createDeleteObject();
        this.write("}");
    }

    private void createLoadObjectList() {
        this.writeLine("/**");
        this.writeLine(" * load object list");
        this.writeLine(" */");
        this.writeLine("@SuppressWarnings(\"unchecked\")");
        this.writeLine("public List<" + this.bean.className + "> load" + this.bean.className + "List() {");
        this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
        this.writeLine("return criteria.list();");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * load object list eagerly");
        this.writeLine(" */");
        this.writeLine("@SuppressWarnings(\"unchecked\")");
        this.writeLine("public List<" + this.bean.className + "> load" + this.bean.className + "ListEagerly() {");
        this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null) continue;
            this.writeLine("criteria.setFetchMode(\"" + property.name + '\"' + ",FetchMode.JOIN);");
            for (Alias alias : property.referenceBean.getReferenceAliases()) {
                this.writeLine("criteria.setFetchMode(\"" + property.name + "." + alias.propertyName + '\"' + ",FetchMode.JOIN);");
            }
        }
        this.writeLine("return criteria.list();");
        this.writeLine("}");
        this.skipLine();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.relation.equals((Object)RelationType.MANY_TO_ONE)) continue;
            this.writeLine("/**");
            this.writeLine(" * load object list from " + property.name);
            this.writeLine(" */");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + this.bean.className + "> load" + this.bean.className + "ListFrom" + property.capName + " (Long " + property.name + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
            this.writeLine("/**");
            this.writeLine(" * load object list eagerly from " + property.name);
            this.writeLine(" */");
            this.writeLine("@SuppressWarnings(\"unchecked\")");
            this.writeLine("public List<" + this.bean.className + "> load" + this.bean.className + "ListEagerlyFrom" + property.capName + " (Long " + property.name + "Id) {");
            this.writeLine("Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(" + this.bean.className + ".class);");
            this.writeLine("if (" + property.name + "Id == null){");
            this.writeLine("criteria.add(Restrictions.isNull(\"" + property.name + ".id" + '\"' + "));");
            this.writeLine("} else {");
            this.writeLine("criteria.add(Restrictions.eq(\"" + property.name + ".id" + '\"' + ", " + property.name + "Id));");
            this.writeLine("}");
            for (Property prop : this.bean.properties) {
                if (prop.referenceBean == null) continue;
                this.writeLine("criteria.setFetchMode(\"" + prop.name + '\"' + ",FetchMode.JOIN);");
                for (Alias alias : prop.referenceBean.getReferenceAliases()) {
                    this.writeLine("criteria.setFetchMode(\"" + prop.name + "." + alias.propertyName + '\"' + ",FetchMode.JOIN);");
                }
            }
            this.writeLine("return criteria.list();");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createLoadObject() {
        this.writeLine("/**");
        this.writeLine(" * load object");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.className + " load" + this.bean.className + "(Long id) {");
        this.writeLine("return (" + this.bean.className + ")this.sessionFactory.getCurrentSession().load(" + this.bean.className + ".class,id);");
        this.writeLine("}");
        this.skipLine();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * get object");
        this.writeLine(" */");
        this.writeLine("public " + this.bean.className + " get" + this.bean.className + "(Long id) {");
        this.writeLine("return (" + this.bean.className + ")this.sessionFactory.getCurrentSession().get(" + this.bean.className + ".class,id);");
        this.writeLine("}");
        this.skipLine();
        this.skipLine();
    }

    private void createLoadOneToManyComponent() {
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            Bean currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * load one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public " + currentBean.className + " load" + currentBean.className + "(Long id) {");
            this.writeLine("return (" + currentBean.className + ")this.sessionFactory.getCurrentSession().load(" + currentBean.className + ".class,id);");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createExistsObject() {
        int i;
        List findPropertyList = this.bean.getReferenceProperties();
        List findAliasList = this.bean.getReferenceAliases();
        this.writeLine("/**");
        this.writeLine(" * exists object");
        this.writeLine(" */");
        this.write("public boolean exists" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).beanDataType + " " + ((Property)findPropertyList.get((int)0)).name);
        for (i = 1; i < findPropertyList.size(); ++i) {
            this.write("," + ((Property)findPropertyList.get((int)i)).beanDataType + " " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(") {");
        this.write("if (" + ((Property)findPropertyList.get((int)0)).name + " == null");
        for (i = 1; i < findPropertyList.size(); ++i) {
            this.write(" && " + ((Property)findPropertyList.get((int)i)).name + " == null");
        }
        this.writeLine(") {");
        this.writeLine("return false;");
        this.writeLine("}");
        this.write(this.bean.className + " " + this.bean.objectName + " = (" + this.bean.className + ")this.sessionFactory.getCurrentSession().createCriteria(");
        this.writeLine(this.bean.className + ".class)");
        for (Alias alias : findAliasList) {
            this.writeLine(".createAlias(\"" + alias.propertyName + '\"' + "," + '\"' + alias.name + '\"' + ")");
        }
        for (Property property : findPropertyList) {
            if (StringUtils.isEmpty((Object)property.joinedAliasName)) {
                this.writeLine(".add(Restrictions.eq(\"" + property.lastPropertyName + '\"' + "," + property.name + "))");
                continue;
            }
            this.writeLine(".add(Restrictions.eq(\"" + property.joinedAliasName + "." + property.lastPropertyName + '\"' + "," + property.name + "))");
        }
        this.writeLine(".uniqueResult();");
        this.writeLine("return " + this.bean.objectName + " != null;");
        this.writeLine("}");
        this.skipLine();
    }

    private void createFindObject() {
        int i;
        List findPropertyList = this.bean.getReferenceProperties();
        List findAliasList = this.bean.getReferenceAliases();
        this.writeLine("/**");
        this.writeLine(" * find object");
        this.writeLine(" */");
        this.write("public " + this.bean.className + " find" + this.bean.className + "(" + ((Property)findPropertyList.get((int)0)).beanDataType + " " + ((Property)findPropertyList.get((int)0)).name);
        for (i = 1; i < findPropertyList.size(); ++i) {
            this.write("," + ((Property)findPropertyList.get((int)i)).beanDataType + " " + ((Property)findPropertyList.get((int)i)).name);
        }
        this.writeLine(") {");
        this.write("if (" + ((Property)findPropertyList.get((int)0)).name + " == null");
        for (i = 1; i < findPropertyList.size(); ++i) {
            this.write(" && " + ((Property)findPropertyList.get((int)i)).name + " == null");
        }
        this.writeLine(") {");
        this.writeLine("return null;");
        this.writeLine("}");
        this.write(this.bean.className + " " + this.bean.objectName + " = (" + this.bean.className + ")this.sessionFactory.getCurrentSession().createCriteria(");
        this.writeLine(this.bean.className + ".class)");
        for (Alias alias : findAliasList) {
            this.writeLine(".createAlias(\"" + alias.propertyName + '\"' + "," + '\"' + alias.name + '\"' + ")");
        }
        for (Property property : findPropertyList) {
            if (StringUtils.isEmpty((Object)property.joinedAliasName)) {
                this.writeLine(".add(Restrictions.eq(\"" + property.lastPropertyName + '\"' + "," + property.name + "))");
                continue;
            }
            this.writeLine(".add(Restrictions.eq(\"" + property.joinedAliasName + "." + property.lastPropertyName + '\"' + "," + property.name + "))");
        }
        this.writeLine(".uniqueResult();");
        this.writeLine("if (" + this.bean.objectName + " == null) {");
        this.writeLine("throw new ObjectNotFoundException(\"" + this.bean.className + ".notFound" + '\"' + ");");
        this.writeLine("} else {");
        this.writeLine("return " + this.bean.objectName + ";");
        this.writeLine("}");
        this.writeLine("}");
        this.skipLine();
    }

    private void createSaveObject() {
        Bean currentBean;
        this.writeLine("/**");
        this.writeLine(" * save object");
        this.writeLine(" */");
        this.writeLine("public Long save" + this.bean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("return (Long)this.sessionFactory.getCurrentSession().save(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(currentBean.objectName + ".set" + this.bean.className + "(" + this.bean.objectName + ");");
            this.writeLine("this.sessionFactory.getCurrentSession().save(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + this.bean.className + " " + this.bean.objectName + ", " + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(currentBean.objectName + ".set" + this.bean.className + "(" + this.bean.objectName + ");");
            this.writeLine("this.sessionFactory.getCurrentSession().save(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }

    private void createDeleteObject() {
        Bean currentBean;
        this.writeLine("/**");
        this.writeLine(" * delete object");
        this.writeLine(" */");
        this.writeLine("public void delete" + this.bean.className + "(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("this.sessionFactory.getCurrentSession().delete(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("this.sessionFactory.getCurrentSession().delete(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("this.sessionFactory.getCurrentSession().delete(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
    }
}

