/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.bc.processor;

import java.io.File;
import java.io.IOException;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.OneToManyComponent;
import org.sklsft.generator.model.domain.business.OneToOneComponent;

public class BaseProcessorImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;

    public BaseProcessorImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-component" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseProcessorImplPackageName.replace(".", File.separator), bean.baseProcessorClassName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        Bean currentBean;
        this.javaImports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.DAOInterfacePackageName + "." + this.bean.daoInterfaceName + ";");
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.javaImports.add("import " + currentBean.myPackage.omPackageName + "." + currentBean.className + ";");
        }
    }

    @Override
    protected void writeContent() throws IOException {
        Bean currentBean;
        this.writeLine("package " + this.bean.myPackage.baseProcessorImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base processor class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.writeLine("public class " + this.bean.baseProcessorClassName + " {");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties injected by spring");
        this.writeLine(" */");
        this.writeLine("@Autowired");
        this.writeLine("protected " + this.bean.daoInterfaceName + " " + this.bean.daoObjectName + ";");
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * process save");
        this.writeLine(" */");
        this.writeLine("public Long save(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("return " + this.bean.daoObjectName + ".save" + this.bean.className + "(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * process save one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + "," + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine(this.bean.daoObjectName + ".save" + currentBean.className + "(" + this.bean.objectName + ", " + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * process save one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void save" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + "," + this.bean.className + " " + this.bean.objectName + ") {");
            this.writeLine(this.bean.daoObjectName + ".save" + currentBean.className + "(" + this.bean.objectName + ", " + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("/**");
        this.writeLine(" * process update");
        this.writeLine(" */");
        this.writeLine("public void update(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * process update one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void update" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * process update one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void update" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("/**");
        this.writeLine(" * process delete");
        this.writeLine(" */");
        this.writeLine("public void delete(" + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.daoObjectName + ".delete" + this.bean.className + "(" + this.bean.objectName + ");");
        this.writeLine("}");
        this.skipLine();
        for (OneToOneComponent oneToOneComponent : this.bean.oneToOneComponentList) {
            currentBean = oneToOneComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * process delete one to one component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(this.bean.daoObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        for (OneToManyComponent oneToManyComponent : this.bean.oneToManyComponentList) {
            currentBean = oneToManyComponent.referenceBean;
            this.writeLine("/**");
            this.writeLine(" * process delete one to many component " + currentBean.className);
            this.writeLine(" */");
            this.writeLine("public void delete" + currentBean.className + "(" + currentBean.className + " " + currentBean.objectName + ") {");
            this.writeLine(this.bean.daoObjectName + ".delete" + currentBean.className + "(" + currentBean.objectName + ");");
            this.writeLine("}");
            this.skipLine();
        }
        this.writeLine("}");
    }
}

