/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java.bc.mapper;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sklsft.generator.bc.file.command.impl.java.JavaFileWriteCommand;
import org.sklsft.generator.model.domain.business.Bean;
import org.sklsft.generator.model.domain.business.Property;

public class BaseBasicViewMapperImplFileWriteCommand
extends JavaFileWriteCommand {
    private Bean bean;
    private Set<String> daoSet;

    public BaseBasicViewMapperImplFileWriteCommand(Bean bean) {
        super(bean.myPackage.model.project.workspaceFolder + File.separator + bean.myPackage.model.project.projectName + "-business-component" + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + bean.myPackage.baseMapperImplPackageName.replace(".", File.separator), bean.basicViewBean.baseMapperClassName);
        this.bean = bean;
    }

    @Override
    protected void fetchSpecificImports() {
        this.daoSet = new HashSet<String>();
        this.javaImports.add("import org.sklsft.commons.mapper.impl.BasicMapperImpl;");
        this.javaImports.add("import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;");
        this.javaImports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.javaImports.add("import " + this.bean.myPackage.omPackageName + "." + this.bean.className + ";");
        this.javaImports.add("import " + this.bean.myPackage.ovPackageName + "." + this.bean.basicViewBean.className + ";");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible()) continue;
            if (!property.embedded) {
                boolean test = this.daoSet.add(property.referenceBean.daoObjectName);
                if (!test) continue;
                this.javaImports.add("import " + property.referenceBean.myPackage.DAOInterfacePackageName + "." + property.referenceBean.daoInterfaceName + ";");
                continue;
            }
            this.javaImports.add("import " + property.referenceBean.myPackage.omPackageName + "." + property.referenceBean.className + ";");
            for (Property embeddedProperty : property.referenceBean.properties) {
                boolean test;
                if (embeddedProperty.referenceBean == null || !embeddedProperty.visibility.isListVisible() || !(test = this.daoSet.add(embeddedProperty.referenceBean.daoObjectName))) continue;
                this.javaImports.add("import " + embeddedProperty.referenceBean.myPackage.DAOInterfacePackageName + "." + embeddedProperty.referenceBean.daoInterfaceName + ";");
            }
        }
    }

    @Override
    protected void writeContent() throws IOException {
        this.writeLine("package " + this.bean.myPackage.baseMapperImplPackageName + ";");
        this.skipLine();
        this.writeImports();
        this.skipLine();
        this.writeLine("/**");
        this.writeLine(" * auto generated base mapper class file");
        this.writeLine(" * <br/>no modification should be done to this file");
        this.writeLine(" * <br/>processed by skeleton-generator");
        this.writeLine(" */");
        this.write("public class " + this.bean.basicViewBean.baseMapperClassName);
        this.writeLine(" extends BasicMapperImpl<" + this.bean.basicViewBean.className + ", " + this.bean.className + "> {");
        this.skipLine();
        this.writeLine("public " + this.bean.basicViewBean.baseMapperClassName + "() {");
        this.writeLine("super(" + this.bean.basicViewBean.className + ".class, " + this.bean.className + ".class);");
        this.writeLine("}");
        this.skipLine();
        this.writeLine("/*");
        this.writeLine(" * properties");
        this.writeLine(" */");
        this.daoSet = new HashSet<String>();
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible()) continue;
            if (!property.embedded) {
                boolean test = this.daoSet.add(property.referenceBean.daoObjectName);
                if (!test) continue;
                this.writeLine("@Autowired");
                this.writeLine("protected " + property.referenceBean.daoInterfaceName + " " + property.referenceBean.daoObjectName + ";");
                continue;
            }
            for (Property embeddedProperty : property.referenceBean.properties) {
                boolean test;
                if (embeddedProperty.referenceBean == null || !embeddedProperty.visibility.isListVisible() || !(test = this.daoSet.add(embeddedProperty.referenceBean.daoObjectName))) continue;
                this.writeLine("@Autowired");
                this.writeLine("protected " + embeddedProperty.referenceBean.daoInterfaceName + " " + embeddedProperty.referenceBean.daoObjectName + ";");
            }
        }
        this.skipLine();
        this.createMappingFrom();
        this.createMappingTo();
        this.writeLine("}");
    }

    private void createMappingFrom() {
        this.writeLine("/**");
        this.writeLine(" * mapping view from object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.basicViewBean.className + " mapFrom(" + this.bean.basicViewBean.className + " " + this.bean.basicViewBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.basicViewBean.objectName + " = super.mapFrom(" + this.bean.basicViewBean.objectName + ", " + this.bean.objectName + ");");
        this.writeLine(this.bean.basicViewBean.objectName + ".setSelected(false);");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible()) continue;
            if (property.embedded) {
                this.writeMapEmbeddedToView(property);
                continue;
            }
            this.writeMapReferenceToView(property);
        }
        this.writeLine("return " + this.bean.basicViewBean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
    }

    private void writeMapReferenceToView(Property property) {
        List referencePropertyList = property.referenceBean.getReferenceProperties();
        if (property.nullable) {
            this.writeLine("if (" + this.bean.objectName + "." + property.getterName + "() != null) {");
            for (Property referenceProperty : referencePropertyList) {
                this.writeLine(this.bean.basicViewBean.objectName + "." + property.setterName + referenceProperty.capName + "(" + this.bean.objectName + "." + property.fetchName + "." + referenceProperty.fetchName + ");");
            }
            this.writeLine("}");
        } else {
            for (Property findProperty : referencePropertyList) {
                this.writeLine(this.bean.basicViewBean.objectName + "." + property.setterName + findProperty.capName + "(" + this.bean.objectName + "." + property.getterName + "()." + findProperty.fetchName + ");");
            }
        }
    }

    private void writeMapEmbeddedToView(Property property) {
        Bean embeddedBean = property.referenceBean;
        for (int i = 1; i < embeddedBean.properties.size(); ++i) {
            Property embeddedProperty = (Property)embeddedBean.properties.get(i);
            if (embeddedProperty.referenceBean != null) {
                List referencePropertyList = embeddedProperty.referenceBean.getReferenceProperties();
                if (embeddedProperty.nullable) {
                    this.writeLine("if (" + this.bean.objectName + "." + property.getterName + "()." + embeddedProperty.getterName + "() != null) {");
                    for (Property referenceProperty : referencePropertyList) {
                        this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.setterName + referenceProperty.capName + "(" + this.bean.objectName + "." + property.fetchName + "." + embeddedProperty.fetchName + "." + referenceProperty.fetchName + ");");
                    }
                    this.writeLine("}");
                    continue;
                }
                for (Property referenceProperty : referencePropertyList) {
                    this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.setterName + referenceProperty.capName + "(" + this.bean.objectName + "." + property.fetchName + "." + embeddedProperty.fetchName + "." + referenceProperty.fetchName + ");");
                }
                continue;
            }
            this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.setterName + "(" + this.bean.objectName + "." + property.fetchName + "." + embeddedProperty.fetchName + ");");
        }
    }

    private void createMappingTo() {
        this.writeLine("/**");
        this.writeLine(" * mapping view to object");
        this.writeLine(" */");
        this.writeLine("@Override");
        this.writeLine("public " + this.bean.className + " mapTo(" + this.bean.basicViewBean.className + " " + this.bean.basicViewBean.objectName + ", " + this.bean.className + " " + this.bean.objectName + ") {");
        this.writeLine(this.bean.objectName + " = super.mapTo(" + this.bean.basicViewBean.objectName + ", " + this.bean.objectName + ");");
        for (Property property : this.bean.properties) {
            if (property.referenceBean == null || !property.visibility.isListVisible()) continue;
            if (property.embedded) {
                this.writeMapEmbeddedToObject(property);
                continue;
            }
            this.writeMapReferenceToObject(property);
        }
        this.writeLine("return " + this.bean.objectName + ";");
        this.writeLine("}");
        this.skipLine();
    }

    private void writeMapReferenceToObject(Property property) {
        List referencePropertyList = property.referenceBean.getReferenceProperties();
        this.writeLine(this.bean.objectName + "." + property.setterName + "(" + property.referenceBean.daoObjectName + ".find" + property.referenceBean.className + "(");
        this.writeLine(this.bean.basicViewBean.objectName + "." + property.getterName + ((Property)referencePropertyList.get((int)0)).capName + "()");
        for (int j = 1; j < referencePropertyList.size(); ++j) {
            this.writeLine("," + this.bean.basicViewBean.objectName + "." + property.getterName + ((Property)referencePropertyList.get((int)j)).capName + "()");
        }
        this.writeLine("));");
    }

    private void writeMapEmbeddedToObject(Property property) {
        Bean embeddedBean = property.referenceBean;
        this.writeLine(embeddedBean.className + " " + embeddedBean.objectName + " = " + this.bean.objectName + "." + property.getterName + "();");
        this.writeLine("if (" + embeddedBean.objectName + " == null) {");
        this.writeLine(embeddedBean.objectName + " = new " + embeddedBean.className + "();");
        this.writeLine(this.bean.objectName + "." + property.setterName + "(" + embeddedBean.objectName + ");");
        this.writeLine("}");
        for (int i = 1; i < embeddedBean.properties.size(); ++i) {
            Property embeddedProperty = (Property)embeddedBean.properties.get(i);
            if (!embeddedProperty.visibility.isListVisible()) continue;
            if (embeddedProperty.referenceBean != null) {
                List referencePropertyList = embeddedProperty.referenceBean.getReferenceProperties();
                this.writeLine(embeddedBean.objectName + "." + embeddedProperty.setterName + "(" + embeddedProperty.referenceBean.daoObjectName + ".find" + embeddedProperty.referenceBean.className + "(");
                this.writeLine(this.bean.basicViewBean.objectName + "." + embeddedProperty.getterName + ((Property)referencePropertyList.get((int)0)).capName + "()");
                for (int j = 1; j < referencePropertyList.size(); ++j) {
                    this.writeLine("," + this.bean.basicViewBean.objectName + "." + embeddedProperty.getterName + ((Property)referencePropertyList.get((int)j)).capName + "()");
                }
                this.writeLine("));");
                continue;
            }
            this.writeLine(embeddedBean.objectName + "." + embeddedProperty.setterName + "(" + this.bean.basicViewBean.objectName + "." + embeddedProperty.getterName + "());");
        }
    }
}

