/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.bc.file.command.impl.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.sklsft.generator.bc.file.command.impl.SingleFileWriteCommand;
import org.sklsft.generator.model.metadata.FileType;

public abstract class JavaFileWriteCommand
extends SingleFileWriteCommand {
    protected Set<String> javaImports = new TreeSet<String>();

    public JavaFileWriteCommand(String folderName, String fileName) {
        super(folderName, fileName, FileType.JAVA);
    }

    private final void fetchImports() throws IOException {
        if (Files.exists(this.filePath, new LinkOption[0])) {
            List<String> lines = Files.readAllLines(this.filePath, this.fileType.getEncoding());
            for (String line : lines) {
                if (!line.startsWith("import ")) continue;
                this.javaImports.add(line);
            }
        }
    }

    protected abstract void fetchSpecificImports();

    protected final void writeImports() throws IOException {
        this.fetchImports();
        this.fetchSpecificImports();
        for (String javaImport : this.javaImports) {
            this.writeLine(javaImport);
        }
    }
}

