/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.generator.command;

import org.sklsft.generator.bc.file.executor.FileWriteCommandTree;
import org.sklsft.generator.bl.services.interfaces.CodeGenerator;
import org.sklsft.generator.bl.services.interfaces.ProjectLoader;
import org.sklsft.generator.bl.services.interfaces.ProjectMetaDataService;
import org.sklsft.generator.model.domain.Project;
import org.sklsft.generator.model.metadata.DatabaseEngine;
import org.sklsft.generator.model.metadata.PersistenceMode;
import org.sklsft.generator.model.metadata.ProjectMetaData;
import org.sklsft.generator.model.metadata.SkeletonType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ProjectInitializerLauncher {
    private static final Logger logger = LoggerFactory.getLogger(ProjectInitializerLauncher.class);

    public static void main(String[] args) {
        try (FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext("classpath:applicationContext-generator-command.xml");){
            FileWriteCommandTree tree;
            Project project;
            logger.info("Context loaded");
            ProjectMetaData projectMetaData = ProjectInitializerLauncher.buildProjectMetaData(args);
            CodeGenerator codeWriter = (CodeGenerator)appContext.getBean(CodeGenerator.class);
            try {
                logger.info("start loading project");
                ProjectLoader projectLoader = (ProjectLoader)appContext.getBean(ProjectLoader.class);
                project = projectLoader.loadProject(projectMetaData);
                logger.info("loading project " + project.projectName + " completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable x2) {
                            var2_2.addSuppressed(x2);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start persisting project");
                ProjectMetaDataService projectMetaDataService = (ProjectMetaDataService)appContext.getBean(ProjectMetaDataService.class);
                projectMetaDataService.initProjectMetaData(projectMetaData);
                logger.info("persisting project completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable x2) {
                            var2_2.addSuppressed(x2);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start copying resources");
                tree = codeWriter.buildFileImportTree(project);
                codeWriter.generateCode(tree);
                logger.info("copying resources completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable x2) {
                            var2_2.addSuppressed(x2);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
            try {
                logger.info("start writing configuration");
                tree = codeWriter.buildConfigurationTree(project);
                codeWriter.generateCode(tree);
                logger.info("writing configuration completed");
            }
            catch (Exception e) {
                logger.error("failed", (Throwable)e);
                if (appContext != null) {
                    if (var2_2 != null) {
                        try {
                            appContext.close();
                        }
                        catch (Throwable x2) {
                            var2_2.addSuppressed(x2);
                        }
                    } else {
                        appContext.close();
                    }
                }
                return;
            }
        }
    }

    private static ProjectMetaData buildProjectMetaData(String[] args) {
        if (args.length < 11) {
            throw new IllegalArgumentException("11 arguments are mandatory");
        }
        ProjectMetaData projectMetaData = new ProjectMetaData();
        projectMetaData.setPersistenceMode(PersistenceMode.XML);
        projectMetaData.setWorkspaceFolder(args[0]);
        projectMetaData.setDomainName(args[1]);
        projectMetaData.setProjectName(args[2]);
        projectMetaData.setSkeletonType(SkeletonType.valueOf((String)args[3]));
        projectMetaData.setDatabaseEngine(DatabaseEngine.valueOf((String)args[4]));
        projectMetaData.setDatabaseName(args[5]);
        projectMetaData.setDatabaseDNS(args[6]);
        projectMetaData.setDatabasePort(args[7]);
        projectMetaData.setDatabaseUserName(args[8]);
        projectMetaData.setDatabasePassword(args[9]);
        projectMetaData.setAudited(Boolean.valueOf(args[10]).booleanValue());
        return projectMetaData;
    }
}

