/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.aspect;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.RequestMapping;

@Aspect
@Order(value=2)
public class LoggingAspect {
    private static final Logger logger = LoggerFactory.getLogger(LoggingAspect.class);

    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public Object handleLogging(ProceedingJoinPoint joinPoint) throws Throwable {
        long start = System.currentTimeMillis();
        logger.info("Request : " + this.getRequestDescription(joinPoint));
        try {
            Object proceed = joinPoint.proceed();
            long elapsedTime = System.currentTimeMillis() - start;
            logger.info("Response : OK, Time: " + elapsedTime + " ms");
            return proceed;
        }
        catch (Exception e) {
            logger.error("Response : NOK, " + e.getMessage());
            throw e;
        }
    }

    private String getRequestDescription(ProceedingJoinPoint joinPoint) {
        Method proxiedMethod;
        RequestMapping requestMapping;
        RequestMapping requestMapping2;
        String url = "";
        String method = "";
        Class<?> proxiedClass = joinPoint.getTarget().getClass();
        if (proxiedClass.isAnnotationPresent(RequestMapping.class) && (requestMapping2 = proxiedClass.getAnnotation(RequestMapping.class)).value() != null && requestMapping2.value().length > 0) {
            url = String.valueOf(url) + requestMapping2.value()[0];
        }
        if ((requestMapping = (proxiedMethod = ((MethodSignature)joinPoint.getSignature()).getMethod()).getAnnotation(RequestMapping.class)).value() != null && requestMapping.value().length > 0) {
            url = String.valueOf(url) + requestMapping.value()[0];
        }
        if (requestMapping.method() != null && requestMapping.method().length > 0) {
            method = requestMapping.method()[0].name();
        }
        return String.valueOf(method) + " " + url;
    }
}

