/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.examples.springboot.controllers;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Controller
public class GreetingController {
    @Autowired
    InternalResourceViewResolver internalResourceViewResolver;

    @GetMapping(value={"/greeting/{type}"})
    public String greeting(@PathVariable String type, @RequestParam(name="name", required=false, defaultValue="World") String name, Model model) {
        model.addAttribute("name", (Object)name);
        model.addAttribute("date", (Object)new Date().toString());
        return (type.equals("ftl") ? "freemarker/" : "") + "greeting";
    }

    @GetMapping(value={"/greeting"})
    public View greetingJsp(@RequestParam(name="name", required=false, defaultValue="World") String name, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("name", (Object)name);
        return this.internalResourceViewResolver.resolveViewName("greeting", request.getLocale());
    }

    @GetMapping(value={"/greetingError"})
    public View greetingError(@RequestParam(name="name", required=false, defaultValue="World") String name, Model model, HttpServletRequest request) throws Exception {
        throw new RuntimeException("Whoops");
    }

    @GetMapping(value={"/greeting/json"})
    @ResponseBody
    public String greetingJson(@RequestParam(name="pjax", required=false) Boolean pjax, Model model, HttpServletResponse response) {
        if (pjax == null || pjax.equals(true)) {
            response.setContentType("text/json");
        }
        return String.format("{ decorated: %s}", pjax != null && pjax.equals(false));
    }
}

