/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.email;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openfact.email.EmailFileModel;
import org.openfact.email.EmailUserModel;
import org.openfact.models.OrganizationModel;

public class EmailTemplateConfiguration {
    private OrganizationModel organization;
    private EmailUserModel user;
    private List<EmailFileModel> attachments;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public EmailTemplateConfiguration(OrganizationModel organization, EmailUserModel user) {
        this.organization = organization;
        this.user = user;
    }

    public EmailTemplateConfiguration setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public EmailTemplateConfiguration setAttachments(List<EmailFileModel> attachments) {
        this.attachments = attachments;
        return this;
    }

    public String getOrganizationName() {
        if (this.organization.getDisplayNameHtml() != null) {
            return this.organization.getDisplayNameHtml();
        }
        if (this.organization.getDisplayName() != null) {
            return this.organization.getDisplayName();
        }
        return this.organization.getName().substring(0, 1).toUpperCase() + this.organization.getName().substring(1);
    }

    public String getOrganizationDisplayName() {
        return this.organization.getDisplayName();
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public EmailUserModel getUser() {
        return this.user;
    }

    public List<EmailFileModel> getAttachments() {
        return this.attachments;
    }

    public OrganizationModel getOrganization() {
        return this.organization;
    }
}

