/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models.utils;

import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.common.util.MultivaluedHashMap;
import org.openfact.component.ComponentModel;
import org.openfact.components.utils.ComponentUtil;
import org.openfact.events.admin.AdminEvent;
import org.openfact.events.admin.AuthDetails;
import org.openfact.models.AdminJobReport;
import org.openfact.models.DocumentLineModel;
import org.openfact.models.DocumentModel;
import org.openfact.models.JobReportModel;
import org.openfact.models.OrganizationModel;
import org.openfact.models.SendEventModel;
import org.openfact.provider.ProviderConfigProperty;
import org.openfact.representations.idm.AdminEventRepresentation;
import org.openfact.representations.idm.AuthDetailsRepresentation;
import org.openfact.representations.idm.ComponentRepresentation;
import org.openfact.representations.idm.ConfigPropertyRepresentation;
import org.openfact.representations.idm.DocumentRepresentation;
import org.openfact.representations.idm.JobReportRepresentation;
import org.openfact.representations.idm.OrganizationEventsConfigRepresentation;
import org.openfact.representations.idm.OrganizationRepresentation;
import org.openfact.representations.idm.PostalAddressRepresentation;
import org.openfact.representations.idm.SendEventRepresentation;

@Stateless
public class ModelToRepresentation {
    @Inject
    private ComponentUtil componentUtil;

    public OrganizationRepresentation toRepresentation(OrganizationModel organization, boolean internal) {
        OrganizationRepresentation rep = new OrganizationRepresentation();
        rep.setId(organization.getId());
        rep.setOrganization(organization.getName());
        rep.setDescription(organization.getDescription());
        rep.setEnabled(Boolean.valueOf(organization.isEnabled()));
        if (organization.getCreatedTimestamp() != null) {
            rep.setCreatedTimestamp(Date.from(organization.getCreatedTimestamp().atZone(ZoneId.systemDefault()).toInstant()));
        }
        rep.setAdditionalAccountId(organization.getAdditionalAccountId());
        rep.setAssignedIdentificationId(organization.getAssignedIdentificationId());
        rep.setRegistrationName(organization.getRegistrationName());
        rep.setSupplierName(organization.getSupplierName());
        PostalAddressRepresentation postalAddressRep = new PostalAddressRepresentation();
        postalAddressRep.setPostalAddressId(organization.getPostalAddressId());
        postalAddressRep.setStreetName(organization.getStreetName());
        postalAddressRep.setCitySubdivisionName(organization.getCitySubdivisionName());
        postalAddressRep.setCityName(organization.getCityName());
        postalAddressRep.setCountrySubentity(organization.getCountrySubentity());
        postalAddressRep.setDistrict(organization.getDistrict());
        postalAddressRep.setCountryIdentificationCode(organization.getCountryIdentificationCode());
        rep.setPostalAddress(postalAddressRep);
        rep.setEmailTheme(organization.getEmailTheme());
        rep.setReportTheme(organization.getReportTheme());
        rep.setInternationalizationEnabled(Boolean.valueOf(organization.isInternationalizationEnabled()));
        if (organization.getSupportedLocales() != null) {
            rep.setSupportedLocales(new HashSet());
            rep.getSupportedLocales().addAll(organization.getSupportedLocales());
        }
        rep.setDefaultLocale(organization.getDefaultLocale());
        rep.setTaskFirstTime(organization.getTaskFirstTime());
        rep.setTaskDelay(Long.valueOf(organization.getTaskDelay()));
        rep.setTasksEnabled(Boolean.valueOf(organization.isTasksEnabled()));
        rep.setDefaultCurrency(organization.getDefaultCurrency());
        if (organization.getSupportedCurrencies() != null) {
            rep.setSupportedCurrencies(new HashSet());
            rep.getSupportedCurrencies().addAll(organization.getSupportedCurrencies());
        }
        rep.setEventsEnabled(Boolean.valueOf(organization.isEventsEnabled()));
        if (organization.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(organization.getEventsExpiration()));
        }
        if (organization.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList(organization.getEventsListeners()));
        }
        if (organization.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList(organization.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(organization.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(organization.isAdminEventsDetailsEnabled()));
        rep.setSmtpServer(new HashMap(organization.getSmtpConfig()));
        rep.setAttributes(new HashMap(organization.getAttributes()));
        if (internal) {
            // empty if block
        }
        return rep;
    }

    public DocumentRepresentation toRepresentation(DocumentModel model, boolean includeLine) {
        DocumentRepresentation rep = new DocumentRepresentation();
        rep.setId(model.getId());
        rep.setDocumentId(model.getDocumentId());
        rep.setDocumentType(model.getDocumentType());
        if (model.getCreatedTimestamp() != null) {
            rep.setCreatedTimestamp(Date.from(model.getCreatedTimestamp().atZone(ZoneId.systemDefault()).toInstant()));
        }
        rep.setEnabled(model.isEnabled());
        rep.setDocumentCurrencyCode(model.getDocumentCurrencyCode());
        rep.setCustomerRegistrationName(model.getCustomerRegistrationName());
        rep.setCustomerAssignedAccountId(model.getCustomerAssignedAccountId());
        rep.setCustomerElectronicMail(model.getCustomerElectronicMail());
        if (model.getAttributes() != null && !model.getAttributes().isEmpty()) {
            HashMap attrs = new HashMap();
            attrs.putAll(model.getAttributes());
            rep.setAttributes(attrs);
        }
        if (model.getRequiredActions() != null) {
            rep.setRequiredActions(new HashSet());
            rep.getRequiredActions().addAll(model.getRequiredActions());
        }
        Function<DocumentModel, DocumentRepresentation> attachedDocumentRepFunction = documentModel -> {
            DocumentRepresentation documentRepresentation = new DocumentRepresentation();
            documentRepresentation.setId(documentModel.getId());
            documentRepresentation.setDocumentId(documentModel.getDocumentId());
            documentRepresentation.setDocumentType(documentModel.getDocumentType());
            return documentRepresentation;
        };
        if (model.getAttachedDocumentsAsOrigin() != null && !model.getAttachedDocumentsAsOrigin().isEmpty()) {
            rep.setAttachedDocumentsAsOrigin(model.getAttachedDocumentsAsOrigin().stream().map(attachedDocumentRepFunction).collect(Collectors.toList()));
        }
        if (model.getAttachedDocumentsAsDestiny() != null && !model.getAttachedDocumentsAsDestiny().isEmpty()) {
            rep.setAttachedDocumentsAsDestiny(model.getAttachedDocumentsAsDestiny().stream().map(attachedDocumentRepFunction).collect(Collectors.toList()));
        }
        if (includeLine && model.getDocumentLines() != null && !model.getDocumentLines().isEmpty()) {
            List documentLines = model.getDocumentLines().stream().map(DocumentLineModel::getAttributes).collect(Collectors.toList());
            rep.setDocumentLines(documentLines);
        }
        return rep;
    }

    public OrganizationEventsConfigRepresentation toEventsConfigReprensetation(OrganizationModel organization) {
        OrganizationEventsConfigRepresentation rep = new OrganizationEventsConfigRepresentation();
        rep.setEventsEnabled(organization.isEventsEnabled());
        if (organization.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(organization.getEventsExpiration()));
        }
        if (organization.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList(organization.getEventsListeners()));
        }
        if (organization.getEnabledEventTypes() != null) {
            rep.setEnabledEventTypes(new LinkedList(organization.getEnabledEventTypes()));
        }
        rep.setAdminEventsEnabled(Boolean.valueOf(organization.isAdminEventsEnabled()));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(organization.isAdminEventsDetailsEnabled()));
        return rep;
    }

    public AdminEventRepresentation toRepresentation(AdminEvent adminEvent) {
        AdminEventRepresentation rep = new AdminEventRepresentation();
        rep.setTime(adminEvent.getTime());
        rep.setOrganizationId(adminEvent.getOrganizationId());
        if (adminEvent.getAuthDetails() != null) {
            rep.setAuthDetails(this.toRepresentation(adminEvent.getAuthDetails()));
        }
        rep.setOperationType(adminEvent.getOperationType().toString());
        if (adminEvent.getResourceType() != null) {
            rep.setResourceType(adminEvent.getResourceType().toString());
        }
        rep.setResourcePath(adminEvent.getResourcePath());
        rep.setRepresentation(adminEvent.getRepresentation());
        rep.setError(adminEvent.getError());
        return rep;
    }

    public AuthDetailsRepresentation toRepresentation(AuthDetails authDetails) {
        AuthDetailsRepresentation rep = new AuthDetailsRepresentation();
        rep.setOrganizationId(authDetails.getOrganizationId());
        rep.setUserId(authDetails.getUserId());
        rep.setIpAddress(authDetails.getIpAddress());
        return rep;
    }

    public List<ConfigPropertyRepresentation> toRepresentation(List<ProviderConfigProperty> configProperties) {
        LinkedList<ConfigPropertyRepresentation> propertiesRep = new LinkedList<ConfigPropertyRepresentation>();
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = this.toRepresentation(prop);
            propertiesRep.add(propRep);
        }
        return propertiesRep;
    }

    public ConfigPropertyRepresentation toRepresentation(ProviderConfigProperty prop) {
        ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
        propRep.setName(prop.getName());
        propRep.setLabel(prop.getLabel());
        propRep.setType(prop.getType());
        propRep.setDefaultValue(prop.getDefaultValue());
        propRep.setOptions(prop.getOptions());
        propRep.setHelpText(prop.getHelpText());
        propRep.setSecret(prop.isSecret());
        return propRep;
    }

    public ComponentRepresentation toRepresentation(ComponentModel component, boolean internal) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setId(component.getId());
        rep.setName(component.getName());
        rep.setProviderId(component.getProviderId());
        rep.setProviderType(component.getProviderType());
        rep.setSubType(component.getSubType());
        rep.setParentId(component.getParentId());
        if (internal) {
            rep.setConfig(component.getConfig());
        } else {
            Map<String, ProviderConfigProperty> configProperties = this.componentUtil.getComponentConfigProperties(component);
            MultivaluedHashMap config = new MultivaluedHashMap();
            for (Map.Entry e : component.getConfig().entrySet()) {
                ProviderConfigProperty configProperty = configProperties.get(e.getKey());
                if (configProperty == null) continue;
                if (configProperty.isSecret()) {
                    config.putSingle(e.getKey(), (Object)"**********");
                    continue;
                }
                config.put(e.getKey(), e.getValue());
            }
            rep.setConfig(config);
        }
        return rep;
    }

    public SendEventRepresentation toRepresentation(SendEventModel model) {
        SendEventRepresentation rep = new SendEventRepresentation();
        rep.setId(model.getId());
        rep.setDestinyType(model.getDestityType().toString());
        rep.setResult(model.getResult().toString());
        rep.setDescription(model.getDescription());
        if (model.getCreatedTimestamp() != null) {
            rep.setCreatedTimestamp(Date.from(model.getCreatedTimestamp().atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (model.getAttributes() != null && !model.getAttributes().isEmpty()) {
            HashMap attrs = new HashMap();
            attrs.putAll(model.getAttributes());
            rep.setResponseAttributes(attrs);
        }
        return rep;
    }

    public JobReportRepresentation toRepresentation(AdminJobReport model) {
        JobReportRepresentation rep = new JobReportRepresentation();
        rep.setId(model.getId());
        rep.setJobName(model.getJobName());
        rep.setDuration(model.getDuration());
        rep.setStartTime(model.getStartTime());
        rep.setEndTime(model.getEndTime());
        rep.setErrorCount(model.getErrorCount());
        rep.setReadCount(model.getReadCount());
        rep.setWriteCount(model.getWriteCount());
        return rep;
    }

    public JobReportRepresentation toRepresentation(JobReportModel model) {
        JobReportRepresentation rep = new JobReportRepresentation();
        rep.setId(model.getId());
        rep.setJobName(model.getJobName());
        rep.setDuration(model.getDuration());
        rep.setStartTime(model.getStartTime());
        rep.setEndTime(model.getEndTime());
        rep.setErrorCount(model.getErrorCount());
        rep.setReadCount(model.getReadCount());
        rep.setWriteCount(model.getWriteCount());
        return rep;
    }
}

