/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models.utils;

import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.common.util.MultivaluedHashMap;
import org.openfact.component.ComponentModel;
import org.openfact.keys.KeyProvider;
import org.openfact.models.ComponentProvider;
import org.openfact.models.ModelException;
import org.openfact.models.OrganizationModel;

@Stateless
public class DefaultKeyProviders {
    @Inject
    private ComponentProvider componentProvider;

    public void createProviders(OrganizationModel organization) throws ModelException {
        ComponentModel generated = new ComponentModel();
        generated.setName("rsa-generated");
        generated.setParentId(organization.getId());
        generated.setProviderId("rsa-generated");
        generated.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        generated.setConfig(config);
        this.componentProvider.addComponentModel(organization, generated);
    }

    public void createProviders(OrganizationModel organization, String privateKeyPem, String certificatePem) throws ModelException {
        ComponentModel rsa = new ComponentModel();
        rsa.setName("rsa");
        rsa.setParentId(organization.getId());
        rsa.setProviderId("rsa");
        rsa.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.putSingle((Object)"priority", (Object)"100");
        config.putSingle((Object)"privateKey", (Object)privateKeyPem);
        if (certificatePem != null) {
            config.putSingle((Object)"certificate", (Object)certificatePem);
        }
        rsa.setConfig(config);
        this.componentProvider.addComponentModel(organization, rsa);
    }
}

