/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.components.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openfact.component.ComponentFactory;
import org.openfact.component.ComponentModel;
import org.openfact.models.OrganizationModel;
import org.openfact.provider.ProviderConfigProperty;
import org.openfact.representations.idm.ComponentRepresentation;

public interface ComponentUtil {
    default public Map<String, ProviderConfigProperty> getComponentConfigProperties(ComponentRepresentation component) {
        return this.getComponentConfigProperties(component.getProviderType(), component.getProviderId());
    }

    default public Map<String, ProviderConfigProperty> getComponentConfigProperties(ComponentModel component) {
        return this.getComponentConfigProperties(component.getProviderType(), component.getProviderId());
    }

    default public ComponentFactory getComponentFactory(ComponentRepresentation component) {
        return this.getComponentFactory(component.getProviderType(), component.getProviderId());
    }

    default public ComponentFactory getComponentFactory(ComponentModel component) {
        return this.getComponentFactory(component.getProviderType(), component.getProviderId());
    }

    default public Map<String, ProviderConfigProperty> getComponentConfigProperties(String providerType, String providerId) {
        try {
            ComponentFactory componentFactory = this.getComponentFactory(providerType, providerId);
            List l = componentFactory.getConfigProperties();
            HashMap<String, ProviderConfigProperty> properties = new HashMap<String, ProviderConfigProperty>();
            for (ProviderConfigProperty p : l) {
                properties.put(p.getName(), p);
            }
            List common = componentFactory.getCommonProviderConfigProperties();
            for (ProviderConfigProperty p : common) {
                properties.put(p.getName(), p);
            }
            return properties;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ComponentFactory getComponentFactory(String var1, String var2);

    default public void notifyCreated(OrganizationModel organization, ComponentModel model) {
        ComponentFactory factory = this.getComponentFactory(model);
        factory.onCreate(organization, model);
    }

    default public void notifyUpdated(OrganizationModel organization, ComponentModel model) {
        ComponentFactory factory = this.getComponentFactory(model);
        factory.onUpdate(organization, model);
    }
}

