/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models.utils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.common.util.MultivaluedHashMap;
import org.openfact.component.ComponentModel;
import org.openfact.components.utils.ComponentUtil;
import org.openfact.keys.KeyProvider;
import org.openfact.models.ComponentProvider;
import org.openfact.models.ModelException;
import org.openfact.models.OrganizationModel;
import org.openfact.models.search.SearchCriteriaFilterOperator;
import org.openfact.models.search.SearchCriteriaModel;
import org.openfact.models.utils.DefaultKeyProviders;
import org.openfact.provider.ProviderConfigProperty;
import org.openfact.representations.idm.ComponentExportRepresentation;
import org.openfact.representations.idm.ComponentRepresentation;
import org.openfact.representations.idm.OrganizationRepresentation;
import org.openfact.representations.idm.PostalAddressRepresentation;
import org.openfact.representations.idm.search.PagingRepresentation;
import org.openfact.representations.idm.search.SearchCriteriaFilterOperatorRepresentation;
import org.openfact.representations.idm.search.SearchCriteriaFilterRepresentation;
import org.openfact.representations.idm.search.SearchCriteriaRepresentation;

@Stateless
public class RepresentationToModel {
    @Inject
    private ComponentUtil componentUtil;
    @Inject
    private ComponentProvider componentProvider;
    @Inject
    private DefaultKeyProviders defaultKeyProviders;

    public SearchCriteriaModel toModel(SearchCriteriaRepresentation rep) {
        SearchCriteriaModel model = new SearchCriteriaModel();
        Function<SearchCriteriaFilterOperatorRepresentation, SearchCriteriaFilterOperator> operatorFunction = f -> SearchCriteriaFilterOperator.valueOf((String)f.toString());
        BiFunction<Object, SearchCriteriaFilterRepresentation.FilterValueType, Object> valueFunction = (value, type) -> {
            if (type == null) {
                return value;
            }
            Object result = null;
            switch (type) {
                case LONG: {
                    result = (long)((Long)value);
                    break;
                }
                case STRING: {
                    result = (String)value;
                    break;
                }
                case DATE: {
                    result = LocalDateTime.parse((String)value, DateTimeFormatter.ISO_DATE);
                    break;
                }
                case DATETIME: {
                    result = LocalDateTime.parse((String)value, DateTimeFormatter.ISO_DATE_TIME);
                    break;
                }
                default: {
                    result = value;
                }
            }
            return result;
        };
        rep.getFilters().forEach(f -> model.addFilter(f.getName(), valueFunction.apply(f.getValue(), f.getType()), (SearchCriteriaFilterOperator)operatorFunction.apply(f.getOperator())));
        rep.getOrders().forEach(f -> model.addOrder(f.getName(), f.isAscending()));
        if (rep.getPaging() != null) {
            PagingRepresentation paging = rep.getPaging();
            model.setPageSize(paging.getPageSize());
            model.setPage(paging.getPage());
        }
        return model;
    }

    public void importOrganization(OrganizationRepresentation rep, OrganizationModel newOrganization) throws ModelException {
        newOrganization.setName(rep.getOrganization());
        this.generalUpdateOrganization(newOrganization, rep);
        if (rep.getPostalAddress() != null) {
            this.updatePostalAddress(newOrganization, rep);
        }
        if (rep.getEventsEnabled() != null) {
            newOrganization.setEventsEnabled(rep.getEventsEnabled().booleanValue());
        }
        if (rep.getEventsExpiration() != null) {
            newOrganization.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            newOrganization.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getAdminEventsEnabled() != null) {
            newOrganization.setAdminEventsEnabled(rep.getAdminEventsEnabled().booleanValue());
        }
        if (rep.getAdminEventsDetailsEnabled() != null) {
            newOrganization.setAdminEventsDetailsEnabled(rep.getAdminEventsDetailsEnabled().booleanValue());
        }
        if (rep.getComponents() != null) {
            MultivaluedHashMap components = rep.getComponents();
            String parentId = newOrganization.getId();
            this.importComponents(newOrganization, (MultivaluedHashMap<String, ComponentExportRepresentation>)components, parentId, this.componentProvider);
        }
        if (this.componentProvider.getComponents(newOrganization, newOrganization.getId(), KeyProvider.class.getName()).isEmpty()) {
            if (rep.getPrivateKey() != null) {
                this.defaultKeyProviders.createProviders(newOrganization, rep.getPrivateKey(), rep.getCertificate());
            } else {
                this.defaultKeyProviders.createProviders(newOrganization);
            }
        }
        if (rep.getAttributes() != null) {
            for (Map.Entry attr : rep.getAttributes().entrySet()) {
                newOrganization.setAttribute((String)attr.getKey(), (String)attr.getValue());
            }
        }
    }

    public void updateOrganization(OrganizationRepresentation rep, OrganizationModel organization) throws ModelException {
        if (rep.getOrganization() != null) {
            this.renameOrganization(organization, rep.getOrganization());
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(organization.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                organization.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            for (String attr : attrsToRemove) {
                organization.removeAttribute(attr);
            }
        }
        this.generalUpdateOrganization(organization, rep);
        if (rep.getPostalAddress() != null) {
            this.updatePostalAddress(organization, rep);
        }
        if (rep.getEventsEnabled() != null) {
            organization.setEventsEnabled(rep.getEventsEnabled().booleanValue());
        }
        if (rep.getEventsExpiration() != null) {
            organization.setEventsExpiration(rep.getEventsExpiration().longValue());
        }
        if (rep.getEventsListeners() != null) {
            organization.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            organization.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.getAdminEventsEnabled() != null) {
            organization.setAdminEventsEnabled(rep.getAdminEventsEnabled().booleanValue());
        }
        if (rep.getAdminEventsDetailsEnabled() != null) {
            organization.setAdminEventsDetailsEnabled(rep.getAdminEventsDetailsEnabled().booleanValue());
        }
    }

    public void renameOrganization(OrganizationModel organization, String name) {
        if (name.equals(organization.getName())) {
            return;
        }
        organization.setName(name);
    }

    public void generalUpdateOrganization(OrganizationModel organization, OrganizationRepresentation rep) {
        if (rep.getDescription() != null) {
            organization.setDescription(rep.getDescription());
        }
        if (rep.getEnabled() != null) {
            organization.setEnabled(rep.getEnabled().booleanValue());
        }
        if (rep.getAssignedIdentificationId() != null) {
            organization.setAssignedIdentificationId(rep.getAssignedIdentificationId());
        }
        if (rep.getAdditionalAccountId() != null) {
            organization.setAdditionalAccountId(rep.getAdditionalAccountId());
        }
        if (rep.getSupplierName() != null) {
            organization.setSupplierName(rep.getSupplierName());
        }
        if (rep.getRegistrationName() != null) {
            organization.setRegistrationName(rep.getRegistrationName());
        }
        if (rep.getEmailTheme() != null) {
            organization.setEmailTheme(rep.getEmailTheme());
        }
        if (rep.getReportTheme() != null) {
            organization.setReportTheme(rep.getReportTheme());
        }
        if (rep.getInternationalizationEnabled() != null) {
            organization.setInternationalizationEnabled(rep.getInternationalizationEnabled().booleanValue());
        }
        if (rep.getSupportedLocales() != null) {
            organization.setSupportedLocales(new HashSet(rep.getSupportedLocales()));
        }
        if (rep.getDefaultLocale() != null) {
            organization.setDefaultLocale(rep.getDefaultLocale());
        }
        if (rep.isTasksEnabled() != null) {
            organization.setTaskEnabled(rep.isTasksEnabled().booleanValue());
        }
        if (rep.getTaskFirstTime() != null) {
            organization.setTaskFirstTime(rep.getTaskFirstTime());
        }
        if (rep.getTaskDelay() != null) {
            organization.setTaskDelay(rep.getTaskDelay().longValue());
        }
        if (rep.getDefaultCurrency() != null) {
            organization.setDefaultCurrency(rep.getDefaultCurrency());
        }
        if (rep.getSupportedCurrencies() != null) {
            organization.setSupportedCurrencies(new HashSet(new HashSet(rep.getSupportedCurrencies())));
        }
        if (rep.getSmtpServer() != null) {
            organization.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
    }

    public void updatePostalAddress(OrganizationModel organization, OrganizationRepresentation rep) {
        if (rep.getPostalAddress() != null) {
            PostalAddressRepresentation postalAddressRep = rep.getPostalAddress();
            if (postalAddressRep.getPostalAddressId() != null) {
                organization.setPostalAddressId(postalAddressRep.getPostalAddressId());
            }
            if (postalAddressRep.getCountryIdentificationCode() != null) {
                organization.setCountryIdentificationCode(postalAddressRep.getCountryIdentificationCode());
            }
            if (postalAddressRep.getCountrySubentity() != null) {
                organization.setCountrySubentity(postalAddressRep.getCountrySubentity());
            }
            if (postalAddressRep.getCityName() != null) {
                organization.setCityName(postalAddressRep.getCityName());
            }
            if (postalAddressRep.getCitySubdivisionName() != null) {
                organization.setCitySubdivisionName(postalAddressRep.getCitySubdivisionName());
            }
            if (postalAddressRep.getDistrict() != null) {
                organization.setDistrict(postalAddressRep.getDistrict());
            }
            if (postalAddressRep.getStreetName() != null) {
                organization.setStreetName(postalAddressRep.getStreetName());
            }
        }
    }

    public ComponentModel toModel(ComponentRepresentation rep) {
        ComponentModel model = new ComponentModel();
        model.setParentId(rep.getParentId());
        model.setProviderType(rep.getProviderType());
        model.setProviderId(rep.getProviderId());
        model.setConfig(new MultivaluedHashMap());
        model.setName(rep.getName());
        model.setSubType(rep.getSubType());
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null) continue;
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty()) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                model.getConfig().put((Object)k, (Object)values);
            }
        }
        return model;
    }

    public void updateComponent(ComponentRepresentation rep, ComponentModel component, boolean internal) {
        if (rep.getName() != null) {
            component.setName(rep.getName());
        }
        if (rep.getParentId() != null) {
            component.setParentId(rep.getParentId());
        }
        if (rep.getProviderType() != null) {
            component.setProviderType(rep.getProviderType());
        }
        if (rep.getProviderId() != null) {
            component.setProviderId(rep.getProviderId());
        }
        if (rep.getSubType() != null) {
            component.setSubType(rep.getSubType());
        }
        Map<String, ProviderConfigProperty> providerConfiguration = null;
        if (!internal) {
            providerConfiguration = this.componentUtil.getComponentConfigProperties(component);
        }
        if (rep.getConfig() != null) {
            HashSet keys = new HashSet(rep.getConfig().keySet());
            for (String k : keys) {
                if (!internal && !providerConfiguration.containsKey(k)) break;
                List values = (List)rep.getConfig().get((Object)k);
                if (values == null || values.isEmpty() || values.get(0) == null || ((String)values.get(0)).trim().isEmpty()) {
                    component.getConfig().remove((Object)k);
                    continue;
                }
                ListIterator itr = values.listIterator();
                while (itr.hasNext()) {
                    String v = (String)itr.next();
                    if (v != null && !v.trim().isEmpty() && !v.equals("**********")) continue;
                    itr.remove();
                }
                if (values.isEmpty()) continue;
                component.getConfig().put((Object)k, (Object)values);
            }
        }
    }

    protected void importComponents(OrganizationModel newOrganization, MultivaluedHashMap<String, ComponentExportRepresentation> components, String parentId, ComponentProvider componentProvider) throws ModelException {
        for (Map.Entry entry : components.entrySet()) {
            String providerType = (String)entry.getKey();
            for (ComponentExportRepresentation compRep : (List)entry.getValue()) {
                ComponentModel component = new ComponentModel();
                component.setId(compRep.getId());
                component.setName(compRep.getName());
                component.setConfig(compRep.getConfig());
                component.setProviderType(providerType);
                component.setProviderId(compRep.getProviderId());
                component.setSubType(compRep.getSubType());
                component.setParentId(parentId);
                component = componentProvider.addComponentModel(newOrganization, component);
                if (compRep.getSubComponents() == null) continue;
                this.importComponents(newOrganization, (MultivaluedHashMap<String, ComponentExportRepresentation>)compRep.getSubComponents(), component.getId(), componentProvider);
            }
        }
    }
}

