/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.models.utils;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.components.utils.ComponentUtil;
import org.openfact.provider.ProviderConfigProperty;
import org.openfact.representations.idm.ComponentRepresentation;
import org.openfact.representations.idm.IdentityProviderRepresentation;
import org.openfact.representations.idm.OrganizationRepresentation;

@Stateless
public class StripSecretsUtils {
    @Inject
    private ComponentUtil componentUtil;

    public ComponentRepresentation strip(ComponentRepresentation rep) {
        Map<String, ProviderConfigProperty> configProperties = this.componentUtil.getComponentConfigProperties(rep);
        if (rep.getConfig() == null) {
            return rep;
        }
        Iterator itr = rep.getConfig().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry next = (Map.Entry)itr.next();
            ProviderConfigProperty configProperty = configProperties.get(next.getKey());
            if (configProperty != null) {
                if (!configProperty.isSecret()) continue;
                next.setValue(Collections.singletonList("**********"));
                continue;
            }
            itr.remove();
        }
        return rep;
    }

    public OrganizationRepresentation strip(OrganizationRepresentation rep) {
        if (rep.getSmtpServer() != null && rep.getSmtpServer().containsKey("password")) {
            rep.getSmtpServer().put("password", "**********");
        }
        return rep;
    }

    public IdentityProviderRepresentation strip(IdentityProviderRepresentation rep) {
        if (rep.getConfig() != null && rep.getConfig().containsKey("clientSecret")) {
            rep.getConfig().put("clientSecret", "**********");
        }
        return rep;
    }
}

