/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ws.sunat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openfact.common.converts.DocumentUtils;
import org.openfact.models.ModelRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SunatResponseUtils {
    public static Map<String, String> byteResponseToMap(byte[] data) throws Exception {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            data = SunatResponseUtils.unzip(data);
            Document e = DocumentUtils.byteToDocument((byte[])data);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String responseCode = (String)xPath.evaluate("/*[local-name()='ApplicationResponse']/*[local-name()='DocumentResponse']/*[local-name()='Response']/*[local-name()='ResponseCode']/text()", e.getDocumentElement(), XPathConstants.STRING);
            String description = (String)xPath.evaluate("/*[local-name()='ApplicationResponse']/*[local-name()='DocumentResponse']/*[local-name()='Response']/*[local-name()='Description']/text()", e.getDocumentElement(), XPathConstants.STRING);
            NodeList warningsNode = (NodeList)xPath.evaluate("/*[local-name()='ApplicationResponse']/*[local-name()='Note']", e.getDocumentElement(), XPathConstants.NODESET);
            int ErrorCode = new Integer(responseCode);
            if (ErrorCode != 0 && (ErrorCode < 100 || ErrorCode > 399) && ErrorCode <= 4000) {
                response.put("ACCEPTED BY SUNAT", "NO");
            } else {
                response.put("ACCEPTED BY SUNAT", "YES");
            }
            response.put("RESPONSE CODE", responseCode);
            response.put("MESSAGE", description);
        }
        catch (XPathExpressionException e) {
            response.put("ACCEPTED BY SUNAT", "NO");
            response.put("MESSAGE", e.getMessage());
        }
        return response;
    }

    public static Map<String, String> faultToMap(String ... soapFault) {
        HashMap<String, String> response = new HashMap<String, String>();
        String faultCode = soapFault[0];
        String message = "";
        String retCode = SunatResponseUtils.getErrorCode(faultCode);
        String faultString = soapFault[1];
        int intCode = -1;
        try {
            intCode = "".equals(retCode) ? new Integer(faultString).intValue() : new Integer(retCode).intValue();
            Integer errorCode = soapFault[1].indexOf("Detalle");
            message = errorCode > 0 ? soapFault[1].substring(0, errorCode - 1) : soapFault[1];
        }
        catch (Throwable e) {
            message = "Failed to invoke Service: " + e.getMessage();
        }
        response.put("ACCEPTED BY SUNAT", "NO");
        response.put("MESSAGE", message);
        return response;
    }

    private static String getErrorCode(String faultCode) {
        Integer length = faultCode.length();
        String errorCode = "";
        for (int i = 0; i < length; ++i) {
            if (!Character.isDigit(faultCode.charAt(i))) continue;
            errorCode = errorCode + faultCode.charAt(i);
        }
        return errorCode;
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] unzip(byte[] data) {
        try {
            e = new ByteArrayInputStream(data);
            srcIs = new ZipInputStream(e);
            destOs = new ByteArrayOutputStream();
            entry = null;
            block2: while (true) {
                if ((entry = srcIs.getNextEntry()) == null) {
                    destOs.flush();
                    b2 = destOs.toByteArray();
                    destOs.close();
                    destOs.close();
                    srcIs.close();
                    e.close();
                    return b2;
                }
                if (!entry.getName().endsWith(".xml")) continue;
                b = false;
                buffer = new byte[2048];
                while (true) {
                    if ((b1 = srcIs.read(buffer)) > 0) ** break;
                    continue block2;
                    destOs.write(buffer, 0, b1);
                }
                break;
            }
        }
        catch (Exception e) {
            throw new ModelRuntimeException("Error al descomprimir la constancia", e.getCause());
        }
    }
}

