/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ws;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.openfact.pe.ws.ServiceConfigurationException;
import org.openfact.pe.ws.ServicePasswordCallback;
import org.openfact.pe.ws.ServicePasswordThread;

public class ServiceWrapper<T> {
    private Map<String, String> config;
    private ServicePasswordThread passwordThread;

    public ServiceWrapper(Map<String, String> config) {
        this.config = config;
        this.passwordThread = new ServicePasswordThread(config);
    }

    public T initWebService(Class<?> serviceClass) throws ServiceConfigurationException {
        Properties properties = System.getProperties();
        properties.put("org.apache.cxf.stax.allowInsecureParser", "1");
        System.setProperties(properties);
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        props.put("mtom-enabled", Boolean.FALSE);
        factory.setProperties(props);
        factory.setAddress(this.config.get("address"));
        factory.getInInterceptors().add(new LoggingInInterceptor());
        factory.getOutInterceptors().add(new LoggingOutInterceptor());
        factory.setServiceClass(serviceClass);
        Object client = factory.create();
        this.configureSSLOnTheClient(client, this.config.get("username"));
        return (T)client;
    }

    private void configureSSLOnTheClient(Object object, String username) throws ServiceConfigurationException {
        Client client = ClientProxy.getClient((Object)object);
        HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
        TLSClientParameters tlsParams = new TLSClientParameters();
        tlsParams.setDisableCNCheck(true);
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setConnectionTimeout(30000L);
        policy.setReceiveTimeout(15000L);
        policy.setAllowChunking(false);
        httpConduit.setClient(policy);
        FiltersType filter = new FiltersType();
        filter.getInclude().add(".*_EXPORT_.*");
        filter.getInclude().add(".*_EXPORT1024_.*");
        filter.getInclude().add(".*_WITH_DES_.*");
        filter.getInclude().add(".*_WITH_NULL_.*");
        filter.getExclude().add(".*_DH_anon_.*");
        tlsParams.setCipherSuitesFilter(filter);
        httpConduit.setTlsClientParameters(tlsParams);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "UsernameToken");
        outProps.put("user", username);
        outProps.put("passwordType", "PasswordText");
        outProps.put("passwordCallbackClass", ServicePasswordCallback.class.getName());
        WSS4JOutInterceptor wsOut = new WSS4JOutInterceptor(outProps);
        client.getEndpoint().getOutInterceptors().add(wsOut);
    }
}

