/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.voideddocument;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.common.converts.StringUtils;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.ScrollModel;
import org.openfact.pe.ubl.types.SunatDocumentType;
import org.openfact.pe.ubl.types.TipoComprobante;
import org.openfact.pe.ubl.ubl21.factories.SunatMarshallerUtils;
import org.openfact.pe.ubl.ubl21.voideddocument.UBLVoidedDocumentIDGenerator;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="VOIDED_DOCUMENTS")
public class SunatUBLVoidedDocumentIDGenerator
implements UBLVoidedDocumentIDGenerator {
    @Inject
    private DocumentProvider documentProvider;

    public String generateID(OrganizationModel organization, Object o) {
        TipoComprobante voidedDocumentCode = TipoComprobante.BAJA;
        DocumentModel lastVoidedDocument = null;
        ScrollModel voidedDocuments = this.documentProvider.createQuery(organization).documentType(new String[]{SunatDocumentType.VOIDED_DOCUMENTS.toString()}).entityQuery().orderByDesc(new String[]{"documentId"}).resultScroll().getScrollResult(10);
        Iterator iterator = voidedDocuments.iterator();
        Pattern pattern = Pattern.compile(voidedDocumentCode.getMask());
        while (iterator.hasNext()) {
            DocumentModel voidedDocument = (DocumentModel)iterator.next();
            String documentId = voidedDocument.getDocumentId();
            Matcher matcher = pattern.matcher(documentId);
            if (!matcher.find()) continue;
            lastVoidedDocument = voidedDocument;
            break;
        }
        int number = 0;
        int secuence = 0;
        if (lastVoidedDocument != null) {
            String[] splits = lastVoidedDocument.getDocumentId().split("-");
            secuence = Integer.parseInt(splits[1]);
            number = Integer.parseInt(splits[2]);
        }
        int nextSeries = SunatMarshallerUtils.getDateToNumber();
        int nextNumber = 0;
        nextNumber = secuence == nextSeries ? SunatMarshallerUtils.getNextNumber((int)number, (int)99999) : SunatMarshallerUtils.getNextNumber((int)0, (int)99999);
        StringBuilder documentId = new StringBuilder();
        documentId.append(voidedDocumentCode.getMask().substring(2, 4));
        documentId.append("-");
        documentId.append(nextSeries);
        documentId.append("-");
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextNumber), (int)5, (String)"0"));
        return documentId.toString();
    }
}

