/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.summarydocument;

import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.ModelInsuficientData;
import org.openfact.models.OrganizationModel;
import org.openfact.models.SendEventException;
import org.openfact.models.SendEventModel;
import org.openfact.pe.ws.sunat.SunatSenderManager;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.UBLThirdPartySender;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;
import org.openfact.ubl.utils.UBLUtil;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="SUMMARY_DOCUMENTS")
public class SunatUBLSummaryDocumentThirdPartySender
implements UBLThirdPartySender {
    @Inject
    private SunatSenderManager sunatSenderManager;
    @Inject
    private UBLUtil ublUtil;
    @Inject
    private DocumentProvider documentProvider;

    public SendEventModel send(OrganizationModel organization, DocumentModel document) throws ModelInsuficientData, SendEventException {
        SendEventModel sendEvent = this.sunatSenderManager.sendSummary(organization, document, this.generateFileName(organization, document));
        return sendEvent;
    }

    private String generateFileName(OrganizationModel organization, DocumentModel document) throws ModelInsuficientData {
        if (organization.getAssignedIdentificationId() == null) {
            throw new ModelInsuficientData("Organization doesn't have assignedIdentificationId");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(organization.getAssignedIdentificationId()).append("-");
        sb.append(document.getDocumentId());
        return sb.toString();
    }
}

