/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.retention;

import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.models.DocumentModel;
import org.openfact.models.ModelInsuficientData;
import org.openfact.models.OrganizationModel;
import org.openfact.models.SendEventException;
import org.openfact.models.SendEventModel;
import org.openfact.pe.ubl.types.TipoComprobante;
import org.openfact.pe.ws.sunat.SunatSenderManager;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.UBLThirdPartySender;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="RETENTION")
public class SunatUBLRetentionThirdPartySender
implements UBLThirdPartySender {
    @Inject
    private SunatSenderManager sunatSenderManager;

    public SendEventModel send(OrganizationModel organization, DocumentModel document) throws ModelInsuficientData, SendEventException {
        return this.sunatSenderManager.sendBillAddress2(organization, document, this.generateFileName(organization, document));
    }

    private String generateFileName(OrganizationModel organization, DocumentModel document) throws ModelInsuficientData {
        if (organization.getAssignedIdentificationId() == null) {
            throw new ModelInsuficientData("Organization doesn't have assignedIdentificationId");
        }
        String codigo = TipoComprobante.RETENCION.getCodigo();
        StringBuilder sb = new StringBuilder();
        sb.append(organization.getAssignedIdentificationId()).append("-");
        sb.append(codigo).append("-");
        sb.append(document.getDocumentId());
        return sb.toString();
    }
}

