/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.debitnote;

import javax.ejb.Stateless;
import javax.inject.Inject;
import oasis.names.specification.ubl.schema.xsd.debitnote_21.DebitNoteType;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.types.DocumentRequiredAction;
import org.openfact.models.types.DocumentType;
import org.openfact.models.utils.TypeToModel;
import org.openfact.pe.ubl.ubl21.debitnote.AbstractDebitNoteProvider;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.debitnote.UBLDebitNoteCustomizator;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="DEBIT_NOTE")
public class SunatUBLDebitNoteCustomizator
extends AbstractDebitNoteProvider
implements UBLDebitNoteCustomizator {
    @Inject
    private TypeToModel typeToModel;
    @Inject
    private DocumentProvider documentProvider;

    public void config(OrganizationModel organization, DocumentModel document, Object o) {
        DebitNoteType debitNoteType = SunatUBLDebitNoteCustomizator.resolve(o);
        this.typeToModel.importDebitNote(organization, document, debitNoteType);
        if (debitNoteType.getBillingReference() != null && !debitNoteType.getBillingReference().isEmpty()) {
            debitNoteType.getBillingReference().stream().filter(p -> p.getInvoiceDocumentReference() != null).forEach(c -> {
                String invoiceDocumentId = c.getInvoiceDocumentReference().getIDValue();
                DocumentModel attachedDocument = this.documentProvider.getDocumentByTypeAndDocumentId(DocumentType.INVOICE, invoiceDocumentId, organization);
                if (attachedDocument != null) {
                    document.addAttachedDocument(attachedDocument);
                }
            });
        }
    }

    public DocumentRequiredAction[] getRequiredActions() {
        return new DocumentRequiredAction[]{DocumentRequiredAction.SEND_TO_CUSTOMER, DocumentRequiredAction.SEND_TO_THIRD_PARTY};
    }

    public String[] getExtraRequiredActions() {
        return new String[0];
    }
}

