/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import org.openfact.common.converts.DocumentUtils;
import org.openfact.models.KeyManager;
import org.openfact.models.ModelRuntimeException;
import org.openfact.models.OpenfactSession;
import org.openfact.models.OrganizationModel;
import org.openfact.ubl.UBLSigner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SunatSignerUtils {
    @Inject
    private UBLSigner ublSigner;
    @Inject
    private KeyManager keystore;
    private static final String FACTORY = "DOM";
    private static final String PREFIX = "ds";

    public Element getSignToElement(OrganizationModel organization) {
        Document signedDocument = this.sign(organization);
        return signedDocument.getDocumentElement();
    }

    public Document getSignToDocument(OpenfactSession session, OrganizationModel organization, Document document) {
        Document signedDocument = this.ublSigner.sign(document, organization);
        return signedDocument;
    }

    public void removeSignature(Document document) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("ext:UBLExtension");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element chilElement = (Element)nodeList.item(i);
            chilElement.getParentNode().removeChild(chilElement);
        }
    }

    public Document sign(OrganizationModel organization) {
        XMLSignatureFactory xmlSigFactory = XMLSignatureFactory.getInstance(FACTORY);
        try {
            Document document = DocumentUtils.getEmptyDocument();
            DOMSignContext domSignCtx = new DOMSignContext(this.keystore.getActiveRsaKey(organization).getPrivateKey(), (Node)document);
            domSignCtx.setDefaultNamespacePrefix(PREFIX);
            Reference ref = xmlSigFactory.newReference("", xmlSigFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(xmlSigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
            SignedInfo signedInfo = xmlSigFactory.newSignedInfo(xmlSigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), xmlSigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
            KeyInfoFactory keyInfoFactory = xmlSigFactory.getKeyInfoFactory();
            ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
            x509Content.add(this.keystore.getActiveRsaKey(organization).getCertificate());
            X509Data xdata = keyInfoFactory.newX509Data(x509Content);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(xdata));
            XMLSignature xmlSignature = xmlSigFactory.newXMLSignature(signedInfo, keyInfo, null, "Signature" + organization.getName(), null);
            xmlSignature.sign(domSignCtx);
            return document;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (MarshalException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (XMLSignatureException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }
}

