/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.models.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AddressType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ContactType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CreditNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CustomerPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DebitNoteLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ExchangeRateType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ExternalReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyLegalEntityType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyNameType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PricingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ResponseType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SignatureType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.SupplierPartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxCategoryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSchemeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AdditionalAccountIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.CreditedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DebitedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ValueType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21.ExtensionContentType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21.UBLExtensionType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21.UBLExtensionsType;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.debitnote_21.DebitNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import org.openfact.common.converts.DateUtils;
import org.openfact.models.ModelRuntimeException;
import org.openfact.models.OrganizationModel;
import org.openfact.pe.representations.idm.BillingPaymentRepresentation;
import org.openfact.pe.representations.idm.DocumentRepresentation;
import org.openfact.pe.representations.idm.DocumentoSunatLineRepresentation;
import org.openfact.pe.representations.idm.DocumentoSunatRepresentation;
import org.openfact.pe.representations.idm.LineRepresentation;
import org.openfact.pe.representations.idm.SummaryLineRepresentation;
import org.openfact.pe.representations.idm.SummaryRepresentation;
import org.openfact.pe.representations.idm.TaxTotalRepresentation;
import org.openfact.pe.representations.idm.VoidedLineRepresentation;
import org.openfact.pe.representations.idm.VoidedRepresentation;
import org.openfact.pe.ubl.types.TipoAfectacionIgv;
import org.openfact.pe.ubl.types.TipoConceptosTributarios;
import org.openfact.pe.ubl.types.TipoElementosAdicionalesComprobante;
import org.openfact.pe.ubl.types.TipoInvoice;
import org.openfact.pe.ubl.types.TipoPrecioVentaUnitario;
import org.openfact.pe.ubl.types.TipoTributo;
import org.openfact.pe.ubl.types.UblSunatConfiguration;
import org.openfact.pe.ubl.ubl21.SunatSignerUtils;
import org.openfact.pe.ubl.ubl21.commons.AdditionalInformationTypeSunatAgg;
import org.openfact.pe.ubl.ubl21.commons.AdditionalMonetaryTotalType;
import org.openfact.pe.ubl.ubl21.commons.AdditionalPropertyType;
import org.openfact.pe.ubl.ubl21.commons.InvoiceFactory;
import org.openfact.pe.ubl.ubl21.perception.PerceptionType;
import org.openfact.pe.ubl.ubl21.perception.SUNATPerceptionDocumentReferenceType;
import org.openfact.pe.ubl.ubl21.perception.SUNATPerceptionInformationType;
import org.openfact.pe.ubl.ubl21.retention.RetentionType;
import org.openfact.pe.ubl.ubl21.retention.SUNATRetentionDocumentReferenceType;
import org.openfact.pe.ubl.ubl21.retention.SUNATRetentionInformationType;
import org.openfact.pe.ubl.ubl21.summary.SummaryDocumentsLineType;
import org.openfact.pe.ubl.ubl21.summary.SummaryDocumentsType;
import org.openfact.pe.ubl.ubl21.voided.VoidedDocumentsLineType;
import org.openfact.pe.ubl.ubl21.voided.VoidedDocumentsType;
import org.openfact.pe.utils.finance.MoneyConverters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Stateless
public class SunatRepresentationToType {
    public final String UBL_VERSION_ID = "2.0";
    public final String CUSTOMIZATION_ID = "1.0";
    public final String QUANTITY_UNKNOW = "NIU";
    @Inject
    private SunatSignerUtils sunatSingerUtils;

    public XMLGregorianCalendar toGregorianCalendar(LocalDate date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            String locale = sdf.format(DateUtils.asDate((LocalDate)date));
            XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(locale);
            return xmlCal;
        }
        catch (DatatypeConfigurationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public XMLGregorianCalendar toGregorianCalendarTime(LocalDateTime date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            String locale = sdf.format(DateUtils.asDate((LocalDateTime)date));
            XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(locale);
            return xmlCal;
        }
        catch (DatatypeConfigurationException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public InvoiceType toInvoiceType(OrganizationModel organization, DocumentRepresentation rep) {
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setUBLVersionID("2.0");
        invoiceType.setCustomizationID("1.0");
        if (rep.getNumero() != null && rep.getSerie() != null && !rep.getNumero().trim().isEmpty() && !rep.getSerie().trim().isEmpty()) {
            invoiceType.setID(rep.getSerie().toUpperCase() + "-" + rep.getNumero());
        }
        if (rep.getFechaDeEmision() != null) {
            invoiceType.setIssueDate(this.toGregorianCalendar(rep.getFechaDeEmision().toLocalDate()));
            invoiceType.setIssueTime(this.toGregorianCalendarTime(rep.getFechaDeEmision()));
        } else {
            invoiceType.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
            invoiceType.setIssueTime(this.toGregorianCalendarTime(LocalDateTime.now()));
        }
        if (rep.getFechaDeVencimiento() != null) {
            invoiceType.setDueDate(this.toGregorianCalendar(rep.getFechaDeVencimiento().toLocalDate()));
        }
        if (rep.getMoneda() != null) {
            invoiceType.setDocumentCurrencyCode(rep.getMoneda());
        }
        invoiceType.setAccountingSupplierParty(this.toSupplierParty(organization));
        invoiceType.setAccountingCustomerParty(this.toCustomerPartyType(rep));
        if (rep.getTotalIgv() != null && rep.getTotalIgv().compareTo(BigDecimal.ZERO) > 0) {
            invoiceType.setTaxTotal(Arrays.asList(this.toTaxTotalIGV(rep)));
        }
        invoiceType.setLegalMonetaryTotal(this.toLegalMonetaryTotalType(rep));
        if (rep.getTipo() != null) {
            invoiceType.setInvoiceTypeCode(rep.getTipo());
        }
        if (rep.getTipoDeCambio() != null) {
            // empty if block
        }
        if (rep.getObservaciones() != null) {
            ArrayList<NoteType> noteTypes = new ArrayList<NoteType>();
            noteTypes.add(new NoteType(rep.getObservaciones()));
            invoiceType.setNote(noteTypes);
        }
        invoiceType.setSignature(Arrays.asList(this.toSignatureType(organization)));
        if (rep.getDetalle() != null) {
            invoiceType.setInvoiceLine(this.toInvoiceLineType(rep));
        }
        invoiceType.setUBLExtensions(this.toUBLExtensionsType(rep));
        return invoiceType;
    }

    private List<InvoiceLineType> toInvoiceLineType(DocumentRepresentation rep) {
        ArrayList<InvoiceLineType> invoiceLineTypes = new ArrayList<InvoiceLineType>();
        for (int i = 0; i < rep.getDetalle().size(); ++i) {
            LineRepresentation lineRep = (LineRepresentation)rep.getDetalle().get(i);
            InvoiceLineType invoiceLineType = new InvoiceLineType();
            invoiceLineType.setID(new IDType(String.valueOf(i + 1)));
            InvoicedQuantityType quantityType = new InvoicedQuantityType(lineRep.getCantidad());
            if (lineRep.getUnitCode() != null) {
                quantityType.setUnitCode(lineRep.getUnitCode());
            } else {
                quantityType.setUnitCode("NIU");
            }
            invoiceLineType.setInvoicedQuantity(quantityType);
            LineExtensionAmountType lineExtensionAmountType = new LineExtensionAmountType(lineRep.getSubtotal());
            lineExtensionAmountType.setCurrencyID(rep.getMoneda());
            invoiceLineType.setLineExtensionAmount(lineExtensionAmountType);
            PricingReferenceType pricingReferenceType = new PricingReferenceType();
            ArrayList<PriceType> priceTypes = new ArrayList<PriceType>();
            PriceType primaryPriceType = null;
            PriceType secondaryPriceType = null;
            TipoAfectacionIgv tipoAfectacionIgv = TipoAfectacionIgv.searchFromCodigo((String)lineRep.getTipoDeIgv());
            if (tipoAfectacionIgv == null) {
                throw new IllegalStateException("Invalid IGV code");
            }
            if (!tipoAfectacionIgv.isOperacionNoOnerosa()) {
                primaryPriceType = this.toPriceType(rep.getMoneda(), lineRep.getPrecioUnitario(), TipoPrecioVentaUnitario.PRECIO_UNITARIO.getCodigo());
                priceTypes.add(primaryPriceType);
            } else {
                primaryPriceType = this.toPriceType(rep.getMoneda(), BigDecimal.ZERO, TipoPrecioVentaUnitario.PRECIO_UNITARIO.getCodigo());
                priceTypes.add(primaryPriceType);
                secondaryPriceType = this.toPriceType(rep.getMoneda(), lineRep.getPrecioUnitario(), TipoPrecioVentaUnitario.VALOR_REF_UNIT_EN_OPER_NO_ORENOSAS.getCodigo());
                priceTypes.add(secondaryPriceType);
            }
            pricingReferenceType.setAlternativeConditionPrice(priceTypes);
            invoiceLineType.setPricingReference(pricingReferenceType);
            ItemType itemType = new ItemType();
            itemType.setDescription(Arrays.asList(new DescriptionType(lineRep.getDescripcion())));
            invoiceLineType.setItem(itemType);
            TaxTotalType taxTotalType = new TaxTotalType();
            TaxAmountType taxAmountType1 = new TaxAmountType(lineRep.getIgv());
            taxAmountType1.setCurrencyID(rep.getMoneda());
            taxTotalType.setTaxAmount(taxAmountType1);
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            TaxAmountType taxAmountType2 = new TaxAmountType(lineRep.getIgv());
            taxAmountType2.setCurrencyID(rep.getMoneda());
            taxSubtotalType.setTaxAmount(taxAmountType2);
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setTaxExemptionReasonCode(lineRep.getTipoDeIgv());
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(TipoTributo.IGV.getId());
            taxSchemeType.setName(TipoTributo.IGV.toString());
            taxSchemeType.setTaxTypeCode(TipoTributo.IGV.getCodigo());
            taxCategoryType.setTaxScheme(taxSchemeType);
            taxSubtotalType.setTaxCategory(taxCategoryType);
            taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
            invoiceLineType.setTaxTotal(Arrays.asList(taxTotalType));
            taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
            invoiceLineType.setTaxTotal(Arrays.asList(taxTotalType));
            PriceType priceType1 = new PriceType();
            PriceAmountType priceAmountType1 = new PriceAmountType(lineRep.getValorUnitario());
            priceAmountType1.setCurrencyID(rep.getMoneda());
            priceType1.setPriceAmount(priceAmountType1);
            invoiceLineType.setPrice(priceType1);
            invoiceLineTypes.add(invoiceLineType);
        }
        return invoiceLineTypes;
    }

    public CreditNoteType toCreditNoteType(OrganizationModel organization, DocumentRepresentation rep) {
        CreditNoteType type = new CreditNoteType();
        type.setUBLVersionID("2.0");
        type.setCustomizationID("1.0");
        if (rep.getNumero() != null && rep.getSerie() != null && !rep.getNumero().trim().isEmpty() && !rep.getSerie().trim().isEmpty()) {
            type.setID(rep.getSerie().toUpperCase() + "-" + rep.getNumero());
        }
        if (rep.getFechaDeEmision() != null) {
            type.setIssueDate(this.toGregorianCalendar(rep.getFechaDeEmision().toLocalDate()));
            type.setIssueTime(this.toGregorianCalendarTime(rep.getFechaDeEmision()));
        } else {
            type.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
            type.setIssueTime(this.toGregorianCalendarTime(LocalDateTime.now()));
        }
        if (rep.getMoneda() != null) {
            type.setDocumentCurrencyCode(rep.getMoneda());
        }
        ResponseType responseType = new ResponseType();
        responseType.setReferenceID(rep.getDocumentoQueSeModifica());
        responseType.setResponseCode(rep.getTipoDeNotaDeCredito());
        if (rep.getObservaciones() != null) {
            responseType.setDescription(Arrays.asList(new DescriptionType(rep.getObservaciones())));
        } else {
            responseType.setDescription(Arrays.asList(new DescriptionType("Sin observacion")));
        }
        type.setDiscrepancyResponse(Arrays.asList(responseType));
        BillingReferenceType billingReferenceType = new BillingReferenceType();
        DocumentReferenceType documentReferenceType = new DocumentReferenceType();
        documentReferenceType.setID(rep.getDocumentoQueSeModifica().trim().toUpperCase());
        String identificator = rep.getDocumentoQueSeModifica().substring(0, 1);
        if (identificator.equalsIgnoreCase(TipoInvoice.BOLETA.toString().substring(0, 1))) {
            documentReferenceType.setDocumentTypeCode(TipoInvoice.BOLETA.getCodigo());
        } else if (identificator.equalsIgnoreCase(TipoInvoice.FACTURA.toString().substring(0, 1))) {
            documentReferenceType.setDocumentTypeCode(TipoInvoice.FACTURA.getCodigo());
        }
        billingReferenceType.setInvoiceDocumentReference(documentReferenceType);
        type.setBillingReference(Arrays.asList(billingReferenceType));
        type.setAccountingSupplierParty(this.toSupplierParty(organization));
        type.setAccountingCustomerParty(this.toCustomerPartyType(rep));
        if (rep.getTotalIgv() != null && rep.getTotalIgv().compareTo(BigDecimal.ZERO) > 0) {
            type.setTaxTotal(Arrays.asList(this.toTaxTotalIGV(rep)));
        }
        type.setLegalMonetaryTotal(this.toLegalMonetaryTotalType(rep));
        if (rep.getObservaciones() != null) {
            ArrayList<NoteType> noteTypes = new ArrayList<NoteType>();
            noteTypes.add(new NoteType(rep.getObservaciones()));
            type.setNote(noteTypes);
        }
        type.setSignature(Arrays.asList(this.toSignatureType(organization)));
        if (rep.getDetalle() != null) {
            type.setCreditNoteLine(this.toCreditNoteLineType(rep));
        }
        type.setUBLExtensions(this.toUBLExtensionsType(rep));
        return type;
    }

    private List<CreditNoteLineType> toCreditNoteLineType(DocumentRepresentation rep) {
        ArrayList<CreditNoteLineType> creditNoteLineTypes = new ArrayList<CreditNoteLineType>();
        for (int i = 0; i < rep.getDetalle().size(); ++i) {
            LineRepresentation lineRep = (LineRepresentation)rep.getDetalle().get(i);
            CreditNoteLineType creditNoteLineType = new CreditNoteLineType();
            creditNoteLineType.setID(new IDType(String.valueOf(i + 1)));
            CreditedQuantityType quantityType = new CreditedQuantityType(lineRep.getCantidad());
            if (lineRep.getUnitCode() != null) {
                quantityType.setUnitCode(lineRep.getUnitCode());
            } else {
                quantityType.setUnitCode("NIU");
            }
            creditNoteLineType.setCreditedQuantity(quantityType);
            LineExtensionAmountType lineExtensionAmountType = new LineExtensionAmountType(lineRep.getSubtotal());
            lineExtensionAmountType.setCurrencyID(rep.getMoneda());
            creditNoteLineType.setLineExtensionAmount(lineExtensionAmountType);
            PricingReferenceType pricingReferenceType = new PricingReferenceType();
            ArrayList<PriceType> priceTypes = new ArrayList<PriceType>();
            PriceType primaryPriceType = null;
            PriceType secondaryPriceType = null;
            TipoAfectacionIgv tipoAfectacionIgv = TipoAfectacionIgv.searchFromCodigo((String)lineRep.getTipoDeIgv());
            if (tipoAfectacionIgv == null) {
                throw new IllegalStateException("Invalid IGV code");
            }
            if (!tipoAfectacionIgv.isOperacionNoOnerosa()) {
                primaryPriceType = this.toPriceType(rep.getMoneda(), lineRep.getPrecioUnitario(), TipoPrecioVentaUnitario.PRECIO_UNITARIO.getCodigo());
                priceTypes.add(primaryPriceType);
            } else {
                primaryPriceType = this.toPriceType(rep.getMoneda(), BigDecimal.ZERO, TipoPrecioVentaUnitario.PRECIO_UNITARIO.getCodigo());
                priceTypes.add(primaryPriceType);
                secondaryPriceType = this.toPriceType(rep.getMoneda(), lineRep.getPrecioUnitario(), TipoPrecioVentaUnitario.VALOR_REF_UNIT_EN_OPER_NO_ORENOSAS.getCodigo());
                priceTypes.add(secondaryPriceType);
            }
            pricingReferenceType.setAlternativeConditionPrice(priceTypes);
            creditNoteLineType.setPricingReference(pricingReferenceType);
            ItemType itemType = new ItemType();
            itemType.setDescription(Arrays.asList(new DescriptionType(lineRep.getDescripcion())));
            creditNoteLineType.setItem(itemType);
            TaxTotalType taxTotalType = new TaxTotalType();
            TaxAmountType taxAmountType1 = new TaxAmountType(lineRep.getIgv());
            taxAmountType1.setCurrencyID(rep.getMoneda());
            taxTotalType.setTaxAmount(taxAmountType1);
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            TaxAmountType taxAmountType2 = new TaxAmountType(lineRep.getIgv());
            taxAmountType2.setCurrencyID(rep.getMoneda());
            taxSubtotalType.setTaxAmount(taxAmountType2);
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setTaxExemptionReasonCode(lineRep.getTipoDeIgv());
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(TipoTributo.IGV.getId());
            taxSchemeType.setName(TipoTributo.IGV.toString());
            taxSchemeType.setTaxTypeCode(TipoTributo.IGV.getCodigo());
            taxCategoryType.setTaxScheme(taxSchemeType);
            taxSubtotalType.setTaxCategory(taxCategoryType);
            taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
            creditNoteLineType.setTaxTotal(Arrays.asList(taxTotalType));
            taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
            creditNoteLineType.setTaxTotal(Arrays.asList(taxTotalType));
            PriceType priceType1 = new PriceType();
            PriceAmountType priceAmountType1 = new PriceAmountType(lineRep.getTotal());
            priceAmountType1.setCurrencyID(rep.getMoneda());
            priceType1.setPriceAmount(priceAmountType1);
            creditNoteLineType.setPrice(priceType1);
            creditNoteLineTypes.add(creditNoteLineType);
        }
        return creditNoteLineTypes;
    }

    public DebitNoteType toDebitNoteType(OrganizationModel organization, DocumentRepresentation rep) {
        DebitNoteType type = new DebitNoteType();
        type.setUBLVersionID("2.0");
        type.setCustomizationID("1.0");
        if (rep.getNumero() != null && rep.getSerie() != null && !rep.getNumero().trim().isEmpty() && !rep.getSerie().trim().isEmpty()) {
            type.setID(rep.getSerie().toUpperCase() + "-" + rep.getNumero());
        }
        if (rep.getFechaDeEmision() != null) {
            type.setIssueDate(this.toGregorianCalendar(rep.getFechaDeEmision().toLocalDate()));
            type.setIssueTime(this.toGregorianCalendarTime(rep.getFechaDeEmision()));
        } else {
            type.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
            type.setIssueTime(this.toGregorianCalendarTime(LocalDateTime.now()));
        }
        if (rep.getMoneda() != null) {
            type.setDocumentCurrencyCode(rep.getMoneda());
        }
        type.setAccountingSupplierParty(this.toSupplierParty(organization));
        type.setAccountingCustomerParty(this.toCustomerPartyType(rep));
        if (rep.getTotalIgv() != null && rep.getTotalIgv().compareTo(BigDecimal.ZERO) > 0) {
            type.setTaxTotal(Arrays.asList(this.toTaxTotalIGV(rep)));
        }
        if (rep.getObservaciones() != null) {
            ArrayList<NoteType> noteTypes = new ArrayList<NoteType>();
            noteTypes.add(new NoteType(rep.getObservaciones()));
            type.setNote(noteTypes);
        }
        ResponseType responseType = new ResponseType();
        responseType.setReferenceID(rep.getDocumentoQueSeModifica());
        responseType.setResponseCode(rep.getTipoDeNotaDeDebito());
        if (rep.getObservaciones() != null) {
            responseType.setDescription(Arrays.asList(new DescriptionType(rep.getObservaciones())));
        }
        type.setDiscrepancyResponse(Arrays.asList(responseType));
        BillingReferenceType billingReferenceType = new BillingReferenceType();
        DocumentReferenceType documentReferenceType = new DocumentReferenceType();
        documentReferenceType.setID(rep.getDocumentoQueSeModifica().trim().toUpperCase());
        String identificator = rep.getDocumentoQueSeModifica().substring(0, 1);
        if (identificator.equalsIgnoreCase(TipoInvoice.BOLETA.toString().substring(0, 1))) {
            documentReferenceType.setDocumentTypeCode(TipoInvoice.BOLETA.getCodigo());
        } else if (identificator.equalsIgnoreCase(TipoInvoice.FACTURA.toString().substring(0, 1))) {
            documentReferenceType.setDocumentTypeCode(TipoInvoice.FACTURA.getCodigo());
        }
        billingReferenceType.setInvoiceDocumentReference(documentReferenceType);
        type.setBillingReference(Arrays.asList(billingReferenceType));
        type.setRequestedMonetaryTotal(this.toLegalMonetaryTotalType(rep));
        type.setSignature(Arrays.asList(this.toSignatureType(organization)));
        if (rep.getDetalle() != null) {
            type.setDebitNoteLine(this.toDebitNoteLineType(rep));
        }
        type.setUBLExtensions(this.toUBLExtensionsType(rep));
        return type;
    }

    private List<DebitNoteLineType> toDebitNoteLineType(DocumentRepresentation rep) {
        ArrayList<DebitNoteLineType> debitNoteLineTypes = new ArrayList<DebitNoteLineType>();
        for (int i = 0; i < rep.getDetalle().size(); ++i) {
            LineRepresentation lineRep = (LineRepresentation)rep.getDetalle().get(i);
            DebitNoteLineType debitNoteLineType = new DebitNoteLineType();
            debitNoteLineType.setID(new IDType(String.valueOf(i + 1)));
            DebitedQuantityType quantityType = new DebitedQuantityType(lineRep.getCantidad());
            if (lineRep.getUnitCode() != null) {
                quantityType.setUnitCode(lineRep.getUnitCode());
            } else {
                quantityType.setUnitCode("NIU");
            }
            debitNoteLineType.setDebitedQuantity(quantityType);
            LineExtensionAmountType lineExtensionAmountType = new LineExtensionAmountType(lineRep.getSubtotal());
            lineExtensionAmountType.setCurrencyID(rep.getMoneda());
            debitNoteLineType.setLineExtensionAmount(lineExtensionAmountType);
            PricingReferenceType pricingReferenceType = new PricingReferenceType();
            ArrayList<PriceType> priceTypes = new ArrayList<PriceType>();
            PriceType primaryPriceType = null;
            PriceType secondaryPriceType = null;
            TipoAfectacionIgv tipoAfectacionIgv = TipoAfectacionIgv.searchFromCodigo((String)lineRep.getTipoDeIgv());
            if (tipoAfectacionIgv == null) {
                throw new IllegalStateException("Invalid IGV code");
            }
            if (!tipoAfectacionIgv.isOperacionNoOnerosa()) {
                primaryPriceType = this.toPriceType(rep.getMoneda(), lineRep.getPrecioUnitario(), TipoPrecioVentaUnitario.PRECIO_UNITARIO.getCodigo());
                priceTypes.add(primaryPriceType);
            } else {
                primaryPriceType = this.toPriceType(rep.getMoneda(), BigDecimal.ZERO, TipoPrecioVentaUnitario.PRECIO_UNITARIO.getCodigo());
                priceTypes.add(primaryPriceType);
                secondaryPriceType = this.toPriceType(rep.getMoneda(), lineRep.getPrecioUnitario(), TipoPrecioVentaUnitario.VALOR_REF_UNIT_EN_OPER_NO_ORENOSAS.getCodigo());
                priceTypes.add(secondaryPriceType);
            }
            pricingReferenceType.setAlternativeConditionPrice(priceTypes);
            debitNoteLineType.setPricingReference(pricingReferenceType);
            ItemType itemType = new ItemType();
            itemType.setDescription(Arrays.asList(new DescriptionType(lineRep.getDescripcion())));
            debitNoteLineType.setItem(itemType);
            TaxTotalType taxTotalType = new TaxTotalType();
            TaxAmountType taxAmountType1 = new TaxAmountType(lineRep.getIgv());
            taxAmountType1.setCurrencyID(rep.getMoneda());
            taxTotalType.setTaxAmount(taxAmountType1);
            TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
            TaxAmountType taxAmountType2 = new TaxAmountType(lineRep.getIgv());
            taxAmountType2.setCurrencyID(rep.getMoneda());
            taxSubtotalType.setTaxAmount(taxAmountType2);
            TaxCategoryType taxCategoryType = new TaxCategoryType();
            taxCategoryType.setTaxExemptionReasonCode(lineRep.getTipoDeIgv());
            TaxSchemeType taxSchemeType = new TaxSchemeType();
            taxSchemeType.setID(TipoTributo.IGV.getId());
            taxSchemeType.setName(TipoTributo.IGV.toString());
            taxSchemeType.setTaxTypeCode(TipoTributo.IGV.getCodigo());
            taxCategoryType.setTaxScheme(taxSchemeType);
            taxSubtotalType.setTaxCategory(taxCategoryType);
            taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
            debitNoteLineType.setTaxTotal(Arrays.asList(taxTotalType));
            taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
            debitNoteLineType.setTaxTotal(Arrays.asList(taxTotalType));
            PriceType priceType1 = new PriceType();
            PriceAmountType priceAmountType1 = new PriceAmountType(lineRep.getTotal());
            priceAmountType1.setCurrencyID(rep.getMoneda());
            priceType1.setPriceAmount(priceAmountType1);
            debitNoteLineType.setPrice(priceType1);
            debitNoteLineTypes.add(debitNoteLineType);
        }
        return debitNoteLineTypes;
    }

    public PerceptionType toPerceptionType(OrganizationModel organization, DocumentoSunatRepresentation rep) {
        PerceptionType type = new PerceptionType();
        UBLExtensionsType ublExtensionsType = new UBLExtensionsType();
        UBLExtensionType ublExtensionType = new UBLExtensionType();
        ExtensionContentType extensionContentType = new ExtensionContentType();
        type.setUblVersionID(UblSunatConfiguration.VERSION_ID.getCodigo());
        type.setCustomizationID(UblSunatConfiguration.CUSTOMIZATION_ID10.getCodigo());
        type.addSignature(this.toSignatureType(organization));
        if (rep.getSerieDocumento() != null && rep.getNumeroDocumento() != null) {
            type.setId(rep.getSerieDocumento() + UblSunatConfiguration.ID_SEPARATOR.getCodigo() + rep.getNumeroDocumento());
        }
        if (rep.getFechaDeEmision() != null) {
            type.setIssueDate(this.toGregorianCalendar(DateUtils.asLocalDateTime((Date)rep.getFechaDeEmision()).toLocalDate()));
        } else {
            type.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
        }
        type.setAgentParty(this.toAgentPartyType(organization));
        type.setReceiverParty(this.toReceiverPartyType(rep));
        if (rep.getCodigoDocumento() != null) {
            type.setSunatPerceptionSystemCode(rep.getCodigoDocumento());
        }
        if (rep.getTasaDocumento() != null) {
            type.setSunatPerceptionPercent(rep.getTasaDocumento());
        }
        if (rep.getObservaciones() != null) {
            type.addNote(rep.getObservaciones());
        }
        extensionContentType.setAny((Object)this.sunatSingerUtils.getSignToElement(organization));
        ublExtensionType.setExtensionContent(extensionContentType);
        ublExtensionsType.setUBLExtension(new ArrayList<UBLExtensionType>(Arrays.asList(ublExtensionType)));
        type.setUblExtensions(ublExtensionsType);
        type.setTotalInvoiceAmount(rep.getTotalDocumentoSunat(), rep.getMonedaDocumento());
        type.setSunatTotalCashed(rep.getTotalPago(), rep.getMonedaDocumento());
        for (DocumentoSunatLineRepresentation reference : rep.getDetalle()) {
            type.addPerceptionDocumentReference(this.toPerceptionDocumentReferenceType(reference, rep.getMonedaDocumento(), rep.getTasaDocumento()));
        }
        return type;
    }

    private SUNATPerceptionDocumentReferenceType toPerceptionDocumentReferenceType(DocumentoSunatLineRepresentation rep, String currencyCode, BigDecimal perception) {
        SUNATPerceptionDocumentReferenceType type = new SUNATPerceptionDocumentReferenceType();
        type.setId(this.toIDType(rep));
        if (rep.getFechaDocumentoRelacionado() != null) {
            type.setIssueDate(this.toGregorianCalendar(DateUtils.asLocalDate((Date)rep.getFechaDocumentoRelacionado())));
        }
        if (rep.getTotalDocumentoRelacionado() != null && rep.getMonedaDocumentoRelacionado() != null) {
            type.setTotalInvoiceAmount(rep.getTotalDocumentoRelacionado(), rep.getMonedaDocumentoRelacionado());
        }
        type.setPayment(this.toPaymentType(rep));
        type.setSunatPerceptionInformation(this.toSUNATPerceptionInformationType(rep, currencyCode, perception));
        return type;
    }

    private SUNATPerceptionInformationType toSUNATPerceptionInformationType(DocumentoSunatLineRepresentation rep, String currencyCode, BigDecimal perception) {
        SUNATPerceptionInformationType type = new SUNATPerceptionInformationType();
        type.setSunatPerceptionAmount(this.toSUNATAmountType(rep, currencyCode, perception));
        if (rep.getFechaDocumentoRelacionado() != null) {
            type.setSunatPerceptionDate(this.toGregorianCalendar(DateUtils.asLocalDate((Date)rep.getFechaDocumentoRelacionado())));
        }
        type.setSunatNetTotalCashed(this.tosetSUNATNetTotalPaidType(rep, currencyCode, perception));
        type.setExchangeRate(this.toExchangeRateType(rep, currencyCode));
        return type;
    }

    public RetentionType toRetentionType(OrganizationModel organization, DocumentoSunatRepresentation rep) {
        RetentionType type = new RetentionType();
        type.setUblVersionID(UblSunatConfiguration.VERSION_ID.getCodigo());
        type.setCustomizationID(UblSunatConfiguration.CUSTOMIZATION_ID10.getCodigo());
        type.addSignature(this.toSignatureType(organization));
        UBLExtensionsType ublExtensionsType = new UBLExtensionsType();
        UBLExtensionType ublExtensionType = new UBLExtensionType();
        ExtensionContentType extensionContentType = new ExtensionContentType();
        if (rep.getSerieDocumento() != null && rep.getNumeroDocumento() != null) {
            type.setId(rep.getSerieDocumento() + UblSunatConfiguration.ID_SEPARATOR.getCodigo() + rep.getNumeroDocumento());
        }
        if (rep.getFechaDeEmision() != null) {
            type.setIssueDate(this.toGregorianCalendar(DateUtils.asLocalDateTime((Date)rep.getFechaDeEmision()).toLocalDate()));
        } else {
            type.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
        }
        type.setAgentParty(this.toAgentPartyType(organization));
        type.setReceiverParty(this.toReceiverPartyType(rep));
        if (rep.getCodigoDocumento() != null) {
            type.setSunatRetentionSystemCode(rep.getCodigoDocumento());
        }
        if (rep.getTasaDocumento() != null) {
            type.setSunatRetentionPercent(rep.getTasaDocumento());
        }
        if (rep.getObservaciones() != null) {
            type.addNote(rep.getObservaciones());
        }
        extensionContentType.setAny((Object)this.sunatSingerUtils.getSignToElement(organization));
        ublExtensionType.setExtensionContent(extensionContentType);
        ublExtensionsType.setUBLExtension(new ArrayList<UBLExtensionType>(Arrays.asList(ublExtensionType)));
        type.setUblExtensions(ublExtensionsType);
        type.setTotalInvoiceAmount(rep.getTotalDocumentoSunat(), rep.getMonedaDocumento());
        type.setSunatTotalPaid(rep.getTotalPago(), rep.getMonedaDocumento());
        for (DocumentoSunatLineRepresentation reference : rep.getDetalle()) {
            type.addRetentionDocumentReference(this.toRetentionDocumentReferenceType(reference, rep.getMonedaDocumento(), rep.getTasaDocumento()));
        }
        return type;
    }

    private SUNATRetentionDocumentReferenceType toRetentionDocumentReferenceType(DocumentoSunatLineRepresentation rep, String currencyCode, BigDecimal retencion) {
        SUNATRetentionDocumentReferenceType type = new SUNATRetentionDocumentReferenceType();
        type.setID(this.toIDType(rep));
        if (rep.getFechaDocumentoRelacionado() != null) {
            type.setIssueDate(this.toGregorianCalendar(DateUtils.asLocalDate((Date)rep.getFechaDocumentoRelacionado())));
        }
        if (rep.getTotalDocumentoRelacionado() != null && rep.getMonedaDocumentoRelacionado() != null) {
            type.setTotalInvoiceAmount(rep.getTotalDocumentoRelacionado(), rep.getMonedaDocumentoRelacionado());
        }
        type.setPayment(this.toPaymentType(rep));
        type.setSUNATRetentionInformation(this.toSUNATRetentionInformation(rep, currencyCode, retencion));
        return type;
    }

    private SUNATRetentionInformationType toSUNATRetentionInformation(DocumentoSunatLineRepresentation rep, String currencyCode, BigDecimal retencion) {
        SUNATRetentionInformationType type = new SUNATRetentionInformationType();
        type.setSUNATRetentionAmount(this.toSUNATAmountType(rep, currencyCode, retencion));
        if (rep.getFechaDocumentoRelacionado() != null) {
            type.setSUNATRetentionDate(this.toGregorianCalendar(DateUtils.asLocalDate((Date)rep.getFechaDocumentoRelacionado())));
        }
        type.setSUNATNetTotalPaid(this.tosetSUNATNetTotalPaidType(rep, currencyCode, retencion));
        if (rep.getTipoCambio() != null) {
            type.setExchangeRate(this.toExchangeRateType(rep, currencyCode));
        }
        return type;
    }

    public UBLExtensionsType toUBLExtensionsType(DocumentRepresentation rep) {
        UBLExtensionsType ublExtensionsType = new UBLExtensionsType();
        UBLExtensionType ublExtensionType = new UBLExtensionType();
        ExtensionContentType extensionContentType = new ExtensionContentType();
        AdditionalMonetaryTotalType gravado = new AdditionalMonetaryTotalType();
        if (rep.getTotalGravada() != null) {
            gravado.setID(new IDType(TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_GRAVADAS.getCodigo()));
            PayableAmountType payableAmountType = new PayableAmountType(rep.getTotalGravada());
            payableAmountType.setCurrencyID(rep.getMoneda());
            gravado.setPayableAmount(payableAmountType);
        }
        AdditionalMonetaryTotalType inafecto = new AdditionalMonetaryTotalType();
        if (rep.getTotalInafecta() != null) {
            inafecto.setID(new IDType(TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_INAFECTAS.getCodigo()));
            PayableAmountType payableAmountType = new PayableAmountType(rep.getTotalInafecta());
            payableAmountType.setCurrencyID(rep.getMoneda());
            inafecto.setPayableAmount(payableAmountType);
        }
        AdditionalMonetaryTotalType exonerado = new AdditionalMonetaryTotalType();
        if (rep.getTotalExonerada() != null) {
            exonerado.setID(new IDType(TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_EXONERADAS.getCodigo()));
            PayableAmountType payableAmountType = new PayableAmountType(rep.getTotalExonerada());
            payableAmountType.setCurrencyID(rep.getMoneda());
            exonerado.setPayableAmount(payableAmountType);
        }
        AdditionalMonetaryTotalType gratuito = new AdditionalMonetaryTotalType();
        if (rep.getTotalGratuita() != null) {
            gratuito.setID(new IDType(TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_GRATUITAS.getCodigo()));
            PayableAmountType payableAmountType = new PayableAmountType(rep.getTotalGratuita());
            payableAmountType.setCurrencyID(rep.getMoneda());
            gratuito.setPayableAmount(payableAmountType);
        }
        AdditionalPropertyType leyendaMontoTexto = null;
        AdditionalPropertyType leyendaGratuito = null;
        if (rep.getTotal().compareTo(new BigDecimal(Integer.MAX_VALUE)) < 0) {
            MoneyConverters converter = MoneyConverters.SPANISH_BANKING_MONEY_VALUE;
            String valueAsWords = converter.asWords(rep.getTotal());
            leyendaMontoTexto = new AdditionalPropertyType();
            leyendaMontoTexto.setID(new IDType(TipoElementosAdicionalesComprobante.MONTO_EN_LETRAS.getCodigo()));
            leyendaMontoTexto.setValue(new ValueType(valueAsWords));
        }
        if (rep.isOperacionGratuita()) {
            leyendaGratuito = new AdditionalPropertyType();
            leyendaGratuito.setID(new IDType(TipoElementosAdicionalesComprobante.LEYENDA_TRANSFERENCIA_GRATUITA.getCodigo()));
            leyendaGratuito.setValue(new ValueType(TipoElementosAdicionalesComprobante.LEYENDA_TRANSFERENCIA_GRATUITA.getDenominacion()));
        }
        List additionalMonetaryTotalTypes = Arrays.asList(gravado, inafecto, exonerado, gratuito).stream().filter(p -> p.getPayableAmount().getValue().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        List additionalPropertyTypes = Arrays.asList(leyendaMontoTexto, leyendaGratuito).stream().filter(p -> p != null).collect(Collectors.toList());
        AdditionalInformationTypeSunatAgg additionalInformation = new AdditionalInformationTypeSunatAgg();
        if (!additionalMonetaryTotalTypes.isEmpty()) {
            additionalInformation.getAdditionalMonetaryTotal().addAll(additionalMonetaryTotalTypes);
        }
        if (!additionalPropertyTypes.isEmpty()) {
            additionalInformation.getAdditionalProperty().addAll(additionalPropertyTypes);
        }
        extensionContentType.setAny((Object)this.generateElement(additionalInformation));
        ublExtensionType.setExtensionContent(extensionContentType);
        ublExtensionsType.setUBLExtension(new ArrayList<UBLExtensionType>(Arrays.asList(ublExtensionType)));
        return ublExtensionsType;
    }

    public PriceType toPriceType(String currencyID, BigDecimal amount, String priceTypeCode) {
        PriceType priceType = new PriceType();
        PriceAmountType amountType = new PriceAmountType(amount);
        amountType.setCurrencyID(currencyID);
        priceType.setPriceTypeCode(priceTypeCode);
        priceType.setPriceAmount(amountType);
        return priceType;
    }

    private AmountType tosetSUNATNetTotalPaidType(DocumentoSunatLineRepresentation rep, String currencyCode, BigDecimal retencion) {
        AmountType type = new AmountType();
        type.setCurrencyID(currencyCode);
        type.setValue(rep.getImportePago());
        return type;
    }

    private AmountType toSUNATAmountType(DocumentoSunatLineRepresentation rep, String currencyCode, BigDecimal retencion) {
        AmountType type = new AmountType();
        type.setCurrencyID(currencyCode);
        type.setValue(rep.getImporteDocumentoSunat());
        return type;
    }

    private ExchangeRateType toExchangeRateType(DocumentoSunatLineRepresentation rep, String currencyCode) {
        ExchangeRateType type = new ExchangeRateType();
        if (rep.getTipoCambio() != null) {
            type.setCalculationRate(rep.getTipoCambio());
            if (rep.getMonedaDocumentoRelacionado() != null) {
                type.setSourceCurrencyCode(rep.getMonedaDocumentoRelacionado());
            }
            type.setTargetCurrencyCode(currencyCode);
            if (rep.getFechaCambio() != null) {
                type.setDate(this.toGregorianCalendar(DateUtils.asLocalDate((Date)rep.getFechaCambio())));
            }
        } else {
            type.setCalculationRate(new BigDecimal(1));
            type.setSourceCurrencyCode(currencyCode);
            type.setTargetCurrencyCode(currencyCode);
            type.setDate(this.toGregorianCalendar(LocalDate.now()));
        }
        return type;
    }

    private PaymentType toPaymentType(DocumentoSunatLineRepresentation rep) {
        PaymentType type = new PaymentType();
        if (rep.getNumeroPago() != null) {
            type.setID(rep.getNumeroPago());
        }
        type.setPaidAmount(this.toPaidAmountType(rep));
        if (rep.getFechaDocumentoRelacionado() != null) {
            type.setPaidDate(this.toGregorianCalendar(DateUtils.asLocalDate((Date)rep.getFechaDocumentoRelacionado())));
        }
        return type;
    }

    private PaidAmountType toPaidAmountType(DocumentoSunatLineRepresentation rep) {
        PaidAmountType type = new PaidAmountType();
        if (rep.getMonedaDocumentoRelacionado() != null) {
            type.setCurrencyID(rep.getMonedaDocumentoRelacionado());
        }
        if (rep.getPagoDocumentoSunat() != null) {
            type.setValue(rep.getPagoDocumentoSunat());
        }
        return type;
    }

    private IDType toIDType(DocumentoSunatLineRepresentation rep) {
        IDType type = new IDType();
        if (rep.getTipoDocumentoRelacionado() != null) {
            type.setSchemeID(rep.getTipoDocumentoRelacionado());
        }
        if (rep.getNumeroDocumentoRelacionado() != null) {
            type.setValue(rep.getNumeroDocumentoRelacionado().toUpperCase());
        }
        return type;
    }

    private PartyType toReceiverPartyType(DocumentoSunatRepresentation rep) {
        PartyType type = new PartyType();
        type.setPartyIdentification(this.toPartyIdentificationType(rep));
        type.setPartyName(this.toPartyNameType(rep));
        type.setPostalAddress(this.toPostalAddressType(rep));
        type.setPartyLegalEntity(Arrays.asList(this.toPartyLegalEntityType(rep)));
        type.setContact(this.toContactType(rep));
        return type;
    }

    private ContactType toContactType(DocumentoSunatRepresentation rep) {
        ContactType type = new ContactType();
        if (rep.getEntidadEmail() != null) {
            type.setElectronicMail(rep.getEntidadEmail());
        }
        return type;
    }

    private PartyLegalEntityType toPartyLegalEntityType(DocumentoSunatRepresentation rep) {
        PartyLegalEntityType type = new PartyLegalEntityType();
        if (rep.getEntidadDenominacion() != null) {
            type.setRegistrationName(rep.getEntidadDenominacion());
        }
        return type;
    }

    private AddressType toPostalAddressType(DocumentoSunatRepresentation rep) {
        if (rep.getEntidadDireccion() != null) {
            AddressType type = new AddressType();
            type.setStreetName(rep.getEntidadDireccion());
            return type;
        }
        return null;
    }

    private List<PartyNameType> toPartyNameType(DocumentoSunatRepresentation rep) {
        ArrayList<PartyNameType> list = new ArrayList<PartyNameType>();
        PartyNameType type = new PartyNameType();
        if (rep.getEntidadDenominacion() != null) {
            type.setName(rep.getEntidadDenominacion());
        }
        list.add(type);
        return list;
    }

    private List<PartyIdentificationType> toPartyIdentificationType(DocumentoSunatRepresentation rep) {
        ArrayList<PartyIdentificationType> list = new ArrayList<PartyIdentificationType>();
        PartyIdentificationType type = new PartyIdentificationType();
        type.setID(this.toIDType(rep));
        list.add(type);
        return list;
    }

    private IDType toIDType(DocumentoSunatRepresentation rep) {
        IDType type = new IDType();
        if (rep.getEntidadTipoDeDocumento() != null) {
            type.setSchemeID(rep.getEntidadTipoDeDocumento());
        }
        if (rep.getEntidadNumeroDeDocumento() != null) {
            type.setValue(rep.getEntidadNumeroDeDocumento());
        }
        return type;
    }

    private PartyType toAgentPartyType(OrganizationModel organization) {
        PartyType type = new PartyType();
        type.setPartyIdentification(Arrays.asList(this.toPartyIdentificationType(organization, false)));
        type.setPartyName(Arrays.asList(this.toPartyNameType(organization)));
        type.setPostalAddress(this.toPostalAddressType(organization));
        type.setPartyLegalEntity(Arrays.asList(this.toPartyLegalEntityType(organization)));
        return type;
    }

    private PartyLegalEntityType toPartyLegalEntityType(OrganizationModel organization) {
        PartyLegalEntityType type = new PartyLegalEntityType();
        if (organization.getRegistrationName() != null) {
            type.setRegistrationName(organization.getRegistrationName());
        }
        return type;
    }

    private PartyNameType toPartyName(OrganizationModel organization) {
        PartyNameType type = new PartyNameType();
        if (organization.getSupplierName() != null) {
            type.setName(organization.getSupplierName());
        }
        return type;
    }

    private AddressType toPostalAddressType(OrganizationModel organization) {
        AddressType type = new AddressType();
        if (organization.getPostalAddressId() != null) {
            type.setID(organization.getPostalAddressId());
        }
        if (organization.getStreetName() != null) {
            type.setStreetName(organization.getStreetName());
        }
        if (organization.getCitySubdivisionName() != null) {
            type.setCitySubdivisionName(organization.getCitySubdivisionName());
        }
        if (organization.getCityName() != null) {
            type.setCityName(organization.getCityName());
        }
        if (organization.getCountrySubentity() != null) {
            type.setCountrySubentity(organization.getCountrySubentity());
        }
        if (organization.getDistrict() != null) {
            type.setDistrict(organization.getDistrict());
        }
        type.setCountry(this.toCountryType(organization));
        return type;
    }

    private CountryType toCountryType(OrganizationModel organization) {
        CountryType type = new CountryType();
        if (organization.getCountryIdentificationCode() != null) {
            type.setIdentificationCode(organization.getCountryIdentificationCode());
        }
        return type;
    }

    public SignatureType toSignatureType(OrganizationModel organization) {
        SignatureType type = new SignatureType();
        if (organization.getName() != null) {
            type.setID(UblSunatConfiguration.ID_SIGN.getCodigo() + organization.getName().toUpperCase().replaceAll("\\s", ""));
        }
        type.setSignatoryParty(this.toSignatoryPartyType(organization));
        type.setDigitalSignatureAttachment(this.toDigitalSignatureAttachmentType(organization));
        return type;
    }

    private AttachmentType toDigitalSignatureAttachmentType(OrganizationModel organization) {
        AttachmentType type = new AttachmentType();
        type.setExternalReference(this.toExternalReferenceType(organization));
        return type;
    }

    private ExternalReferenceType toExternalReferenceType(OrganizationModel organization) {
        ExternalReferenceType type = new ExternalReferenceType();
        if (organization.getName() != null) {
            type.setURI(UblSunatConfiguration.URI_SIGN.getCodigo() + organization.getName().toUpperCase().replaceAll("\\s", ""));
        }
        return type;
    }

    private PartyType toSignatoryPartyType(OrganizationModel organization) {
        PartyType type = new PartyType();
        type.setPartyIdentification(Arrays.asList(this.toPartyIdentificationType(organization, true)));
        type.setPartyName(Arrays.asList(this.toPartyNameType(organization)));
        return type;
    }

    private PartyNameType toPartyNameType(OrganizationModel organization) {
        PartyNameType type = new PartyNameType();
        if (organization.getRegistrationName() != null) {
            type.setName(organization.getRegistrationName());
        }
        return type;
    }

    private PartyIdentificationType toPartyIdentificationType(OrganizationModel organization, boolean sign) {
        PartyIdentificationType type = new PartyIdentificationType();
        if (sign) {
            if (organization.getAssignedIdentificationId() != null) {
                type.setID(organization.getAssignedIdentificationId());
            }
        } else {
            type.setID(this.toIDType(organization));
        }
        return type;
    }

    private IDType toIDType(OrganizationModel organization) {
        IDType type = new IDType();
        if (organization.getAssignedIdentificationId() != null) {
            type.setValue(organization.getAssignedIdentificationId());
        }
        if (organization.getAdditionalAccountId() != null) {
            type.setSchemeID(organization.getAdditionalAccountId());
        }
        return type;
    }

    public SummaryDocumentsType toSummaryDocumentType(OrganizationModel organization, SummaryRepresentation rep) {
        SummaryDocumentsType type = new SummaryDocumentsType();
        UBLExtensionsType ublExtensionsType = new UBLExtensionsType();
        UBLExtensionType ublExtensionType = new UBLExtensionType();
        ExtensionContentType extensionContentType = new ExtensionContentType();
        extensionContentType.setAny((Object)this.sunatSingerUtils.getSignToElement(organization));
        ublExtensionType.setExtensionContent(extensionContentType);
        ublExtensionsType.setUBLExtension(new ArrayList<UBLExtensionType>(Arrays.asList(ublExtensionType)));
        type.setUblExtensions(ublExtensionsType);
        type.setUblVersionID(UblSunatConfiguration.VERSION_ID.getCodigo());
        type.setCustomizationID(UblSunatConfiguration.CUSTOMIZATION_ID10.getCodigo());
        if (rep.getFechaDeReferencia() != null) {
            type.setReferenceDateTime(this.toGregorianCalendar(rep.getFechaDeReferencia().toLocalDate()));
        }
        if (rep.getFechaDeEmision() != null) {
            type.setIssueDate(this.toGregorianCalendar(rep.getFechaDeEmision().toLocalDate()));
        } else {
            type.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
        }
        type.addSignature(this.toSignatureType(organization));
        type.setAccountingSupplierParty(this.toAccountingSupplierPartyType(organization));
        if (rep.getLine() != null && !rep.getLine().isEmpty()) {
            for (int i = 0; i < rep.getLine().size(); ++i) {
                SummaryLineRepresentation summaryLineRepresentation = (SummaryLineRepresentation)rep.getLine().get(i);
                SummaryDocumentsLineType lineType = new SummaryDocumentsLineType();
                lineType.setLineID(String.valueOf(i + 1));
                if (summaryLineRepresentation.getCodigoDocumento() != null) {
                    lineType.setDocumentTypeCode(summaryLineRepresentation.getCodigoDocumento());
                }
                if (summaryLineRepresentation.getSerieDocumento() != null) {
                    lineType.setDocumentSerialID(summaryLineRepresentation.getSerieDocumento());
                }
                if (summaryLineRepresentation.getNumeroInicioDocumento() != null) {
                    lineType.setStartDocumentNumberID(summaryLineRepresentation.getNumeroInicioDocumento());
                }
                if (summaryLineRepresentation.getNumeroFinDocumento() != null) {
                    lineType.setEndDocumentNumberID(summaryLineRepresentation.getNumeroFinDocumento());
                }
                if (summaryLineRepresentation.getTotalAmount() != null && summaryLineRepresentation.getMoneda() != null) {
                    lineType.setTotalAmount(summaryLineRepresentation.getTotalAmount(), summaryLineRepresentation.getMoneda());
                }
                if (summaryLineRepresentation.getPayment() != null) {
                    for (BillingPaymentRepresentation payment : summaryLineRepresentation.getPayment()) {
                        lineType.addBillingPayment(this.toBillingPaymentType(payment, summaryLineRepresentation.getMoneda()));
                    }
                }
                lineType.addAllowanceCharge(this.toAllowanceChargeType(summaryLineRepresentation, summaryLineRepresentation.getMoneda()));
                if (summaryLineRepresentation.getTaxTotal() != null && !summaryLineRepresentation.getTaxTotal().isEmpty()) {
                    for (TaxTotalRepresentation tax : summaryLineRepresentation.getTaxTotal()) {
                        lineType.addTaxTotal(this.toTaxTotalType(tax, summaryLineRepresentation.getMoneda()));
                    }
                }
                type.addSummaryDocumentsLine(lineType);
            }
        }
        return type;
    }

    private TaxTotalType toTaxTotalType(TaxTotalRepresentation rep, String currencyCode) {
        TaxTotalType type = new TaxTotalType();
        type.setTaxAmount(this.toTaxAmountType(rep, currencyCode));
        type.addTaxSubtotal(this.toTaxSubtotalType(rep, currencyCode));
        return type;
    }

    private TaxSubtotalType toTaxSubtotalType(TaxTotalRepresentation rep, String currencyCode) {
        TaxSubtotalType type = new TaxSubtotalType();
        type.setTaxAmount(this.toTaxAmountType(rep, currencyCode));
        type.setTaxCategory(this.toTaxCategoryType(rep));
        return type;
    }

    private TaxCategoryType toTaxCategoryType(TaxTotalRepresentation rep) {
        TaxCategoryType type = new TaxCategoryType();
        type.setTaxScheme(this.toTaxSchemeType(rep));
        return type;
    }

    private TaxSchemeType toTaxSchemeType(TaxTotalRepresentation rep) {
        TaxSchemeType type = new TaxSchemeType();
        if (rep.getTaxSchemeID() != null) {
            type.setID(rep.getTaxSchemeID());
        }
        if (rep.getTaxSchemeName() != null) {
            type.setName(rep.getTaxSchemeName());
        }
        if (rep.getTaxTypeCode() != null) {
            type.setTaxTypeCode(rep.getTaxTypeCode());
        }
        return type;
    }

    private TaxAmountType toTaxAmountType(TaxTotalRepresentation rep, String currencycode) {
        TaxAmountType type = new TaxAmountType();
        type.setCurrencyID(currencycode);
        if (rep.getTaxAmount() != null) {
            type.setValue(rep.getTaxAmount());
        }
        return type;
    }

    private AllowanceChargeType toAllowanceChargeType(SummaryLineRepresentation rep, String moneda) {
        AllowanceChargeType type = new AllowanceChargeType();
        type.setChargeIndicator(rep.isChargeIndicator());
        if (rep.getChargeAmount() != null) {
            AmountType amountType = new AmountType();
            amountType.setValue(rep.getChargeAmount());
            amountType.setCurrencyID(moneda);
            type.setAmount(amountType);
        }
        return type;
    }

    private PaymentType toBillingPaymentType(BillingPaymentRepresentation rep, String currencycode) {
        PaymentType type = new PaymentType();
        type.setPaidAmount(this.toPaidAmountType(rep, currencycode));
        if (rep.getInstructionID() != null) {
            type.setInstructionID(rep.getInstructionID());
        }
        return type;
    }

    private PaidAmountType toPaidAmountType(BillingPaymentRepresentation rep, String currencycode) {
        PaidAmountType type = new PaidAmountType();
        type.setCurrencyID(currencycode);
        if (rep.getPaidAmount() != null) {
            type.setValue(rep.getPaidAmount());
        }
        return type;
    }

    public VoidedDocumentsType toVoidedDocumentType(OrganizationModel organization, VoidedRepresentation rep) {
        VoidedDocumentsType type = new VoidedDocumentsType();
        UBLExtensionsType ublExtensionsType = new UBLExtensionsType();
        UBLExtensionType ublExtensionType = new UBLExtensionType();
        ExtensionContentType extensionContentType = new ExtensionContentType();
        type.setUBLVersionID(UblSunatConfiguration.VERSION_ID.getCodigo());
        type.setCustomizationID(UblSunatConfiguration.CUSTOMIZATION_ID10.getCodigo());
        if (rep.getSerieDocumento() != null && rep.getNumeroDocumento() != null) {
            type.setID(rep.getSerieDocumento() + UblSunatConfiguration.ID_SEPARATOR.getCodigo() + rep.getNumeroDocumento());
        }
        if (rep.getFechaDeEmision() != null) {
            type.setIssueDate(this.toGregorianCalendar(DateUtils.asLocalDateTime((Date)rep.getFechaDeEmision()).toLocalDate()));
            type.setReferenceDate(this.toGregorianCalendar(DateUtils.asLocalDateTime((Date)rep.getFechaDeEmision()).toLocalDate()));
        } else {
            type.setIssueDate(this.toGregorianCalendar(LocalDate.now()));
            type.setReferenceDate(this.toGregorianCalendar(LocalDate.now()));
        }
        if (rep.getObservaciones() != null) {
            type.addNote(rep.getObservaciones());
        }
        type.addSignature(this.toSignatureType(organization));
        type.setAccountingSupplierParty(this.toSupplierParty(organization));
        extensionContentType.setAny((Object)this.sunatSingerUtils.getSignToElement(organization));
        ublExtensionType.setExtensionContent(extensionContentType);
        ublExtensionsType.setUBLExtension(new ArrayList<UBLExtensionType>(Arrays.asList(ublExtensionType)));
        type.setUBLExtensions(ublExtensionsType);
        if (rep.getDetalle() != null) {
            for (int i = 0; i < rep.getDetalle().size(); ++i) {
                VoidedLineRepresentation lineRepresentation = (VoidedLineRepresentation)rep.getDetalle().get(i);
                VoidedDocumentsLineType voidedDocumentsLineType = new VoidedDocumentsLineType();
                voidedDocumentsLineType.setLineID(String.valueOf(i + 1));
                if (lineRepresentation.getTipoDocumentoRelacionado() != null) {
                    voidedDocumentsLineType.setDocumentTypeCode(lineRepresentation.getTipoDocumentoRelacionado());
                }
                if (lineRepresentation.getNumeroDocumentoRelacionado() != null) {
                    String[] splits = lineRepresentation.getNumeroDocumentoRelacionado().toUpperCase().split("-");
                    voidedDocumentsLineType.setDocumentSerialID(splits[0]);
                    voidedDocumentsLineType.setDocumentNumberID(splits[1]);
                }
                if (lineRepresentation.getDescripcionDocumentoRelacionado() != null) {
                    voidedDocumentsLineType.setVoidReasonDescription(lineRepresentation.getDescripcionDocumentoRelacionado());
                }
                type.addVoidedDocumentsLine(voidedDocumentsLineType);
            }
        }
        return type;
    }

    private SupplierPartyType toAccountingSupplierPartyType(OrganizationModel organization) {
        SupplierPartyType type = new SupplierPartyType();
        type.setCustomerAssignedAccountID(organization.getAssignedIdentificationId());
        type.setAdditionalAccountID(this.toAdditionalAccountIDType(organization));
        type.setParty(this.toPartyType(organization));
        return type;
    }

    private PartyType toPartyType(OrganizationModel organization) {
        PartyType type = new PartyType();
        type.setPartyLegalEntity(Arrays.asList(this.toPartyLegalEntityType(organization)));
        type.setPartyName(Arrays.asList(this.toPartyName(organization)));
        return type;
    }

    private List<AdditionalAccountIDType> toAdditionalAccountIDType(OrganizationModel organization) {
        ArrayList<AdditionalAccountIDType> list = new ArrayList<AdditionalAccountIDType>();
        AdditionalAccountIDType type = new AdditionalAccountIDType();
        type.setValue(organization.getAdditionalAccountId());
        list.add(type);
        return list;
    }

    public SupplierPartyType toSupplierParty(OrganizationModel organization) {
        SupplierPartyType supplierPartyType = new SupplierPartyType();
        if (organization.getAdditionalAccountId() != null) {
            ArrayList<AdditionalAccountIDType> additionalAccountIDType = new ArrayList<AdditionalAccountIDType>();
            additionalAccountIDType.add(new AdditionalAccountIDType(organization.getAdditionalAccountId()));
            supplierPartyType.setAdditionalAccountID(additionalAccountIDType);
        }
        if (organization.getAssignedIdentificationId() != null) {
            supplierPartyType.setCustomerAssignedAccountID(organization.getAssignedIdentificationId());
        }
        PartyType partyType = new PartyType();
        if (organization.getRegistrationName() != null) {
            partyType.setPartyLegalEntity(Arrays.asList(this.toPartyLegalEntityType(organization)));
            AddressType addressType = new AddressType();
            if (organization.getStreetName() == null || organization.getCitySubdivisionName() == null || organization.getCityName() == null || organization.getCountrySubentity() == null || organization.getDistrict() == null || organization.getCountryIdentificationCode() == null) {
                throw new ModelRuntimeException("Inssuficient information on organization");
            }
            addressType.setID(organization.getPostalAddressId());
            addressType.setStreetName(organization.getStreetName());
            addressType.setCitySubdivisionName(organization.getCitySubdivisionName());
            addressType.setCityName(organization.getCityName());
            addressType.setCountrySubentity(organization.getCountrySubentity());
            CountryType countryType = new CountryType();
            countryType.setIdentificationCode(organization.getCountryIdentificationCode());
            addressType.setCountry(countryType);
            partyType.setPostalAddress(addressType);
        }
        if (organization.getSupplierName() != null) {
            partyType.setPartyName(Arrays.asList(this.toPartyName(organization)));
        }
        supplierPartyType.setParty(partyType);
        return supplierPartyType;
    }

    public CustomerPartyType toCustomerPartyType(DocumentRepresentation rep) {
        CustomerPartyType customerPartyType = new CustomerPartyType();
        if (rep.getEntidadTipoDeDocumento() != null) {
            ArrayList<AdditionalAccountIDType> additionalAccountIDType = new ArrayList<AdditionalAccountIDType>();
            additionalAccountIDType.add(new AdditionalAccountIDType(rep.getEntidadTipoDeDocumento()));
            customerPartyType.setAdditionalAccountID(additionalAccountIDType);
        }
        if (rep.getEntidadNumeroDeDocumento() != null) {
            customerPartyType.setCustomerAssignedAccountID(rep.getEntidadNumeroDeDocumento());
        }
        PartyType partyType = new PartyType();
        if (rep.getEntidadDenominacion() != null) {
            ArrayList<PartyLegalEntityType> partyLegalEntityTypes = new ArrayList<PartyLegalEntityType>();
            PartyLegalEntityType partyLegalEntityType = new PartyLegalEntityType();
            partyLegalEntityType.setRegistrationName(rep.getEntidadDenominacion());
            partyLegalEntityTypes.add(partyLegalEntityType);
            partyType.setPartyLegalEntity(partyLegalEntityTypes);
            if (rep.getEntidadDireccion() != null) {
                AddressType addressType = new AddressType();
                addressType.setStreetName(rep.getEntidadDireccion());
                partyType.setPostalAddress(addressType);
            }
            if (rep.getEntidadEmail() != null) {
                ContactType contactType = new ContactType();
                contactType.setElectronicMail(rep.getEntidadEmail());
                partyType.setContact(contactType);
            }
        }
        customerPartyType.setParty(partyType);
        return customerPartyType;
    }

    public Element generateElement(AdditionalInformationTypeSunatAgg object) {
        try {
            InvoiceFactory factory = new InvoiceFactory();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{InvoiceFactory.class});
            Marshaller marshallerElement = context.createMarshaller();
            JAXBElement jaxbElement = factory.createAdditionalInformation(object);
            DOMResult res = new DOMResult();
            marshallerElement.marshal((Object)jaxbElement, (Result)res);
            Element element = ((Document)res.getNode()).getDocumentElement();
            return element;
        }
        catch (JAXBException e) {
            throw new ModelRuntimeException((Throwable)e);
        }
    }

    public MonetaryTotalType toLegalMonetaryTotalType(DocumentRepresentation rep) {
        MonetaryTotalType monetaryTotalType = new MonetaryTotalType();
        if (rep.getTotal() != null) {
            PayableAmountType payableAmountType = new PayableAmountType(rep.getTotal());
            payableAmountType.setCurrencyID(rep.getMoneda());
            monetaryTotalType.setPayableAmount(payableAmountType);
        }
        if (rep.getTotalOtrosCargos() != null && rep.getTotalOtrosCargos().compareTo(BigDecimal.ZERO) > 0) {
            ChargeTotalAmountType chargeTotalAmountType = new ChargeTotalAmountType(rep.getTotalOtrosCargos());
            chargeTotalAmountType.setCurrencyID(rep.getMoneda());
            monetaryTotalType.setChargeTotalAmount(chargeTotalAmountType);
        }
        if (rep.getDescuentoGlobal() != null && rep.getDescuentoGlobal().compareTo(BigDecimal.ZERO) > 0) {
            AllowanceTotalAmountType allowanceTotalAmountType = new AllowanceTotalAmountType(rep.getDescuentoGlobal());
            allowanceTotalAmountType.setCurrencyID(rep.getMoneda());
            monetaryTotalType.setAllowanceTotalAmount(allowanceTotalAmountType);
        }
        return monetaryTotalType;
    }

    public TaxTotalType toTaxTotalIGV(DocumentRepresentation rep) {
        TaxTotalType taxTotalType = new TaxTotalType();
        TaxAmountType taxAmountType1 = new TaxAmountType(rep.getTotalIgv());
        taxAmountType1.setCurrencyID(rep.getMoneda());
        taxTotalType.setTaxAmount(taxAmountType1);
        TaxSubtotalType taxSubtotalType = new TaxSubtotalType();
        TaxAmountType taxAmountType2 = new TaxAmountType(rep.getTotalIgv());
        taxAmountType2.setCurrencyID(rep.getMoneda());
        taxSubtotalType.setTaxAmount(taxAmountType2);
        TaxCategoryType taxCategoryType = new TaxCategoryType();
        TaxSchemeType taxSchemeType = new TaxSchemeType();
        taxSchemeType.setID(TipoTributo.IGV.getId());
        taxSchemeType.setName(TipoTributo.IGV.toString());
        taxSchemeType.setTaxTypeCode(TipoTributo.IGV.getCodigo());
        taxCategoryType.setTaxScheme(taxSchemeType);
        taxSubtotalType.setTaxCategory(taxCategoryType);
        taxTotalType.setTaxSubtotal(Arrays.asList(taxSubtotalType));
        return taxTotalType;
    }
}

