/*
 * Decompiled with CFR 0.152.
 */
package pe.gob.sunat;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class UsernameTokenCallbackHandler
implements SOAPHandler<SOAPMessageContext> {
    private String usernameText;
    private String passwordText;

    public UsernameTokenCallbackHandler(String usernameText, String passwordText) {
        this.usernameText = usernameText;
        this.passwordText = passwordText;
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        Boolean outboundProperty = (Boolean)soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            try {
                SOAPEnvelope soapEnvelope = soapMessageContext.getMessage().getSOAPPart().getEnvelope();
                SOAPFactory soapFactory = SOAPFactory.newInstance();
                SOAPElement securityElement = soapFactory.createElement(this.getUsernameTokenElement(this.usernameText, this.passwordText));
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                if (soapHeader == null) {
                    soapHeader = soapEnvelope.addHeader();
                }
                soapHeader.addChildElement(securityElement);
            }
            catch (Exception e) {
                throw new RuntimeException("Error on wsSecurityHandler: " + e.getMessage());
            }
        }
        return true;
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public String getUsernameTokenString(Map<String, Object> ctx) {
        Document doc = DOMUtils.createDocument();
        String result = null;
        String username = (String)ctx.get("security.username");
        String password = (String)ctx.get("security.password");
        if (username != null) {
            UsernameToken usernameToken = this.createWSSEUsernameToken(username, password, doc);
            result = this.toString(usernameToken.getElement().getFirstChild().getParentNode());
        }
        return result;
    }

    public String getUsernameTokenString(String username, String password) {
        Document doc = DOMUtils.createDocument();
        String result = null;
        if (username != null) {
            UsernameToken usernameToken = this.createWSSEUsernameToken(username, password, doc);
            result = this.toString(usernameToken.getElement().getFirstChild().getParentNode());
        }
        return result;
    }

    public Element getUsernameTokenElement(Map<String, Object> ctx) {
        Document doc = DOMUtils.createDocument();
        Element result = null;
        UsernameToken usernameToken = null;
        String username = (String)ctx.get("security.username");
        String password = (String)ctx.get("security.password");
        if (username != null) {
            usernameToken = this.createWSSEUsernameToken(username, password, doc);
            result = usernameToken.getElement();
        }
        return result;
    }

    public Element getUsernameTokenElement(String username, String password) {
        Document doc = DOMUtils.createDocument();
        Element result = null;
        UsernameToken usernameToken = null;
        if (username != null) {
            usernameToken = this.createWSSEUsernameToken(username, password, doc);
            result = usernameToken.getElement();
        }
        return result;
    }

    private UsernameToken createWSSEUsernameToken(String username, String password, Document doc) {
        UsernameToken usernameToken = new UsernameToken(true, doc, password == null ? null : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        usernameToken.setName(username);
        usernameToken.addWSUNamespace();
        usernameToken.addWSSENamespace();
        usernameToken.setID("id-" + username);
        if (password != null) {
            usernameToken.setPassword(password);
        }
        return usernameToken;
    }

    private String toString(Node node) {
        String str = null;
        if (node != null) {
            DOMImplementationLS lsImpl = (DOMImplementationLS)node.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
            LSSerializer serializer = lsImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            str = serializer.writeToString(node);
        }
        return str;
    }
}

