/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.voideddocument;

import java.util.Arrays;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.types.DocumentRequiredAction;
import org.openfact.pe.models.utils.SunatTypeToModel;
import org.openfact.pe.ubl.types.SunatRequiredAction;
import org.openfact.pe.ubl.types.TipoDocumentoRelacionadoPercepcionRetencion;
import org.openfact.pe.ubl.ubl21.voided.VoidedDocumentsType;
import org.openfact.pe.ubl.ubl21.voideddocument.AbstractVoidedDocumentProvider;
import org.openfact.pe.ubl.ubl21.voideddocument.UBLVoidedDocumentCustomizator;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="VOIDED_DOCUMENTS")
public class SunatUBLVoidedDocumentCustomizator
extends AbstractVoidedDocumentProvider
implements UBLVoidedDocumentCustomizator {
    @Inject
    private SunatTypeToModel typeToModel;
    @Inject
    private DocumentProvider documentProvider;

    public void config(OrganizationModel organization, DocumentModel document, Object o) {
        VoidedDocumentsType voidedDocumentsType = SunatUBLVoidedDocumentCustomizator.resolve(o);
        this.typeToModel.importVoidedDocument(organization, document, voidedDocumentsType);
        if (voidedDocumentsType.getVoidedDocumentsLine() != null && !voidedDocumentsType.getVoidedDocumentsLine().isEmpty()) {
            voidedDocumentsType.getVoidedDocumentsLine().stream().forEach(c -> {
                DocumentModel attachedDocument;
                String attachedDocumentId = c.getDocumentSerialID().getValue() + "-" + c.getDocumentNumberID().getValue();
                String attachedDocumentCodeType = c.getDocumentTypeCode().getValue();
                Optional<TipoDocumentoRelacionadoPercepcionRetencion> tipoDocumentoRelacionadoPercepcion = Arrays.stream(TipoDocumentoRelacionadoPercepcionRetencion.values()).filter(p -> p.getCodigo().equals(attachedDocumentCodeType)).findAny();
                if (tipoDocumentoRelacionadoPercepcion.isPresent() && (attachedDocument = this.documentProvider.getDocumentByTypeAndDocumentId(tipoDocumentoRelacionadoPercepcion.get().getDocumentType(), attachedDocumentId, organization)) != null) {
                    document.addAttachedDocument(attachedDocument);
                }
            });
        }
    }

    public DocumentRequiredAction[] getRequiredActions() {
        return new DocumentRequiredAction[]{DocumentRequiredAction.SEND_TO_CUSTOMER, DocumentRequiredAction.SEND_TO_THIRD_PARTY};
    }

    public String[] getExtraRequiredActions() {
        return new String[]{SunatRequiredAction.CONSULTAR_TICKET.toString()};
    }
}

