/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.perception;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.common.converts.StringUtils;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.ScrollModel;
import org.openfact.pe.ubl.types.SunatDocumentType;
import org.openfact.pe.ubl.types.TipoComprobante;
import org.openfact.pe.ubl.ubl21.factories.SunatMarshallerUtils;
import org.openfact.pe.ubl.ubl21.perception.UBLPerceptionIDGenerator;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="PERCEPTION")
public class SunatUBLPerceptionIDGenerator
implements UBLPerceptionIDGenerator {
    @Inject
    private DocumentProvider documentProvider;

    public String generateID(OrganizationModel organization, Object o) {
        TipoComprobante perceptionCode = TipoComprobante.PERCEPCION;
        DocumentModel lastPerception = null;
        ScrollModel perceptions = this.documentProvider.createQuery(organization).documentType(new String[]{SunatDocumentType.PERCEPTION.toString()}).entityQuery().orderByDesc(new String[]{"documentId"}).resultScroll().getScrollResult(10);
        Iterator iterator = perceptions.iterator();
        Pattern pattern = Pattern.compile(perceptionCode.getMask());
        while (iterator.hasNext()) {
            DocumentModel perception = (DocumentModel)iterator.next();
            String documentId = perception.getDocumentId();
            Matcher matcher = pattern.matcher(documentId);
            if (!matcher.find()) continue;
            lastPerception = perception;
            break;
        }
        int series = 0;
        int number = 0;
        if (lastPerception != null) {
            String[] splits = lastPerception.getDocumentId().split("-");
            series = Integer.parseInt(splits[0].substring(1));
            number = Integer.parseInt(splits[1]);
        }
        int nextNumber = SunatMarshallerUtils.getNextNumber((int)number, (int)99999999);
        int nextSeries = SunatMarshallerUtils.getNextSerie((int)series, (int)number, (int)999, (int)99999999);
        StringBuilder documentId = new StringBuilder();
        documentId.append(perceptionCode.getMask().substring(2, 3));
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextSeries), (int)3, (String)"0"));
        documentId.append("-");
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextNumber), (int)8, (String)"0"));
        return documentId.toString();
    }
}

