/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.perception;

import java.util.Arrays;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.types.DocumentRequiredAction;
import org.openfact.pe.models.utils.SunatTypeToModel;
import org.openfact.pe.ubl.types.TipoDocumentoRelacionadoPercepcionRetencion;
import org.openfact.pe.ubl.ubl21.perception.AbstractPerceptionProvider;
import org.openfact.pe.ubl.ubl21.perception.PerceptionType;
import org.openfact.pe.ubl.ubl21.perception.UBLPerceptionCustomizationProvider;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="PERCEPTION")
public class SunatUBLPerceptionCustomizator
extends AbstractPerceptionProvider
implements UBLPerceptionCustomizationProvider {
    @Inject
    private SunatTypeToModel typeToModel;
    @Inject
    private DocumentProvider documentProvider;

    public void config(OrganizationModel organization, DocumentModel document, Object o) {
        PerceptionType perceptionType = SunatUBLPerceptionCustomizator.resolve(o);
        this.typeToModel.importPerception(organization, document, perceptionType);
        if (perceptionType.getSunatPerceptionDocumentReference() != null && !perceptionType.getSunatPerceptionDocumentReference().isEmpty()) {
            perceptionType.getSunatPerceptionDocumentReference().stream().forEach(c -> {
                DocumentModel attachedDocument;
                String attachedDocumentId = c.getId().getValue();
                String attachedDocumentCodeType = c.getId().getSchemeID();
                Optional<TipoDocumentoRelacionadoPercepcionRetencion> tipoDocumentoRelacionadoPercepcion = Arrays.stream(TipoDocumentoRelacionadoPercepcionRetencion.values()).filter(p -> p.getCodigo().equals(attachedDocumentCodeType)).findAny();
                if (tipoDocumentoRelacionadoPercepcion.isPresent() && (attachedDocument = this.documentProvider.getDocumentByTypeAndDocumentId(tipoDocumentoRelacionadoPercepcion.get().getDocumentType(), attachedDocumentId, organization)) != null) {
                    document.addAttachedDocument(attachedDocument);
                }
            });
        }
    }

    public DocumentRequiredAction[] getRequiredActions() {
        return new DocumentRequiredAction[]{DocumentRequiredAction.SEND_TO_THIRD_PARTY};
    }

    public String[] getExtraRequiredActions() {
        return new String[0];
    }
}

