/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.invoice;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import org.openfact.common.converts.StringUtils;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.ModelRuntimeException;
import org.openfact.models.OrganizationModel;
import org.openfact.models.ScrollModel;
import org.openfact.models.types.DocumentType;
import org.openfact.pe.ubl.types.TipoInvoice;
import org.openfact.pe.ubl.ubl21.factories.SunatMarshallerUtils;
import org.openfact.pe.ubl.ubl21.invoice.AbstractInvoiceProvider;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.invoice.UBLInvoiceIDGenerator;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="INVOICE")
public class SunatUBLInvoiceIDGenerator
extends AbstractInvoiceProvider
implements UBLInvoiceIDGenerator {
    @Inject
    private DocumentProvider documentProvider;

    public String generateID(OrganizationModel organization, Object o) {
        TipoInvoice tipoInvoice;
        InvoiceType invoiceType = SunatUBLInvoiceIDGenerator.resolve(o);
        String invoiceTypeCode = invoiceType.getInvoiceTypeCodeValue();
        if (TipoInvoice.FACTURA.getCodigo().equals(invoiceTypeCode)) {
            tipoInvoice = TipoInvoice.FACTURA;
        } else if (TipoInvoice.BOLETA.getCodigo().equals(invoiceTypeCode)) {
            tipoInvoice = TipoInvoice.BOLETA;
        } else {
            throw new ModelRuntimeException("Invalid invoice type code");
        }
        DocumentModel lastInvoice = null;
        ScrollModel invoices = this.documentProvider.createQuery(organization).documentType(new String[]{DocumentType.INVOICE.toString()}).entityQuery().orderByDesc(new String[]{"documentId"}).resultScroll().getScrollResult(10);
        Iterator iterator = invoices.iterator();
        Pattern pattern = Pattern.compile(tipoInvoice.getDocumentIdPattern());
        while (iterator.hasNext()) {
            DocumentModel invoice = (DocumentModel)iterator.next();
            String documentId = invoice.getDocumentId();
            Matcher matcher = pattern.matcher(documentId);
            if (!matcher.find()) continue;
            lastInvoice = invoice;
            break;
        }
        int series = 0;
        int number = 0;
        if (lastInvoice != null) {
            String[] splits = lastInvoice.getDocumentId().split("-");
            series = Integer.parseInt(splits[0].substring(1));
            number = Integer.parseInt(splits[1]);
        }
        int nextNumber = SunatMarshallerUtils.getNextNumber((int)number, (int)99999999);
        int nextSeries = SunatMarshallerUtils.getNextSerie((int)series, (int)number, (int)999, (int)99999999);
        StringBuilder documentId = new StringBuilder();
        documentId.append(tipoInvoice.getDocumentIdPattern().substring(2, 3));
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextSeries), (int)3, (String)"0"));
        documentId.append("-");
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextNumber), (int)8, (String)"0"));
        return documentId.toString();
    }
}

