/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.debitnote;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.inject.Inject;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ResponseType;
import oasis.names.specification.ubl.schema.xsd.debitnote_21.DebitNoteType;
import org.openfact.common.converts.StringUtils;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.ScrollModel;
import org.openfact.models.types.DocumentType;
import org.openfact.pe.ubl.types.TipoComprobante;
import org.openfact.pe.ubl.ubl21.debitnote.AbstractDebitNoteProvider;
import org.openfact.pe.ubl.ubl21.factories.SunatMarshallerUtils;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.debitnote.UBLDebitNoteIDGenerator;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="DEBIT_NOTE")
public class SunatUBLDebitNoteIDGenerator
extends AbstractDebitNoteProvider
implements UBLDebitNoteIDGenerator {
    @Inject
    private DocumentProvider documentProvider;

    public String generateID(OrganizationModel organization, Object o) {
        DebitNoteType debitNoteType = SunatUBLDebitNoteIDGenerator.resolve(o);
        String invoiceDocumentReferenceID = null;
        if (debitNoteType.getDiscrepancyResponseCount() > 0) {
            invoiceDocumentReferenceID = ((ResponseType)debitNoteType.getDiscrepancyResponse().get(0)).getReferenceIDValue();
        } else if (debitNoteType.getBillingReferenceCount() > 0) {
            invoiceDocumentReferenceID = ((BillingReferenceType)debitNoteType.getBillingReference().get(0)).getInvoiceDocumentReference().getIDValue();
        }
        TipoComprobante tipoComprobante = TipoComprobante.NOTA_DEBITO;
        DocumentModel lastDebitNote = null;
        ScrollModel debitNotes = this.documentProvider.createQuery(organization).documentType(new DocumentType[]{DocumentType.DEBIT_NOTE}).entityQuery().orderByDesc(new String[]{"documentId"}).resultScroll().getScrollResult(10);
        Iterator iterator = debitNotes.iterator();
        Pattern pattern = Pattern.compile(tipoComprobante.getMask());
        while (iterator.hasNext()) {
            DocumentModel debitNote = (DocumentModel)iterator.next();
            String documentId = debitNote.getDocumentId();
            Matcher matcher = pattern.matcher(documentId);
            if (!matcher.find()) continue;
            lastDebitNote = debitNote;
            break;
        }
        int series = 0;
        int number = 0;
        if (lastDebitNote != null) {
            String[] splits = lastDebitNote.getDocumentId().split("-");
            series = Integer.parseInt(splits[0].substring(1));
            number = Integer.parseInt(splits[1]);
        }
        int nextNumber = SunatMarshallerUtils.getNextNumber((int)number, (int)99999999);
        int nextSeries = SunatMarshallerUtils.getNextSerie((int)series, (int)number, (int)999, (int)99999999);
        StringBuilder documentId = new StringBuilder();
        documentId.append(invoiceDocumentReferenceID.substring(0, 1));
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextSeries), (int)3, (String)"0"));
        documentId.append("-");
        documentId.append(StringUtils.padLeft((String)String.valueOf(nextNumber), (int)8, (String)"0"));
        return documentId.toString();
    }
}

