/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.ubl21.creditnote;

import javax.ejb.Stateless;
import javax.inject.Inject;
import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import org.openfact.models.DocumentModel;
import org.openfact.models.DocumentProvider;
import org.openfact.models.OrganizationModel;
import org.openfact.models.types.DocumentRequiredAction;
import org.openfact.models.types.DocumentType;
import org.openfact.models.utils.TypeToModel;
import org.openfact.pe.ubl.ubl21.creditnote.AbstractCreditNoteProvider;
import org.openfact.provider.ProviderType;
import org.openfact.ubl.ubl21.creditnote.UBLCreditNoteCustomizator;
import org.openfact.ubl.ubl21.qualifiers.UBLDocumentType;

@Stateless
@ProviderType(value="sunat")
@UBLDocumentType(value="CREDIT_NOTE")
public class SunatUBLCreditNoteCustomizator
extends AbstractCreditNoteProvider
implements UBLCreditNoteCustomizator {
    @Inject
    private TypeToModel typeToModel;
    @Inject
    private DocumentProvider documentProvider;

    public void config(OrganizationModel organization, DocumentModel document, Object o) {
        CreditNoteType creditNoteType = SunatUBLCreditNoteCustomizator.resolve(o);
        this.typeToModel.importCreditNote(organization, document, creditNoteType);
        if (creditNoteType.getBillingReference() != null && !creditNoteType.getBillingReference().isEmpty()) {
            creditNoteType.getBillingReference().stream().filter(p -> p.getInvoiceDocumentReference() != null).forEach(c -> {
                String invoiceDocumentId = c.getInvoiceDocumentReference().getIDValue();
                DocumentModel attachedDocument = this.documentProvider.getDocumentByTypeAndDocumentId(DocumentType.INVOICE, invoiceDocumentId, organization);
                if (attachedDocument != null) {
                    document.addAttachedDocument(attachedDocument);
                }
            });
        }
    }

    public DocumentRequiredAction[] getRequiredActions() {
        return new DocumentRequiredAction[]{DocumentRequiredAction.SEND_TO_CUSTOMER, DocumentRequiredAction.SEND_TO_THIRD_PARTY};
    }

    public String[] getExtraRequiredActions() {
        return new String[0];
    }
}

