/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.pe.ubl.data.xml;

import com.google.common.base.Verify;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openfact.JSONObjectUtils;
import org.openfact.pe.ubl.data.xml.entity.XmlSUNATPerceptionDocumentReference;
import org.openfact.pe.ubl.data.xml.entity.XmlSUNATRetentionDocumentReference;
import org.openfact.pe.ubl.data.xml.entity.XmlSUNATVoidedDocumentLine;
import org.openfact.pe.ubl.types.TipoConceptosTributarios;
import org.openfact.ubl.data.xml.XMLAttributeContainer;
import org.openfact.ubl.data.xml.XmlConverter;

public enum SunatXmlSupportedAttribute {
    SUNAT_TOTAL_VALOR_VENTA_OPERACIONES_GRAVADAS(XMLAttributeContainer.simpleKey(value -> {
        if (value == null) {
            return null;
        }
        return SunatXmlSupportedAttribute.getSunatAdditionalMonetaryTotal(value, TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_GRAVADAS);
    }, (String[])new String[]{"UBLExtensions", "UBLExtension"})),
    SUNAT_TOTAL_VALOR_VENTA_OPERACIONES_EXONERADAS(XMLAttributeContainer.simpleKey(value -> {
        if (value == null) {
            return null;
        }
        return SunatXmlSupportedAttribute.getSunatAdditionalMonetaryTotal(value, TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_EXONERADAS);
    }, (String[])new String[]{"UBLExtensions", "UBLExtension"})),
    SUNAT_TOTAL_VALOR_VENTA_OPERACIONES_INAFECTAS(XMLAttributeContainer.simpleKey(value -> {
        if (value == null) {
            return null;
        }
        return SunatXmlSupportedAttribute.getSunatAdditionalMonetaryTotal(value, TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_INAFECTAS);
    }, (String[])new String[]{"UBLExtensions", "UBLExtension"})),
    SUNAT_TOTAL_VALOR_VENTA_OPERACIONES_GRATUITAS(XMLAttributeContainer.simpleKey(value -> {
        if (value == null) {
            return null;
        }
        return SunatXmlSupportedAttribute.getSunatAdditionalMonetaryTotal(value, TipoConceptosTributarios.TOTAL_VALOR_VENTA_OPERACIONES_GRATUITAS);
    }, (String[])new String[]{"UBLExtensions", "UBLExtension"})),
    SUNAT_AP_PARTY_IDENTIFICATION_ID(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PartyIdentification", "ID", "content"})),
    SUNAT_AP_PARTY_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PartyName", "Name"})),
    SUNAT_AP_POSTAL_ADDRESS_ID(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "ID"})),
    SUNAT_AP_POSTAL_ADDRESS_STREET_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "StreetName"})),
    SUNAT_AP_POSTAL_ADDRESS_CITY_SUBDIVISION_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "CitySubdivisionName"})),
    SUNAT_AP_POSTAL_ADDRESS_CITY_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "CityName"})),
    SUNAT_AP_POSTAL_ADDRESS_CITY_SUBENTITY(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "CountrySubentity"})),
    SUNAT_AP_POSTAL_ADDRESS_DISTRICT(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "District"})),
    SUNAT_AP_POSTAL_ADDRESS_COUNTRY_IDENTIFICATION_CODE(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PostalAddress", "Country", "IdentificationCode"})),
    SUNAT_AP_LEGAL_ENTITY_REGISTRATION_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"AgentParty", "PartyLegalEntity", "RegistrationName"})),
    SUNAT_RP_PARTY_IDENTIFICATION_ID(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PartyIdentification", "ID", "content"})),
    SUNAT_RP_PARTY_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PartyName", "Name"})),
    SUNAT_RP_POSTAL_ADDRESS_ID(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "ID"})),
    SUNAT_RP_POSTAL_ADDRESS_STREET_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "StreetName"})),
    SUNAT_RP_POSTAL_ADDRESS_CITY_SUBDIVISION_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "CitySubdivisionName"})),
    SUNAT_RP_POSTAL_ADDRESS_CITY_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "CityName"})),
    SUNAT_RP_POSTAL_ADDRESS_CITY_SUBENTITY(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "CountrySubentity"})),
    SUNAT_RP_POSTAL_ADDRESS_DISTRICT(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "District"})),
    SUNAT_RP_POSTAL_ADDRESS_COUNTRY_IDENTIFICATION_CODE(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PostalAddress", "Country", "IdentificationCode"})),
    SUNAT_RP_LEGAL_ENTITY_REGISTRATION_NAME(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"ReceiverParty", "PartyLegalEntity", "RegistrationName"})),
    SUNAT_TOTAL_INVOICE_AMOUNT(XMLAttributeContainer.simpleKey(value -> value != null ? new BigDecimal(String.valueOf(value)) : null, (String[])new String[]{"TotalInvoiceAmount", "content"})),
    SUNAT_TOTAL_INVOICE_CURRENCY_CODE(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"TotalInvoiceAmount", "currencyID"})),
    SUNAT_TOTAL_CASHED(XMLAttributeContainer.simpleKey(value -> value != null ? new BigDecimal(String.valueOf(value)) : null, (String[])new String[]{"SUNATTotalCashed", "content"})),
    SUNAT_TOTAL_CASHED_CURRENCY_CODE(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"SUNATTotalCashed", "currencyID"})),
    SUNAT_PERCEPTION_DOCUMENT_REFERENCE(XMLAttributeContainer.objectArrayKey(XmlSUNATPerceptionDocumentReference.class, (String[])new String[]{"SUNATPerceptionDocumentReference"})),
    SUNAT_TOTAL_PAID(XMLAttributeContainer.simpleKey(value -> value != null ? new BigDecimal(String.valueOf(value)) : null, (String[])new String[]{"SUNATTotalPaid", "content"})),
    SUNAT_TOTAL_PAID_CURRENCY_CODE(XMLAttributeContainer.simpleKey(value -> value != null ? String.valueOf(value) : null, (String[])new String[]{"SUNATTotalPaid", "currencyID"})),
    SUNAT_RETENTION_DOCUMENT_REFERENCE(XMLAttributeContainer.objectArrayKey(XmlSUNATRetentionDocumentReference.class, (String[])new String[]{"SUNATRetentionDocumentReference"})),
    SUNAT_VOIDED_DOCUMENTS_LINE(XMLAttributeContainer.objectArrayKey(XmlSUNATVoidedDocumentLine.class, (String[])new String[]{"VoidedDocumentsLine"}));

    private XmlConverter converter;

    private SunatXmlSupportedAttribute(XmlConverter converter) {
        this.converter = converter;
    }

    public Object asObject(JSONObject json) {
        Verify.verifyNotNull((Object)this.converter);
        return this.converter.asObject(json);
    }

    public static SunatXmlSupportedAttribute fromString(String text) {
        Optional<SunatXmlSupportedAttribute> op = Arrays.stream(SunatXmlSupportedAttribute.values()).filter(p -> p.toString().equals(text)).findFirst();
        return op.isPresent() ? op.get() : null;
    }

    public static BigDecimal getSunatAdditionalMonetaryTotal(Object value, TipoConceptosTributarios tipoConcepto) {
        BigDecimal result;
        block6: {
            String codigo;
            block5: {
                JSONArray jsonArray;
                Iterator it;
                if (value instanceof JSONObject) {
                    value = JSONObjectUtils.getObject((JSONObject)((JSONObject)value), (String[])new String[]{"ExtensionContent", "AdditionalInformation", "AdditionalMonetaryTotal"});
                }
                if (value instanceof JSONArray && (it = (jsonArray = (JSONArray)value).iterator()).hasNext()) {
                    value = JSONObjectUtils.getObject((JSONObject)((JSONObject)it.next()), (String[])new String[]{"ExtensionContent", "AdditionalInformation", "AdditionalMonetaryTotal"});
                }
                if (value == null) {
                    return null;
                }
                codigo = tipoConcepto.getCodigo();
                result = null;
                if (!(value instanceof JSONObject)) break block5;
                JSONObject jsonObject = (JSONObject)value;
                String ID = String.valueOf(JSONObjectUtils.getObject((JSONObject)jsonObject, (String[])new String[]{"ID"}));
                if (!codigo.equals(ID)) break block6;
                Object object = JSONObjectUtils.getObject((JSONObject)jsonObject, (String[])new String[]{"PayableAmount", "content"});
                result = new BigDecimal(String.valueOf(object));
                break block6;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                for (JSONObject jsonObject : jsonArray) {
                    String ID = String.valueOf(JSONObjectUtils.getObject((JSONObject)jsonObject, (String[])new String[]{"ID"}));
                    if (!codigo.equals(ID)) continue;
                    Object object = JSONObjectUtils.getObject((JSONObject)jsonObject, (String[])new String[]{"PayableAmount", "content"});
                    result = new BigDecimal(String.valueOf(object));
                    break;
                }
            }
        }
        return result;
    }
}

