/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.client.services;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.openfact.client.services.representations.idm.DocumentRepresentation;
import org.openfact.client.services.representations.idm.DocumentoSunatRepresentation;
import org.openfact.client.services.representations.idm.SearchCriteriaRepresentation;
import org.openfact.client.services.representations.idm.ThirdPartyEmailRepresentation;
import org.openfact.client.services.representations.idm.VoidedRepresentation;

@Path(value="/admin/organizations")
@Consumes(value={"application/json"})
public interface DocumentsService {
    @GET
    @Path(value="/{organizationName}/documents/{id}")
    @Produces(value={"application/json"})
    public Response getDocumentById(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2);

    @GET
    @Path(value="/{organizationName}/documents/{id}/representation/xml")
    @Produces(value={"application/json"})
    public Response getXml(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2);

    @GET
    @Path(value="/{organizationName}/documents/{id}/report")
    @Produces(value={"application/json"})
    public Response getPdf(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/{organizationName}/documents/{id}/send-to-third-party")
    @Produces(value={"application/json"})
    public Response sendToThirdParty(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/{organizationName}/documents/{id}/send-to-third-party-by-email")
    @Produces(value={"application/json"})
    public Response sendToCustomThirdParty(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, ThirdPartyEmailRepresentation var3);

    @POST
    @Path(value="/{organizationName}/documents/search")
    @Produces(value={"application/json"})
    public Response search(@PathParam(value="organizationName") String var1, SearchCriteriaRepresentation var2);

    @GET
    @Path(value="/{organizationName}/sunat/documents/{id}/cdr")
    @Produces(value={"application/json"})
    public Response getCdr(@PathParam(value="organizationName") String var1, @QueryParam(value="id") String var2);

    @GET
    @Path(value="/{organizationName}/sunat/documents/{id}/check-ticket")
    @Produces(value={"application/json"})
    public Response checkTicket(@PathParam(value="organizationName") String var1, @QueryParam(value="id") String var2);

    @POST
    @Path(value="/{organizationName}/sunat/documents/invoices")
    @Produces(value={"application/json"})
    public Response createInvoice(@PathParam(value="organizationName") String var1, DocumentRepresentation var2, @QueryParam(value="async") boolean var3);

    @POST
    @Path(value="/{organizationName}/sunat/documents/invoices")
    @Produces(value={"application/json"})
    public Response createInvoiceFromString(@PathParam(value="organizationName") String var1, String var2, @QueryParam(value="async") boolean var3);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/invoices/{id}")
    @Produces(value={"application/json"})
    public Response updateInvoice(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, DocumentRepresentation var3, @QueryParam(value="async") boolean var4);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/invoices/{id}")
    @Produces(value={"application/json"})
    public Response updateInvoiceFromString(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, String var3, @QueryParam(value="async") boolean var4);

    @POST
    @Path(value="/{organizationName}/sunat/documents/credit-notes")
    @Produces(value={"application/json"})
    public Response createCreditNote(@PathParam(value="organizationName") String var1, DocumentRepresentation var2, @QueryParam(value="async") boolean var3);

    @POST
    @Path(value="/{organizationName}/sunat/documents/credit-notes")
    @Produces(value={"application/json"})
    public Response createCreditNoteFromString(@PathParam(value="organizationName") String var1, String var2, @QueryParam(value="async") boolean var3);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/credit-notes/{id}")
    @Produces(value={"application/json"})
    public Response updateCreditNote(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, DocumentRepresentation var3, @QueryParam(value="async") boolean var4);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/credit-notes/{id}")
    @Produces(value={"application/json"})
    public Response updateCreditNoteFromString(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, String var3, @QueryParam(value="async") boolean var4);

    @POST
    @Path(value="/{organizationName}/sunat/documents/debit-notes")
    @Produces(value={"application/json"})
    public Response createDebitNote(@PathParam(value="organizationName") String var1, DocumentRepresentation var2, @QueryParam(value="async") boolean var3);

    @POST
    @Path(value="/{organizationName}/sunat/documents/debit-notes")
    @Produces(value={"application/json"})
    public Response createDebitNoteFromString(@PathParam(value="organizationName") String var1, String var2, @QueryParam(value="async") boolean var3);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/debit-notes/{id}")
    @Produces(value={"application/json"})
    public Response updateDebitNote(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, DocumentRepresentation var3, @QueryParam(value="async") boolean var4);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/debit-notes/{id}")
    @Produces(value={"application/json"})
    public Response updateDebitNoteFromString(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, String var3, @QueryParam(value="async") boolean var4);

    @POST
    @Path(value="/{organizationName}/sunat/documents/perceptions")
    @Produces(value={"application/json"})
    public Response createPerception(@PathParam(value="organizationName") String var1, DocumentoSunatRepresentation var2, @QueryParam(value="async") boolean var3);

    @POST
    @Path(value="/{organizationName}/sunat/documents/perceptions")
    @Produces(value={"application/json"})
    public Response createPerceptionFromString(@PathParam(value="organizationName") String var1, String var2, @QueryParam(value="async") boolean var3);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/perceptions/{id}")
    @Produces(value={"application/json"})
    public Response updatePerception(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, DocumentoSunatRepresentation var3, @QueryParam(value="async") boolean var4);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/perceptions/{id}")
    @Produces(value={"application/json"})
    public Response updatePerceptionFromString(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, String var3, @QueryParam(value="async") boolean var4);

    @POST
    @Path(value="/{organizationName}/sunat/documents/retentions")
    @Produces(value={"application/json"})
    public Response createRetention(@PathParam(value="organizationName") String var1, DocumentoSunatRepresentation var2, @QueryParam(value="async") boolean var3);

    @POST
    @Path(value="/{organizationName}/sunat/documents/retentions")
    @Produces(value={"application/json"})
    public Response createRetentionFromString(@PathParam(value="organizationName") String var1, String var2, @QueryParam(value="async") boolean var3);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/retentions/{id}")
    @Produces(value={"application/json"})
    public Response updateRetention(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, DocumentoSunatRepresentation var3, @QueryParam(value="async") boolean var4);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/retentions/{id}")
    @Produces(value={"application/json"})
    public Response updateRetentionFromString(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, String var3, @QueryParam(value="async") boolean var4);

    @POST
    @Path(value="/{organizationName}/sunat/documents/voided-documents")
    @Produces(value={"application/json"})
    public Response createVoidedDocument(@PathParam(value="organizationName") String var1, VoidedRepresentation var2, @QueryParam(value="async") boolean var3);

    @POST
    @Path(value="/{organizationName}/sunat/documents/voided-documents")
    @Produces(value={"application/json"})
    public Response createVoidedDocumentFromString(@PathParam(value="organizationName") String var1, String var2, @QueryParam(value="async") boolean var3);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/voided-documents/{id}")
    @Produces(value={"application/json"})
    public Response updateVoidedDocument(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, VoidedRepresentation var3, @QueryParam(value="async") boolean var4);

    @PUT
    @Path(value="/{organizationName}/sunat/documents/voided-documents/{id}")
    @Produces(value={"application/json"})
    public Response updateVoidedDocumentFromString(@PathParam(value="organizationName") String var1, @PathParam(value="id") String var2, String var3, @QueryParam(value="async") boolean var4);
}

