/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.client.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.openfact.client.oauth.AccessTokenResponse;

public class TokenManager {
    private static int offset;
    private static final long DEFAULT_MIN_VALIDITY = 30L;
    private final ResteasyWebTarget target;
    private final String clientId;
    private String refreshToken;
    private AccessTokenResponse accessToken;
    private long expirationTime;

    public TokenManager(String clientId, String tokenServerUrl) {
        this.clientId = clientId;
        ResteasyClient client = new ResteasyClientBuilder().build();
        this.target = client.target(tokenServerUrl);
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public AccessTokenResponse getAccessToken() {
        if (this.refreshToken == null) {
            return null;
        }
        if (this.accessToken == null || this.tokenExpired()) {
            this.refreshToken();
        }
        return this.accessToken;
    }

    public synchronized void invalidate(String token) {
        if (this.accessToken == null) {
            return;
        }
        if (token.equals(this.accessToken.getToken())) {
            this.expirationTime = -1L;
        }
    }

    private boolean tokenExpired() {
        return (long)this.currentTime() + 30L >= this.expirationTime;
    }

    private void refreshToken() {
        Form form = new Form();
        form.param("grant_type", "refresh_token");
        form.param("refresh_token", this.refreshToken);
        form.param("client_id", this.clientId);
        int requestTime = this.currentTime();
        Response response = this.target.request().post(Entity.form((Form)form));
        this.accessToken = TokenManager.getAccessTokenFromResponse(response);
        if (this.accessToken != null) {
            this.expirationTime = (long)requestTime + this.accessToken.getExpiresIn();
        }
    }

    private int currentTime() {
        return (int)(System.currentTimeMillis() / 1000L) + offset;
    }

    public static AccessTokenResponse getAccessTokenFromResponse(Response response) {
        if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            String responseString = (String)response.readEntity(String.class);
            ObjectMapper mapper = new ObjectMapper();
            try {
                return (AccessTokenResponse)mapper.readValue(responseString, AccessTokenResponse.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not parse token");
            }
        }
        return null;
    }
}

