/*
 * Decompiled with CFR 0.152.
 */
package org.openfact.common.converts;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return DateUtils.asLocalDate(date, ZoneId.systemDefault());
    }

    public static LocalDate asLocalDate(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date) {
            return ((java.sql.Date)date).toLocalDate();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return DateUtils.asLocalDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime asLocalDateTime(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            return ((Timestamp)date).toLocalDateTime();
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(zone).toLocalDateTime();
    }

    public static Date asUtilDate(Object date) {
        return DateUtils.asUtilDate(date, ZoneId.systemDefault());
    }

    public static Date asUtilDate(Object date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        if (date instanceof java.sql.Date || date instanceof Timestamp) {
            return new Date(((Date)date).getTime());
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof LocalDate) {
            return Date.from(((LocalDate)date).atStartOfDay(zone).toInstant());
        }
        if (date instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)date).atZone(zone).toInstant());
        }
        if (date instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)date).toInstant());
        }
        if (date instanceof Instant) {
            return Date.from((Instant)date);
        }
        throw new UnsupportedOperationException("Don't know hot to convert " + date.getClass().getName() + " to java.utils.Date");
    }

    public static Instant asInstant(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime());
    }

    public static ZonedDateTime asZonedDateTime(Date date) {
        return DateUtils.asZonedDateTime(date, ZoneId.systemDefault());
    }

    public static ZonedDateTime asZonedDateTime(Date date, ZoneId zone) {
        if (date == null) {
            return null;
        }
        return DateUtils.asInstant(date).atZone(zone);
    }

    public static LocalDateTime getDateTimeFromTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(timestamp), TimeZone.getDefault().toZoneId());
    }

    public static LocalDate asLocalDate(String date) {
        DateTimeFormatter formatter;
        if (date.contains("/")) {
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        } else if (date.contains("-")) {
            formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        } else {
            return null;
        }
        return LocalDate.parse(date, formatter);
    }

    public static LocalDateTime asLocalDateTime(String date) {
        DateTimeFormatter formatter;
        if (date.contains("/")) {
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        } else if (date.contains("-")) {
            formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        } else {
            return null;
        }
        return LocalDateTime.parse(date, formatter);
    }
}

