/*
 * Decompiled with CFR 0.152.
 */
package org.sistcoop.admin.client;

import java.net.URI;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.sistcoop.admin.client.Config;
import org.sistcoop.admin.client.resource.OrganizationResource;
import org.sistcoop.admin.client.resource.OrganizationsResource;

public class Openfact {
    private final Config config;
    private final Keycloak keycloakClient;
    private final ResteasyWebTarget target;
    private final ResteasyClient client;

    Openfact(String serverUrl, Keycloak keycloakClient, ResteasyClient resteasyClient) {
        this.config = new Config(serverUrl);
        this.client = resteasyClient != null ? resteasyClient : new ResteasyClientBuilder().connectionPoolSize(10).build();
        this.keycloakClient = keycloakClient;
        this.client.register((Object)this.newAuthFilter());
        this.target = this.client.target(this.config.getServerUrl());
    }

    private BearerAuthFilter newAuthFilter() {
        return new BearerAuthFilter(this.keycloakClient.tokenManager());
    }

    public ResteasyWebTarget target(String uri) {
        return this.client.target(uri);
    }

    public OrganizationsResource organizations() {
        return (OrganizationsResource)this.target.proxy(OrganizationsResource.class);
    }

    public OrganizationResource organization(String organizationName) {
        return this.organizations().organization(organizationName);
    }

    public <T> T proxy(Class<T> proxyClass, URI absoluteURI) {
        return (T)this.client.target(absoluteURI).proxy(proxyClass);
    }

    public void close() {
        this.client.close();
    }
}

