/*
 * Decompiled with CFR 0.152.
 */
package org.sistcoop.admin.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.sistcoop.admin.client.Openfact;
import org.sistcoop.admin.client.OpenfactBuilder;
import org.sistcoop.admin.client.resource.OrganizationsResource;

public class OpenfactClient {
    private Openfact openfact;
    private static final Properties ofProperties = new Properties();
    private static final Properties kcProperties = new Properties();

    private OpenfactClient() throws IOException {
        this(ofProperties.getProperty("serverUrl"));
    }

    private OpenfactClient(String serverUrl) throws IOException {
        Keycloak keycloak = KeycloakBuilder.builder().serverUrl(kcProperties.getProperty("serverUrl")).realm(kcProperties.getProperty("realm")).username(kcProperties.getProperty("username")).password(kcProperties.getProperty("password")).clientId(kcProperties.getProperty("clientId")).clientSecret(kcProperties.getProperty("clientSecret")).build();
        this.openfact = OpenfactBuilder.builder().serverUrl(serverUrl).keycloakClient(keycloak).build();
    }

    private OpenfactClient(String serverUrl, Keycloak keycloak) throws IOException {
        this.openfact = OpenfactBuilder.builder().serverUrl(serverUrl).keycloakClient(keycloak).build();
    }

    public static OpenfactClient buildTarget() {
        try {
            return new OpenfactClient();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static OpenfactClient buildTarget(String serverUrl) {
        try {
            return new OpenfactClient(serverUrl);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static OpenfactClient buildTarget(String serverUrl, Keycloak keycloak) {
        try {
            return new OpenfactClient(serverUrl, keycloak);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public OrganizationsResource organizations() {
        return this.openfact.organizations();
    }

    public ResteasyWebTarget target(String uri) {
        return this.openfact.target(uri);
    }

    public Openfact getOpenfact() {
        return this.openfact;
    }

    static {
        InputStream ofIs = OpenfactClient.class.getClassLoader().getResourceAsStream("META-INF/openfact.properties");
        InputStream kcIs = OpenfactClient.class.getClassLoader().getResourceAsStream("META-INF/keycloak.properties");
        try {
            if (ofIs != null) {
                ofProperties.load(ofIs);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid Openfact configuration");
        }
        try {
            if (kcIs != null) {
                kcProperties.load(kcIs);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid Keycloak configuration");
        }
    }
}

