/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.simplify4u.plugins.sign.SignMojoException;
import org.simplify4u.plugins.sign.SignResult;
import org.simplify4u.plugins.sign.openpgp.PGPKeyInfo;
import org.simplify4u.plugins.sign.openpgp.PGPSigner;

public abstract class ArtifactSigner {
    @Inject
    protected MavenProject project;
    @Inject
    protected PGPSigner pgpSigner;

    protected static void verifyArtifact(Artifact artifact) {
        if (artifact == null) {
            throw new SignMojoException("null artifacts ...");
        }
        if (artifact.getFile() == null) {
            throw new SignMojoException("Artifact: " + artifact + " has no file");
        }
    }

    protected SignResult makeSignature(InputStream inputStream, String artifactId, String classifier, String version, String extension) {
        String targetExt = extension + ".asc";
        String targetName = artifactId + '-' + version;
        if (classifier != null && !classifier.isEmpty()) {
            targetName = targetName + "-" + classifier;
        }
        targetName = targetName + "." + targetExt;
        Path target = Paths.get(this.project.getBuild().getDirectory(), targetName);
        this.pgpSigner.sign(inputStream, target);
        return new SignResult(classifier, targetExt, target.toFile());
    }

    public void setKeyInfo(PGPKeyInfo pgpKeyInfo) {
        this.pgpSigner.setKeyInfo(pgpKeyInfo);
    }

    public abstract List<SignResult> signArtifact(Artifact var1);
}

